#ifndef _UDM_SYSLOG_H
#define _UDM_SYSLOG_H

#include "config.h"

typedef struct _code {
        char    *c_name;
        int     c_val;
} CODE;
extern int loglevel;
extern int is_log_open;

/* Verbose levels */
#define ERROR		1
#define WARNING		2
#define INFO		3
#define EXTRA		4
#define DEBUG		5

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#define LOG_FACILITY LOG_LOCAL7
#else
#define LOG_FACILITY 0
#endif

int syslog_facility(char *f);
int udm_openlog(int log_facility,int log2stderr);
void udm_log(int level, const char *fmt, ...);

#endif
