#include "string.h"
#include "config.h"
#include "charset.h"


static char cp1251[]  = "";
static char koi8r[]   = "ѳ";
static char cp866[]   = "";
static char iso88595[]= "";
static char maccyr[]  = "";

static char *charset_table(char *charset){

	if(!charset)return(0);

	if(!strcasecmp(charset,"windows-1251"))	return(cp1251);
	if(!strcasecmp(charset,"win"))		return(cp1251);
	if(!strcasecmp(charset,"x-cp1251"))	return(cp1251);
	if(!strcasecmp(charset,"cp1251"))	return(cp1251);
	if(!strcasecmp(charset,"cp-1251"))	return(cp1251);

	if(!strcasecmp(charset,"koi8-r"))	return(koi8r);
	if(!strcasecmp(charset,"koi-8-r"))	return(koi8r);
	if(!strcasecmp(charset,"koi8"))		return(koi8r);
	if(!strcasecmp(charset,"koi-8"))	return(koi8r);
	if(!strcasecmp(charset,"koi"))		return(koi8r);

	if(!strcasecmp(charset,"ISO-8859-5"))	return(iso88595);
	if(!strcasecmp(charset,"iso_8859-5:1988"))return(iso88595);
	if(!strcasecmp(charset,"iso-ir-144"))	return(iso88595);
	if(!strcasecmp(charset,"iso_8859-5"))	return(iso88595);
	if(!strcasecmp(charset,"cyrillic"))	return(iso88595);
	if(!strcasecmp(charset,"ISO-8859-5"))	return(iso88595);
	if(!strcasecmp(charset,"iso8859-5"))	return(iso88595);
	if(!strcasecmp(charset,"iso-8859.5"))	return(iso88595);
	if(!strcasecmp(charset,"iso8859.5"))	return(iso88595);
	if(!strcasecmp(charset,"iso"))		return(iso88595);

	if(!strcasecmp(charset,"ibm866"))	return(cp866);
	if(!strcasecmp(charset,"csibm866"))	return(cp866);
	if(!strcasecmp(charset,"866"))		return(cp866);
	if(!strcasecmp(charset,"cp866"))	return(cp866);
	if(!strcasecmp(charset,"x-cp866"))	return(cp866);
	if(!strcasecmp(charset,"x-ibm866"))	return(cp866);
	if(!strcasecmp(charset,"cp-866"))	return(cp866);
	if(!strcasecmp(charset,"alt"))		return(cp866);

	if(!strcasecmp(charset,"x-mac-cyrillic"))return(maccyr);
	return(0);
}

char *recode_string(char *str,char *from,char * to){
char *s,*f,*t,*c;

	if(!(s=str))return(0);
	if(!(f=charset_table(from)))return(str);
	if(!(t=charset_table(to)))return(str);
	if(f==t)return(str);
	while(*s){
		if(c=strchr(f,*s))*s=t[c-f];
		s++;
	}
	return(str);
}


static char koi8_tolower(char c){
char koi8r_lower[]="ţ";
char koi8r_upper[]="";
char *s;
	if(s=strchr(koi8r_upper,c))
		return(koi8r_lower[s-koi8r_upper]);
	else
		return(tolower(c));
}


char *tolower_string(char *str, char *charset){
char *s;
	if(!(s=str))return(NULL);
	while(*s){
		if(charset){
			if(!strcasecmp(charset,"koi8-r"))*s=koi8_tolower(*s);
			else;
		}
		*s=tolower(*s);
		s++;
	}
	return(str);
}



#define SGML_CHAR_NUM 101
static struct
{
    char		*sgml;
    unsigned char	equiv;
} SGMLChars[SGML_CHAR_NUM] =
  {
    { "lt",	      '<' } ,
    { "gt",	      '>' } ,
    { "amp",	      '&' } ,
    { "quot",	      '"' } ,
    { "nbsp",         ' ' } , /* non breaking space */

    { "trade",	      153 } , /* trade mark */
    { "iexcl",        161 } , /* inverted exclamation mark */
    { "cent",         162 } , /* cent sign */
    { "pound",        163 } , /* pound sign */
    { "curren",       164 } , /* currency sign */
    { "yen",          165 } , /* yen sign */
    { "brvbar",       166 } , /* broken vertical bar, (brkbar) */
    { "sect",         167 } , /* section sign */
    { "uml",          168 } , /* spacing diaresis */
    { "copy",         169 } , /* copyright sign */
    { "ordf",         170 } , /* feminine ordinal indicator */
    { "laquo",        171 } , /* angle quotation mark, left */
    { "not",          172 } , /* negation sign */
    { "shy",          173 } , /* soft hyphen */
    { "reg",          174 } , /* circled R registered sign */
    { "hibar",        175 } , /* spacing macron */
    { "deg",          176 } , /* degree sign */
    { "plusmn",       177 } , /* plus-or-minus sign */
    { "sup2",         178 } , /* superscript 2 */
    { "sup3",         179 } , /* superscript 3 */
    { "acute",        180 } , /* spacing acute (96) */
    { "micro",        181 } , /* micro sign */
    { "para",         182 } , /* paragraph sign */
    { "middot",       183 } , /* middle dot */
    { "cedil",        184 } , /* spacing cedilla */
    { "sup1",         185 } , /* superscript 1 */
    { "ordm",         186 } , /* masculine ordinal indicator */
    { "raquo",        187 } , /* angle quotation mark, right */
    { "frac14",       188 } , /* fraction 1/4 */
    { "frac12",       189 } , /* fraction 1/2 */
    { "frac34",       190 } , /* fraction 3/4 */
    { "iquest",       191 } , /* inverted question mark */
    { "Agrave",       192 } , /* capital A, grave accent */ 
    { "Aacute",       193 } , /* capital A, acute accent */ 
    { "Acirc",        194 } , /* capital A, circumflex accent */ 
    { "Atilde",       195 } , /* capital A, tilde */ 
    { "Auml",         196 } , /* capital A, dieresis or umlaut mark */ 
    { "Aring",        197 } , /* capital A, ring */ 
    { "AElig",        198 } , /* capital AE diphthong (ligature) */ 
    { "Ccedil",       199 } , /* capital C, cedilla */ 
    { "Egrave",       200 } , /* capital E, grave accent */ 
    { "Eacute",       201 } , /* capital E, acute accent */ 
    { "Ecirc",        202 } , /* capital E, circumflex accent */ 
    { "Euml",         203 } , /* capital E, dieresis or umlaut mark */ 
    { "Igrave",       205 } , /* capital I, grave accent */ 
    { "Iacute",       204 } , /* capital I, acute accent */ 
    { "Icirc",        206 } , /* capital I, circumflex accent */ 
    { "Iuml",         207 } , /* capital I, dieresis or umlaut mark */ 
    { "ETH",          208 } , /* capital Eth, Icelandic (Dstrok) */ 
    { "Ntilde",       209 } , /* capital N, tilde */ 
    { "Ograve",       210 } , /* capital O, grave accent */ 
    { "Oacute",       211 } , /* capital O, acute accent */ 
    { "Ocirc",        212 } , /* capital O, circumflex accent */ 
    { "Otilde",       213 } , /* capital O, tilde */ 
    { "Ouml",         214 } , /* capital O, dieresis or umlaut mark */ 
    { "times",        215 } , /* multiplication sign */ 
    { "Oslash",       216 } , /* capital O, slash */ 
    { "Ugrave",       217 } , /* capital U, grave accent */ 
    { "Uacute",       218 } , /* capital U, acute accent */ 
    { "Ucirc",        219 } , /* capital U, circumflex accent */ 
    { "Uuml",         220 } , /* capital U, dieresis or umlaut mark */ 
    { "Yacute",       221 } , /* capital Y, acute accent */ 
    { "THORN",        222 } , /* capital THORN, Icelandic */ 
    { "szlig",        223 } , /* small sharp s, German (sz ligature) */ 
    { "agrave",       224 } , /* small a, grave accent */ 
    { "aacute",       225 } , /* small a, acute accent */ 
    { "acirc",        226 } , /* small a, circumflex accent */ 
    { "atilde",       227 } , /* small a, tilde */
    { "auml",         228 } , /* small a, dieresis or umlaut mark */ 
    { "aring",        229 } , /* small a, ring */
    { "aelig",        230 } , /* small ae diphthong (ligature) */ 
    { "ccedil",       231 } , /* small c, cedilla */ 
    { "egrave",       232 } , /* small e, grave accent */ 
    { "eacute",       233 } , /* small e, acute accent */ 
    { "ecirc",        234 } , /* small e, circumflex accent */ 
    { "euml",         235 } , /* small e, dieresis or umlaut mark */ 
    { "igrave",       236 } , /* small i, grave accent */ 
    { "iacute",       237 } , /* small i, acute accent */ 
    { "icirc",        238 } , /* small i, circumflex accent */ 
    { "iuml",         239 } , /* small i, dieresis or umlaut mark */ 
    { "eth",          240 } , /* small eth, Icelandic */ 
    { "ntilde",       241 } , /* small n, tilde */ 
    { "ograve",       242 } , /* small o, grave accent */ 
    { "oacute",       243 } , /* small o, acute accent */ 
    { "ocirc",        244 } , /* small o, circumflex accent */ 
    { "otilde",       245 } , /* small o, tilde */ 
    { "ouml",         246 } , /* small o, dieresis or umlaut mark */ 
    { "divide",       247 } , /* division sign */
    { "oslash",       248 } , /* small o, slash */ 
    { "ugrave",       249 } , /* small u, grave accent */ 
    { "uacute",       250 } , /* small u, acute accent */ 
    { "ucirc",        251 } , /* small u, circumflex accent */ 
    { "uuml",         252 } , /* small u, dieresis or umlaut mark */ 
    { "yacute",       253 } , /* small y, acute accent */ 
    { "thorn",        254 } , /* small thorn, Icelandic */ 
    { "yuml",         255 }  /* small y, dieresis or umlaut mark */
  };


char SgmlToChar(char *sgml){
int i;
unsigned char res;

	for(i=0;i<SGML_CHAR_NUM;i++)
		if(!strncasecmp(sgml,SGMLChars[i].sgml,
				strlen(SGMLChars[i].sgml))){

			res=SGMLChars[i].equiv;
			if(islower(*(unsigned char*)(sgml))){
				res=tolower(res);
			}else{
				res=toupper(res);
			}
			return((char)res);
		}
	return(0);
}
