#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "mysql.h"
#include "indexer.h"
#include "mysqlint.h"
#include "udm_syslog.h"


int abort_indexer()
{
	if(is_log_open){
		udm_log(ERROR,"Indexer: Error #%d (%s)",mysql_errno(&mysql),mysql_error(&mysql));
	}else{
		fprintf(stderr,"Indexer: Error #%d (%s)\n",mysql_errno(&mysql),mysql_error(&mysql));
	}
	exit(-1);
}

MYSQL mysql;
char *MySQLHost       = MYSQL_HOST;
char *MySQLDB         = MYSQL_DB;
char *MySQLUser       = MYSQL_USER;
char *MySQLPass       = MYSQL_PASS;

static int is_connected=0;
static int connect_db()
{
	mysql_init(&mysql);
	if (!(mysql_real_connect(&mysql,MySQLHost,MySQLUser,MySQLPass,MySQLDB,0,NULL,0)))abort_indexer();
	is_connected=1;
	return(0);
}

int safe_mysql_query(MYSQL *mysql,char *query)
{
int res,i;
	if(!is_connected)connect_db();
	for(i=0;i<2;i++){
		if(res=mysql_query(mysql,query)){
			if((mysql_errno(mysql)==CR_SERVER_LOST)||
			(mysql_errno(mysql)==CR_SERVER_GONE_ERROR)||
			(mysql_errno(mysql)==ER_SERVER_SHUTDOWN)){
				udm_log(ERROR,"Error in mysql_query: %d (%s)",mysql_errno(mysql),mysql_error(mysql));
				udm_log(ERROR,"Waiting during 5 seconds for server to restart...");
				sleep(5);
				udm_log(ERROR,"Trying to reconnect");
			}else
				return(res);
		}else
			return(res);
	}
	return(res);
}
