#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include "openhost.h"

static int alarm_abort;
static void sig_alarm(int i){ 
	alarm_abort = 1;
}

/* Open TCP Connect */
int open_host(char *hostname,int port, int timeout)
{
int net;
struct hostent *host;
struct sockaddr_in sin;
void *old_alarm;


 bzero( (char*)&sin, sizeof(sin) );
 if ((sin.sin_addr.s_addr=inet_addr(hostname)) != (unsigned long) -1)
   sin.sin_family=AF_INET;
 else
   if (host=gethostbyname(hostname) ) {
     sin.sin_family=host->h_addrtype;
     memcpy((caddr_t)&sin.sin_addr, host->h_addr, host->h_length);
   } else return(-1);
 
 if (port) sin.sin_port= htons(port);
 else
   return(-2);

 net=socket(AF_INET, SOCK_STREAM, 0);
 alarm_abort=0;alarm(timeout);
 old_alarm=signal(SIGALRM,sig_alarm);
 connect(net, (struct sockaddr *)&sin, sizeof (sin));
 alarm(0);signal(SIGALRM,old_alarm);
 if(alarm_abort)return(-3);
 return(net);
}
