#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "indexer.h"
#include "parser.h"

PARSER parsers [MAXPARSERS];
int nparsers=0;

int AddMime(char *buffer){
	char *mimes;
	char *command;
	char *token;
	int pos;
	PARSER *parser;

	/* Now we should process following format
	<from_mime> <to_mime>[;encoding] ["command line [$1]"] */

	parser=parsers+nparsers;
	if(!(mimes=strtok(buffer,PARSER_QUOTES))) return -1;
	for(pos=0;mimes[pos];pos++)
		if(mimes[pos]==';') mimes[pos]=' ';
	command=strtok(NULL,PARSER_QUOTES);
	if(parser->from_mime=strtok(mimes,PARSER_DELIMITERS))
		parser->from_mime=strdup(parser->from_mime);
	if(parser->to_mime  =strtok(NULL,PARSER_DELIMITERS))
		parser->to_mime  =strdup(parser->to_mime);
	if(parser->charset  =strtok(NULL,PARSER_DELIMITERS))
		parser->charset  =strdup(parser->charset);
	    
	/* Let's create argv[] for each parser */
	if(command) {
	    strncpy(buffer,command,STRSIZ);
	    if(parser->parser=strtok(buffer,PARSER_DELIMITERS))
	    parser->parser=strdup(parser->parser);
	    parser->argv=(char**)malloc(sizeof(char*)*MAXARGV);
	    parser->fileposition=0; pos=1;
	    parser->argv[0]=parser->parser;
	    do{
		if(token=strtok(NULL,PARSER_DELIMITERS)){
			parser->argv[pos]=strdup(token);
			if(!strcmp(token,"$1")) parser->fileposition=pos;
		} else parser->argv[pos]=token;
	    }while(token && ++pos<MAXARGV);
	} else parser->parser=NULL;
	nparsers++;
	return 0;
}


/* This function runs external parser and sends buf to it's STDIN
   It returns STDOUT of parser. */
char *parse(char *buf, int buflen, char *parser, char *argv[], int maxlen){
    char *result = NULL;
    int wr[2];
    int rd[2];    
    int n;
    pid_t pid;    

    /* Create write and read pipes */
    pipe(wr);
    pipe(rd);
    
    /* Fork a clild */
    pid = fork();
    
    if (pid>0){

        char string[STRSIZ];
	result=buf;

	/* Close other pipe ends */
	close (wr[0]);
	close (rd[1]);
	
	/* Send string to be parsed */
        write (wr[1], buf, strlen(buf));
	close(wr[1]);
	memset(string,0,STRSIZ);
	while ((n=read(rd[0],string,STRSIZ-1))>0){
	    strncat(result,string,maxlen-strlen(result));
	    memset(string,0,STRSIZ);
	}
    } 
    if (pid==0){
	/* Close other pipe ends */
	close (wr[1]);
	close (rd[0]);
	
	/* Connect pipe to stdout */
	if (rd[1]!=STDOUT_FILENO){
	    dup2(rd[1],STDOUT_FILENO);
	    close(rd[1]);
	}

	/* Connect pipe to stdin */
	if (wr[0]!=STDIN_FILENO){
	    dup2(wr[0],STDIN_FILENO);
	    close(wr[0]);
	}
	execvp(parser,argv);
    }
    return result;
}

/*
 Some parsers need a file to perform a seek. So, we just create temporary file,
 parse it and return STDOUT as a result. Result should be freed
 To be binary-safe, we pass length parameter of buffer
*/

char *parse_file (char *buf, int length, int parsernum, int maxlen){
    int fd;
    char *filename;
    char *result;
    char *buffer;
    char resfile[STRSIZ+1];

    /* Create temporary file */
    buffer=buf;
    if(parsers[parsernum].fileposition){
	filename=tmpnam(NULL);
	umask(022);
	chdir("/tmp");
	fd=open(filename,O_RDWR|O_CREAT,0600);

	/* Write to the temporary file */
	write(fd,buf,length);
	close(fd);
    
	/* Place file name into the argument list */
	parsers[parsernum].argv[parsers[parsernum].fileposition]=filename;

	*buffer=0;
    }
    
    /* Call external parser with buffer as STDIN */
    result=parse(buffer,length,parsers[parsernum].parser,parsers[parsernum].argv,maxlen);
    
    /* Remove temporary file */
    if(parsers[parsernum].fileposition) unlink(filename);

    return result;
}

char *mime_parse(char *from_mime, int *to_mime, char *buf, int length, int maxlen){
    int i;
    
    for(i=0;i<nparsers;i++){
	if(!strcmp(parsers[i].from_mime,from_mime)){
            *to_mime=i;
	    if(parsers[i].parser)
		return parse_file(buf,length,i,maxlen);
	    else
		return buf;
	}
    }
    return NULL;
}

char *mime_name(int mime, int type){
    return (type==MIME_FROM)?parsers[mime].from_mime:parsers[mime].to_mime;
}

char *mime_charset(int mime){
    return parsers[mime].charset;
}
