#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "search.h"
#include "mysql.h"
#include "config.h"
#include "charset.h"

#define STRSIZ 1024*8
#define MODE_ALL  1
#define MODE_ANY  2
#define STRNCMP(s1,s2)  (strncmp(s1,s2,strlen(s2)))
#define STRNCASECMP(s1,s2)  (strncasecmp(s1,s2,strlen(s2)))
#define STREND(s)	(s+strlen(s))

#define UNKNOWN		0
#define TOP		1
#define BOT		2
#define RESTOP		3
#define RESBOT		4
#define RES		5
#define ERROR		6
#define NOTFOUND	7
#define CLONE		8

int Randoms[MAXRANDOM];

#define MAXTEMPLATE 1024
typedef struct template_struct{
	int where;
	char *str;
} TEMPLATE;
static TEMPLATE Template[MAXTEMPLATE];
static int ntempl=0;

static MYSQL mysql;
static char *MySQLHost       = MYSQL_HOST;
static char *MySQLDB         = MYSQL_DB;
static char *MySQLUser       = MYSQL_USER;
static char *MySQLPass       = MYSQL_PASS;


/* Template variables */
static char error[BUFSIZ]="";
static char wordinfo[STRSIZ]="";
static char navigator[STRSIZ]="";
static char *query_form_escaped=0;
static char *crc=0;
static char *self=0;
static char *title=0;
static char *text=0;
static char *size=0;
static char *rating=0;
static char *descr=0;
static char *keywords=0;
/*
static char *url=0;
static char *content_type=0;
static char *last_modified=0;
*/

static int  url_id,docnum,first=0,last=0,found=0;

int Unescape(char *d,char *s){
int hi,lo=0;
	if((d==NULL)||(s==NULL))return(1);
	while(*s){
		if(*s=='%'){
			if(strchr("0123456789",*(++s))) hi=*s-'0';
			else hi=*s-'A'+10;
			if(strchr("0123456789",*(++s))) lo=*s-'0';
			else lo=*s-'A'+10;
			*d=hi*16+lo;
		}else
		if(*s=='+'){
			*d=' ';
		}else{
			*d=*s;
		}
		s++; d++;
	}
	*d=0;
}

int Escape(char *d,char *s,char what){
int hi,lo=0;
	if((d==NULL)||(s==NULL))return(1);
	while(*s){
		if(*s==what){
			if(what=='"') {strcpy(d,"&quot;"); d+=5;}else
			if(what==' ') {*d='+';}
		}else{
			*d=*s;
		}
		s++; d++;
	}
	*d=0;
}



int PrintTemplate(int where,char *url,char *content_type,char *last_modified)
{
int i,rnum;
char *s;
MYSQL_RES *res;
MYSQL_ROW row;
char qbuf[STRSIZ]="";

	for(i=0;i<ntempl;i++){
		if(Template[i].where!=where)continue;
		s=Template[i].str;
		while(*s){
			if((*s=='\\')&&(*(s+1)=='$')){printf("$");s+=2;continue;}
			if(*s!='$'){printf("%c",*s);s++;continue;}
			s++;
			switch(*s){
			case 'A': printf("%s",self);break;
			case 'Q': printf("%s",query_form_escaped?query_form_escaped:"");break;
			case 'E': printf("%s",error);break;
			case 'W': printf("%s",wordinfo);break;
			case 'V': printf("%s",navigator);break;
			case 'f': printf("%d",first);break;
			case 'l': printf("%d",last);break;
			case 't': printf("%d",found);break;
			case 'r': {
				s++;
				rnum=atoi(s);
				if((rnum>=0)&&(rnum<MAXRANDOM))
					printf("%d",Randoms[rnum]);
				while((*s)&&(isdigit(*(s+1))))
					s++;
				break;
			}

			case 'D':
				s++;
				switch(*s){
				case 'U':printf("%s",url?url:"");break;
				case 'T':printf("%s",title?title:"");break;
				case 'C':printf("%s",content_type?content_type:"");break;
				case 'M':printf("%s",last_modified?last_modified:"");break;
				case 'X':printf("%s",text?text:"");break;
				case 'R':printf("%s",rating?rating:"");break;
				case 'S':printf("%s",size?size:"");break;
				case 'N':printf("%d",docnum);break;
				case 'D':printf("%s",descr);break;
				case 'K':printf("%s",keywords);break;
				default :printf("%c",*s);
				}
				break;

			case 'C':
				s++;
				switch(*s){
				case 'L':
				if((*crc)&&(where==RES)){
					sprintf(qbuf,"SELECT url,content_type,last_modified FROM url WHERE crc='%s' AND rec_id<>'%d'",crc,url_id);
					if(mysql_query(&mysql,qbuf))abort_search();
					if(res=mysql_store_result(&mysql)){
						while(row=mysql_fetch_row(res)){
							/*
							printf("<a href=%s>%s</a><BR>\n",row[0],row[0]);
							*/
							PrintTemplate(CLONE,row[0],row[1],row[2]);
						}
						mysql_free_result(res);
					}
				}
				break;
				default : printf("%c",*s);
				}
				break;
			default: printf("%c",*s);
			}
			s++;
		}
	}
}


int abort_search()
{
	sprintf(error,"Search: Error #%d (%s)\n",mysql_errno(&mysql),mysql_error(&mysql));
	PrintTemplate(ERROR,"","","");
	PrintTemplate(BOT,"","","");
	exit(0);
}


main(int argc, char **argv) {
FILE *file;
float frand;
time_t tclock;

char SEPARATOR[256]="";
char WORDIN[STRSIZ]="";
char URLIN[STRSIZ]="";
char Q[STRSIZ]="";
char Q1[STRSIZ]="";
char RATING[STRSIZ]="";
char qbuf[STRSIZ]="";
char str[STRSIZ]="";
char *env,*s,*t,*q=NULL,*sq=NULL,*ul=0,*tagstr=0;

int tag=0,nwords=0,where=0,len=0,variables=0,ps=0,np=0,is_next=0;

int mode=MODE_ANY;
int rows,i,j;

MYSQL_RES *res;
MYSQL_ROW row;
MYSQL_RES *res1;
MYSQL_ROW row1;

	self=argv[0]?argv[0]:"search.cgi";
	tclock=time(0);srand(tclock);
	for(i=0;i<MAXRANDOM;i++)
		Randoms[i]=0;

	s=SEPARATOR;*s=0;
	for(i=1;i<255;i++){
		if(!strchr(WORDCHAR,i)){
			*s=i;s++;
		}
	}
	*s=0;

	printf("Content-type: text/html\r\n\r\n");

	/* Load Template */
	sprintf(str,"%s/%s", CONFIGDIR,(s=strrchr(self,'/'))?(s+1):(self));
	if(s=strrchr(str,'.')){
		*s=0;strcat(str,".htm");
	}else{
		strcpy(str,"search.htm");
	}
	file=fopen(str,"r");
	if(!file){
		printf("<html><body>Could not open template file '%s'!</body></html>\n",str);
		exit(0);
	}
	while((fgets(str,sizeof(str),file))&&(ntempl<MAXTEMPLATE)){
		if(!STRNCMP(str,"<!--top-->"))		where=TOP;
		else
		if(!STRNCMP(str,"<!--bottom-->"))	where=BOT;
		else
		if(!STRNCMP(str,"<!--restop-->"))	where=RESTOP;
		else
		if(!STRNCMP(str,"<!--resbot-->"))	where=RESBOT;
		else
		if(!STRNCMP(str,"<!--res-->"))		where=RES;
		else
		if(!STRNCMP(str,"<!--notfound-->"))	where=NOTFOUND;
		else
		if(!STRNCMP(str,"<!--error-->"))	where=ERROR;
		else
		if(!STRNCMP(str,"<!--clone-->"))	where=CLONE;
		else
		if(!STRNCMP(str,"<!--/top-->"))		where=0;
		else
		if(!STRNCMP(str,"<!--/bottom-->"))	where=0;
		else
		if(!STRNCMP(str,"<!--/restop-->"))	where=0;
		else
		if(!STRNCMP(str,"<!--/resbot-->"))	where=0;
		else
		if(!STRNCMP(str,"<!--/res-->"))		where=0;
		else
		if(!STRNCMP(str,"<!--/notfound-->"))	where=0;
		else
		if(!STRNCMP(str,"<!--/error-->"))	where=0;
		else
		if(!STRNCMP(str,"<!--/clone-->"))	where=0;
		else
		if(!STRNCMP(str,"<!--variables")){	where=0;variables=1;}
		else
		if(!STRNCMP(str,"-->")){	
			if(variables){
				where=0;
				variables=0;
			}
		}else{
			if(where){
				Template[ntempl].where=where;
				Template[ntempl].str=strdup(str);
				ntempl++;
			}
			if((variables)&&(s=strtok(str,"\r\n"))){
				if(!STRNCASECMP(str,"MySQLHost"))
					MySQLHost=strdup(strchr(str,'=')+1);
				else
				if(!STRNCASECMP(str,"MySQLDB"))
					MySQLDB=strdup(strchr(str,'=')+1);
				else
				if(!STRNCASECMP(str,"MySQLUser"))
					MySQLUser=strdup(strchr(str,'=')+1);
				else
				if(!STRNCASECMP(str,"MySQLPass"))
					MySQLPass=strdup(strchr(str,'=')+1);
				else
				if(!STRNCASECMP(str,"ResultsPerPage"))
					ps=atoi((strchr(str,'=')+1));
				else
				if(!STRNCASECMP(str,"R")){
					i=atoi(str+1);
					s=strchr(str,'=');
					if(s){
						j=atoi(s+1);
						if((i>0)&&(i<MAXRANDOM)){
							frand=rand();
							frand=frand/RAND_MAX*j;
							Randoms[i]=frand;
						}
					}
				}
			}
		}
	}
	fclose(file);

	/* Parse Query String */
	env=getenv("QUERY_STRING");
	if(env){
		s=strtok(env,"&");
		while(s){
			if(!STRNCMP(s,"q=")){
				Unescape(str,s+2);
				q=strdup(str);
				Escape(str,q,'"');
				query_form_escaped=strdup(str);
			}
			if(!STRNCMP(s,"np=")){
				np=atoi(s+3);
			}
			if(!STRNCMP(s,"ps=")){
				ps=atoi(s+3);
			}
			if((!STRNCMP(s,"ul="))&&(*(s+3))){
				Escape(str,s+3,'"');
				ul=strdup(str);
			}
			if((!STRNCMP(s,"t="))&&(*(s+2))){
				tag=atoi(s+2);
				tagstr=(char*)malloc(64);
				sprintf(tagstr,"AND url.tag=%d",tag);
			}
			if(!STRNCMP(s,"m=")){
				if(!STRNCMP(s+2,"any"))mode=MODE_ANY;
				else	mode=MODE_ALL;
			}
			s=strtok(NULL,"&");
		}
	}
	if(!ps)ps=20;
	PrintTemplate(TOP,"","","");
	if(!q){
		PrintTemplate(BOT,"","","");
		exit(0);
	}

	/* Connect Database */
	if (!(mysql_connect(&mysql,MySQLHost,MySQLUser,MySQLPass)))abort_search();
	if (mysql_select_db(&mysql,MySQLDB))abort_search();


	/* Parse Query Words */
	Escape(str,q,' ');
	sq=strdup(str);
	s=strtok(q,SEPARATOR);
	while(s){
		nwords++;
		tolower_string(s,"koi8-r");
		len=strlen(s);
		
		sprintf(qbuf,"
select straight_join \
concat(left('%s',%d-length(a.repl)),a.find) \
from affix as a,spell as s \
where right('%s',length(a.repl))=a.repl \
and INSTR(s.flag,a.flag) \
and a.type='s' \
and a.lang=s.lang \
and concat(left('%s',%d-length(a.repl)),a.find)=s.word \
and concat(left('%s',%d-length(a.repl)),a.find) regexp a.mask",
s,len,s,s,len,s,len);

#ifdef DEBUG
printf("%s<BR><HR>\n",qbuf);
#endif

		if(mysql_query(&mysql,qbuf))abort_search();
		res=mysql_store_result(&mysql);
		if(*RATING)strcat(RATING," + ");
		sprintf(STREND(RATING),"max(dict.word in('%s'",s);
		do {
			row=mysql_fetch_row(res);
			sprintf(qbuf,"
select distinct \
concat(left(word,length(word)-length(find)),repl) as res \
from spell,affix \
where spell.word='%s' \
and INSTR(spell.flag,affix.flag) \
and spell.lang=affix.lang \
and affix.type='s' \
and word regexp mask",
row?row[0]:s);

#ifdef DEBUG
printf("%s<BR><HR>\n",qbuf);
#endif

			if(*WORDIN)strcat(WORDIN,",");
			sprintf(STREND(WORDIN),"'%s'",row?row[0]:s);
			if(mysql_query(&mysql,qbuf))abort_search();
			res1=mysql_store_result(&mysql);
			while(row1=mysql_fetch_row(res1)){
				sprintf(STREND(WORDIN),",'%s'",row1[0]);
				sprintf(STREND(RATING),",'%s'",row1[0]);
			}
			mysql_free_result(res1);
		} while(row);
		strcat(RATING,"))");
		mysql_free_result(res);
		s=strtok(NULL,SEPARATOR);
	}
	/* If there are some words are really entered */
	if(!*WORDIN){
		PrintTemplate(BOT,"","","");
		exit(0);
	}

	/* Number of the words */
	if(ul||tagstr)
		sprintf(qbuf,"SELECT word,count(*) as c FROM dict,url WHERE word IN (%s) AND url.rec_id=dict.url_id AND url.url LIKE '%%%s%%' %s GROUP BY word ORDER BY word",WORDIN,ul?ul:"",tagstr?tagstr:"");
	else
		sprintf(qbuf,"SELECT word,count(*) as c FROM dict WHERE word IN (%s) GROUP BY word ORDER BY word",WORDIN);
		
#ifdef DEBUG
printf("%s<BR><HR>\n",qbuf);
#endif

	if(mysql_query(&mysql,qbuf))abort_search();
	if(res=mysql_store_result(&mysql)){
		rows=mysql_num_rows(res);
		for(i=0;i<rows;i++){
			row=mysql_fetch_row(res);
			strcat(wordinfo,row[0]);
			strcat(wordinfo,": ");
			strcat(wordinfo,row[1]);
			if(i+1<rows)strcat(wordinfo,", ");
			else strcat(wordinfo,"  &nbsp; &nbsp; ");
		}
		mysql_free_result(res);
	}

	/* Number of stopwords */
	sprintf(qbuf,"SELECT word FROM stopword WHERE word IN (%s) ORDER BY word",WORDIN);

	if(mysql_query(&mysql,qbuf))abort_search();
	if(res=mysql_store_result(&mysql)){
		rows=mysql_num_rows(res);
		for(i=0;i<rows;i++){
			nwords--;
			row=mysql_fetch_row(res);
			strcat(wordinfo,row[0]);
			strcat(wordinfo,": stopword");
			if(i+1<rows)strcat(wordinfo,", ");
		}
		mysql_free_result(res);
	}

	/* Count the number of the found documents */
	if(mode==MODE_ANY)nwords=0;
	sprintf(qbuf,"SELECT count(*)as c,dict.url_id FROM url,dict WHERE url.rec_id=dict.url_id AND url.url LIKE '%%%s%%' %s AND word IN (%s) GROUP BY dict.url_id HAVING c>=%d",ul?ul:"",tagstr?tagstr:"",WORDIN,nwords);
	if(mysql_query(&mysql,qbuf))abort_search();
	if(res=mysql_store_result(&mysql)){
		found=mysql_num_rows(res);
		mysql_free_result(res);
	}

	if(found<np*ps+1){
		PrintTemplate(NOTFOUND,"","","");
		PrintTemplate(BOT,"","","");
		exit(0);
	}

	if(ul||tagstr)
		sprintf(qbuf,"\
SELECT url.rec_id,(%s) as rating,sum(intag) AS q1 \
FROM url,dict \
WHERE url.rec_id=dict.url_id \
AND url.url LIKE '%%%s%%' %s \
AND word IN (%s) \
GROUP BY 1 \
ORDER BY rating DESC,q1 DESC LIMIT %d,%d",
		RATING,ul?ul:"",tagstr?tagstr:"",WORDIN,np*ps,ps+1);

	else

		sprintf(qbuf,"\
SELECT url_id,%s as rating,sum(intag) AS q1 \
FROM dict \
WHERE word IN (%s) \
GROUP BY 1 \
ORDER BY rating DESC,q1 DESC LIMIT %d,%d",
		RATING,WORDIN,np*ps,ps+1);

#ifdef DEBUG
printf("%s<BR><HR>\n",qbuf);
#endif

	if(mysql_query(&mysql,qbuf))abort_search();
	if(!(res=mysql_store_result(&mysql)))exit(0);
	URLIN[0]=0;i=0;
	while(row=mysql_fetch_row(res)){
		if(i<ps){
			if(*URLIN)strcat(URLIN,",");
			strcat(URLIN,row[0]);
		}
		i++;
	}
	is_next=(i>ps);

	if(tagstr)
		sprintf(tagstr,"%d",tag);
	else
		tagstr="";

	if(np>0){
		sprintf(navigator,"<a href=\"%s?t=%s&ul=%s&ps=%d&np=%d&m=%s&q=%s\">[&lt; &lt; Prev %d]</a> &nbsp; ",self,tagstr,ul?ul:"",ps,np-1,mode==MODE_ALL?"all":"any",sq,ps);
	}
	if(is_next){
		sprintf(str,"<a href=\"%s?t=%s&ul=%s&ps=%d&np=%d&m=%s&q=%s\">[Next %d &gt; &gt;]</a>",self,tagstr,ul?ul:"",ps,np+1,mode==MODE_ALL?"all":"any",sq,ps);
		strcat(navigator,str);
	}
	first=np*ps+1;
	last=np*ps+((i<ps)?i:ps);

	PrintTemplate(RESTOP,"","","");


sprintf(qbuf,"\
SELECT url,title,text,content_type,\
last_modified,size,rec_id,description,keywords,crc \
FROM url \
WHERE rec_id IN (%s)"
,URLIN);

#ifdef DEBUG
printf("%s<BR><HR>\n",qbuf);
#endif

	if(mysql_query(&mysql,qbuf))abort_search();
	if(!(res1=mysql_store_result(&mysql)))exit(0);
	mysql_data_seek(res,0);i=0;
	while(row=mysql_fetch_row(res)){
		url_id=atoi(row[0]);rating=row[1];
		mysql_data_seek(res1,0);
		while(row1=mysql_fetch_row(res1)){
			if(atoi(row1[6])==url_id){
				i++;docnum=np*ps+i;
				/*url=row1[0];*/
				title=*row1[1]?row1[1]:"No title";
				text=row1[2];
				/*content_type=row1[3];*/
				/*last_modified=row1[4];*/
				size=row1[5];descr=row1[7];
				keywords=row1[8];crc=row1[9];
				PrintTemplate(RES,row1[0],row1[3],row1[4]);
				break;
			}
		}
	}
	mysql_free_result(res);
	mysql_free_result(res1);

	PrintTemplate(RESBOT,"","","");
	PrintTemplate(BOT,"","","");

	if(*WORDIN)mysql_close(&mysql);
}
