#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mysql.h"
#include "spell.h"
#include "mysqlint.h"

#define STRNCASECMP(x,y) strncasecmp(x,y,strlen(y))

static int remove_spaces(char *dist,char *src)
{
char *d,*s;
	d=dist;
	s=src;
	while(*s){
		if(*s!=' '&&*s!='-'&&*s!='\t'){
			*d=*s;
			d++;
		}
		s++;
	}
	*d=0;
}


int ImportAffixes(char *lang, char *filename, int dump)
{
unsigned char str[BUFSIZ];
unsigned char flag1[BUFSIZ]="";
unsigned char flag[BUFSIZ]="";
unsigned char mask[BUFSIZ]="";
unsigned char find[BUFSIZ]="";
unsigned char repl[BUFSIZ]="";
unsigned char word[BUFSIZ]="";
char qbuf[BUFSIZ];
unsigned char *comment,*s,*e;
int i;
int suffixes=0;
int prefixes=0;
int rej=0;
int imp=0;
FILE *affix;

	if(!(affix=fopen(filename,"r"))){
		fprintf(stderr,"Could not open affix file '%s'\n",filename);
		exit(1);
	}
	if(!dump)
	printf("Importing affixes from '%s'\n",filename);

	while(fgets(str,sizeof(str),affix)){
		if(!STRNCASECMP(str,"suffixes")){
			suffixes=1;
			prefixes=0;
			continue;
		}
		if(!STRNCASECMP(str,"prefixes")){
			suffixes=0;
			prefixes=1;
			continue;
		}
		if(!STRNCASECMP(str,"flag ")){
			s=str+5;
			while(strchr("* ",*s))s++;
			sscanf(s,"%[A-Z]s",flag);
			continue;
		}
		if((!suffixes)&&(!prefixes))continue;
		
		if(s=strchr(str,'#'))*s=0;
		if(!*str)continue;

		s=str;
		while(*s){
			*s=tolower(*s);
			s++;
		}
		strcpy(mask,"");
		strcpy(find,"");
		strcpy(repl,"");

		i=sscanf(str,"%[^>\n]>%[^,\n],%[^\n]",mask,find,repl);

		remove_spaces(str,repl);strcpy(repl,str);
		remove_spaces(str,find);strcpy(find,str);
		remove_spaces(str,mask);strcpy(mask,str);
		
		switch(i){
		case 3:break;
		case 2:
			if(*find!='-'){
				strcpy(repl,find);
				strcpy(find,"");
			}
			break;
		default:
			continue;
		}
		if(strchr(mask,'\''))continue;
		if(strchr(find,'\''))continue;
		if(strchr(repl,'\''))continue;
		sprintf(qbuf,"INSERT INTO affix (flag,type,lang,mask,find,repl) VALUES ('%s','%s','%s','%s$','%s','%s')",flag,suffixes?"s":"p",lang,mask,find,repl);
		if(dump){
			printf("%s;\n",qbuf);
		}else{
			if(safe_mysql_query(&mysql,qbuf)){
				if(mysql_errno(&mysql)!=ER_DUP_ENTRY){
					abort_indexer();
				}else{
					rej++;
				}
			}else{
				imp++;
			}
		}
	}
	fclose(affix);
	if(!dump)
	printf("%d rules imported, %d duplicates\n",imp,rej);
}

int ImportDictionary(char *lang,char *filename, int dump)
{
unsigned char str[BUFSIZ];
unsigned char flag1[BUFSIZ]="";
unsigned char flag[BUFSIZ]="";
unsigned char word[BUFSIZ]="";
char qbuf[BUFSIZ];
unsigned char *comment,*s,*e;
int i;
int rej=0;
int imp=0;
FILE *dict;

	if(!(dict=fopen(filename,"r"))){
		fprintf(stderr,"Could not open dict file '%s'\n",filename);
		exit(1);
	}
	if(!dump)
	printf("Importing dictionary from '%s'\n",filename);
	while(fgets(str,sizeof(str),dict)){
		flag[0]=0;
		sscanf(str,"%[^/]/%s",word,flag);
		s=word;
		while(*s){
			*s=tolower(*s);s++;
		}
		if(strchr(word,'\''))continue;
		s=flag;e=flag1;*e=0;
		while(*s){
			if(*s>='A'&&*s<='Z'){
				*e=*s;e++;*e=0;
			}
			s++;
		}
		if(!flag1[0])continue;
		sprintf(qbuf,"INSERT INTO spell (word,flag,lang) VALUES ('%s','%s','%s')",word,flag1,lang);
		if(dump){
			printf("%s;\n",qbuf);
		}else{
			if(safe_mysql_query(&mysql,qbuf)){
				if(mysql_errno(&mysql)!=ER_DUP_ENTRY){
					abort_indexer();
				}else{
					rej++;
				}
			}else{
				imp++;
			}
		}
	}
	fclose(dict);
	if(!dump)
	printf("%d words imported, %d duplicates\n",imp,rej);
}
