#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "udm_syslog.h"

#define LOG_BUF_LEN 255

int loglevel=INFO;
int is_log_open=0;
FILE *error=NULL;

#ifdef HAVE_SYSLOG_H
const CODE facilitynames[] ={
#ifdef LOG_AUTH
    {"auth",	LOG_AUTH},
#endif
#ifdef LOG_AUTHPRIV
    {"authpriv",LOG_AUTHPRIV},
#endif
#ifdef LOG_CRON
    {"cron", 	LOG_CRON},
#endif
#ifdef LOG_DAEMON
    {"daemon",	LOG_DAEMON},
#endif
#ifdef LOG_FTP
    {"ftp",	LOG_FTP},
#endif
#ifdef LOG_KERN
    {"kern",	LOG_KERN},
#endif
#ifdef LOG_LPR
    {"lpr",	LOG_LPR},
#endif
#ifdef LOG_MAIL
    {"mail",	LOG_MAIL},
#endif
#ifdef LOG_NEWS
    {"news",	LOG_NEWS},
#endif
#ifdef LOG_SYSLOG
    {"syslog",	LOG_SYSLOG},
#endif
#ifdef LOG_USER
    {"user",	LOG_USER},
#endif
#ifdef LOG_UUCP
    {"uucp",	LOG_UUCP},
#endif
#ifdef LOG_LOCAL0
    {"local0",	LOG_LOCAL0},
#endif
#ifdef LOG_LOCAL1
    {"local1",	LOG_LOCAL1},
#endif
#ifdef LOG_LOCAL2
    {"local2",	LOG_LOCAL2},
#endif
#ifdef LOG_LOCAL3
    {"local3",	LOG_LOCAL3},
#endif
#ifdef LOG_LOCAL4
    {"local4",	LOG_LOCAL4},
#endif
#ifdef LOG_LOCAL5
    {"local5",	LOG_LOCAL5},
#endif
#ifdef LOG_LOCAL6
    {"local6",	LOG_LOCAL6},
#endif
#ifdef LOG_LOCAL7
    {"local7",	LOG_LOCAL7},
#endif
    {NULL,		-1},
};

int syslog_facility(char *f){
	const CODE *fn;

	fn=facilitynames;
	while (fn->c_name!=NULL){
		if (strcasecmp(f, fn->c_name)==0)
			return fn->c_val;
		fn++;
	}
	fprintf(stderr, "Config file error: unknown facility given: %s\n\r", f);
	fprintf(stderr, "Will continue with default facility\n\r");
	return LOG_FACILITY;
}
#endif /* HAVE_SYSLOG_H */


int udm_openlog(int log_facility,int log2stderr){
#ifdef HAVE_SYSLOG_H
#ifdef USE_SYSLOG
/* LOG_PERROR supported by 4.3BSD Reno releases and later */
#ifdef LOG_PERROR
    openlog("UdmSearch",(log2stderr)?LOG_PERROR|LOG_PID:LOG_PID,log_facility);
#else
    openlog("UdmSearch",LOG_PID,log_facility);
    if(log2stderr) error=stderr;
#endif /* LOG_PERROR */
#endif /* USE_SYSLOG */
#else
    /* If syslog not found or not used, use stderr. */
    if(log2stderr) error=stderr;
#endif /* HAVE_SYSLOG_H */
    is_log_open=1;
}

void udm_log(int level, const char *fmt, ...){
    va_list ap;
    va_start(ap,fmt);
    udm_logger(level,fmt,ap);
    va_end(ap);
    return;
}

int udm_logger(int level, const char *fmt, va_list ap){
    char buf[LOG_BUF_LEN+1];

    if(loglevel<level) return 0;
    vsnprintf(buf,LOG_BUF_LEN,fmt,ap);
#ifdef HAVE_SYSLOG_H
#ifdef USE_SYSLOG
    syslog((level!=ERROR)?LOG_INFO:LOG_ERR,buf);
#endif
#endif
    if(error!=NULL) fprintf(error,"%s\n",buf); 
    return 1;
}
