
/*
 * entity.h - Main header file
 *
 * Copyright (C) 1997 Oyvind A. Solheim <sunny256@bigblue.no>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _ENTITY_H

#define _ENTITY_H  1

/*
 * Defines
 */

#define VERSION      "1.10"
#define RELEASE_DATE "1997/03/07"
#define AUTHOR       "Oyvind A. Solheim <sunny256@bigblue.no>"

#ifdef __MSDOS__
#  define DOS
#endif

#define FALSE  0
#define TRUE   1

#define EXIT_OK     0
#define EXIT_ERROR  1

#define NOT_FOUND   0
#define WAS_FOUND   1
#define FILE_ERROR  2

#if !defined(DOS)
#  define FOPEN_READ   "r" /* Portability */
#  define FOPEN_WRITE  "w"
#else
#  define FOPEN_READ   "rb" /* Braindead */
#  define FOPEN_WRITE  "wb"
#endif

#define MAXLEN  8 /* Maximum length of entities including '&' and ';' */

#define ENGLISH    1
#define NORWEGIAN  2

#ifndef C_LANG
#  define C_LANG  ENGLISH
#endif

#if C_LANG == ENGLISH
#  define MSG_LANGUAGE  "English"
#else
#  error C_LANG is not correctly defined
#endif

#ifdef C_ASSERT
#  ifdef NDEBUG
#    undef NDEBUG
#  endif            /* ifdef NDEBUG        */
#else               /* ifdef C_ASSERT      */
#  define NDEBUG  1
#endif              /* ifdef C_ASSERT else */

#ifdef C_SKIP_PGPKEY
#  ifdef C_PGPKEY
#    undef C_PGPKEY
#  endif
#else
#  define C_PGPKEY  1
#endif

#ifdef C_SKIP_LICENSE
#  ifdef C_LICENSE
#    undef C_LICENSE
#  endif
#else
#  define C_LICENSE  1
#endif

/*
 * Macros
 */

#define in_range(a,b,c)  ((a) >= (b) && (a) <= (c) ? TRUE : FALSE)
#define is_htmlchar(a)   (((in_range((a),0,31) && (a)!='\n') || in_range((a),127,159)) ? FALSE : TRUE)
#define myerror(a)       { fprintf(stderr, "%s: ", progname); perror(a); }

#define debpr0(a)              if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a)); }
#define debpr1(a,b)            if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a),(b)); }
#define debpr2(a,b,c)          if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a),(b),(c)); }
#define debpr3(a,b,c,d)        if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a),(b),(c),(d)); }
#define debpr4(a,b,c,d,e)      if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a),(b),(c),(d),(e)); }
#define debpr5(a,b,c,d,e,f)    if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a),(b),(c),(d),(e),(f)); }
#define debpr6(a,b,c,d,e,f,g)  if (debug) { fprintf(stddebug, "%s: debug: ", progname); fprintf(stddebug, (a),(b),(c),(d),(e),(f),(g)); }

/*
 * Typedefs
 */

typedef unsigned char  bool;

/*
 * Function prototypes
 */

/* entity.c */

extern int   process_file(const char *);
extern void  printheader(FILE *);
extern void  print_version(void);
extern void  usage(int);

/*
 * Global variables
 */

extern char  *progname,
             *doctitle,
             *docowner,
             debug;
bool         use_all,
             all_errors,
             quiet,
             allnum,
             numeric,
             replace_file,
             verbose,
             mkhtml,
             to_iso;
extern FILE  *stddebug;
extern char  *ent_iso[];

#endif /* ifndef _ENTITY_H */

/***** End of file entity.h *****/
