#!/usr/bin/python
#
# bigbrother
# http://snarfed.org/space/bigbrother
# Copyright 2003, 2004 Ryan Barrett <bigbrother@ryanb.org>
#
# File: deluxetest.py
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA

"""
Defines a "deluxe" test class class that includes a few convenience methods,
and overrides assertEqual so that the expected and acutal values are printed to
stdout if they're not equal.
"""

import unittest

class TestCase(unittest.TestCase):

  def assertClose(self, first, second, delta=.001):
    """ Throws an assertion if first and second differ by more than delta
    (which arbitrarily defaults to .001).
    """
    assert abs(first - second) <= delta

  def assertAllClose(self, firstList, secondList):
    """ Takes two lists and throws an assertion if any of the corresponding
    elements differ by more than .001.
    """
    for (a, b) in zip(firstList, secondList):
      self.assertClose(a, b)

  def assertEqual(self, a, b, msg=None):
    """ Asserts that a == b. If a != b, a and b are printed.
    """
    if a != b:
      print '--\n', a, '\n', b, '\n--\n'

    # use assert instead of self.assertEqual() because that will call
    # deluxetest.TestCase.assertEqual, not unittest.TestCase.assertEqual
    assert a == b 


def main():
  unittest.main()
