#!/usr/bin/python
#
# bigbrother
# http://snarfed.org/space/bigbrother
# Copyright 2004 Ryan Barrett <bigbrother@ryanb.org>
#
# File: graph_unittest.py
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA

"""
Unit tests for graph.py.
"""

import deluxetest
import bigbrother
from graph import *

class graphTest(deluxetest.TestCase):

  def setUp(self):
    bigbrother.set_defaults()

  def test_interpolate(self):
    self.assertRaises(AssertionError, interpolate, [], -1)
    self.assertRaises(AssertionError, interpolate, [], 0)
    self.assertEqual([], interpolate(None, 1))
    self.assertEqual([], interpolate([], 2))
    self.assertEqual([(1, 0), (2, 2)], interpolate([(1, 0), (2, 2)], 1))
    self.assertEqual([(1, 0), (1.5, 1), (2, 2)],
                     interpolate([(1, 0), (2, 2)], 2))
    self.assertEqual(
      [(1, 10), (2, 6), (3, 2), (4, -2), (4, -3), (4, -4), (4, -5)],
      interpolate([(1, 10), (4, -2), (4, -5)], 3))

  def test_smooth(self):
    # error conditions
    bigbrother.config.set('bigbrother', 'smoothing_factor', '-1')
    self.assertRaises(AssertionError, smooth, [0])

    # smoothing factor 0 should be a noop
    bigbrother.config.set('bigbrother', 'smoothing_factor', '0')
    self.assertEqual([], smooth(None))
    self.assertEqual([], smooth([]))
    self.assertEqual([-3, 5, -7], smooth([-3, 5, -7]))

    # try actually smoothing
    bigbrother.config.set('bigbrother', 'smoothing_factor', '1')
    self.assertEqual([], smooth(None))
    self.assertEqual([], smooth([]))
    self.assertEqual([1], smooth([1]))
    self.assertAllClose([1.5, 2, 3, 4, 4.5], smooth([1, 2, 3, 4, 5]))
    self.assertAllClose([2.5, 2.667, 3.667, 5, 6], smooth([1, 4, 3, 4, 8]))

    bigbrother.config.set('bigbrother', 'smoothing_factor', '3')
    self.assertAllClose([2, 2, 2], smooth([1, 2, 3]))
    self.assertAllClose([3, 3, 3.5, 3.714, 4.857, 5.333, 5.4, 5.75],
                        smooth([1, 2, 5, 4, 3, 6, 5, 9]))


if __name__ == '__main__':
  deluxetest.main()
