#!/bin/bash
#
# bigbrother
# http://snarfed.org/space/bigbrother
# Copyright 2004 Ryan Barrett <bigbrother@ryanb.org>
#
# File: strip_days.sh
# In versions 0.4 and earlier, bigbrother created logs with both timestamps and
# day of week tags. The day of week tags are deprecated in versions 0.5
# forward, since they're redundant and can be out of sync with the timestamps.
# This script converts log files to be compatible with versions 0.5+ by
# removing the day of week tags.
#
# TODO: check that the first column contains only days of the week
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA

set -o noclobber

if (($# != 1)) || [[ $1 == "--help" || $1 == "-help" ]] ; then
  echo "Usage: strip_days.sh [LOGFILE]"
  exit 0
fi

mv -i $1 $1.bak || exit
cut -d' ' -f2- $1.bak >$1
