/*
 * $Id: serv_calendar.h,v 620.0 2004/03/27 02:33:32 ajc Exp $
 *
 * iCalendar implementation for Citadel/UX
 *
 */

/* 
 * "server_generated_invitations" tells the Citadel server that the
 * client wants invitations to be generated and sent out by the
 * server.  Set to 1 to enable this functionality.
 *
 * "avoid_sending_invitations" is a server-internal variable.  It is
 * set internally during certain transactions and cleared
 * automatically.
 */
struct cit_ical {
	int server_generated_invitations;
        int avoid_sending_invitations;
};

#define CIT_ICAL ((struct cit_ical *)CtdlGetUserData(SYM_CIT_ICAL))

/*
 * When saving a message containing calendar information, we keep track of
 * some components in the calendar object that need to be inserted into
 * message fields.
 */
struct icalmessagemod {
	char subject[SIZ];
	char uid[SIZ];
	time_t dtstart;
};
