#include "getwww.h"

/* KangChan Lee <dolphin@flower.comeng.chungnam.ac.kr> */
#ifndef INADDR_NONE 
#define INADDR_NONE     0xffffffff
#endif

/****************************************************************************************************/
int
check_hostname (char *dest_url)
{
  int port;
  int i, j;
  char *errpos;
  char portnum[256];
  char address[256];
  long int lport;
  struct hostent *host;
  struct in_addr *addr;
  struct servent *serv;

  HOST = INADDR_NONE;
  for (i = 7; dest_url[i] != ':' && dest_url[i]; i++)
    ;
  if (dest_url[i] == ':')
    {
      for (i++, j = 0; dest_url[i] != '/'; i++)
	portnum[j++] = dest_url[i];
      portnum[j] = NULL_CHAR;
      lport = strtol (portnum, &errpos, 0);
      if ((errpos[0] != 0) || (lport < 1) || (lport > 65535))
	usage ("#Invalid port address");
      PORT = htons (lport);
    }
  else
    PORT = htons ((long int) 80);

  for (i = 7, j = 0; dest_url[i] != '/' && dest_url[i] != ':'; i++)
    address[j++] = dest_url[i];
  address[j] = NULL_CHAR;

  for (i = 0; i < 3; i++)
    {
      /* First try it as aaa.bbb.ccc.ddd. */
      HOST = inet_addr (address);
      if (HOST != INADDR_NONE)
	break;
      else
	{
	  host = gethostbyname (address);
	  if (host != NULL)
	    {
	      addr = (struct in_addr *) *host->h_addr_list;
	      HOST = addr->s_addr;
	      break;
	    }
	  else
	    sleep (10 * (i + 1));
	}
    }
  if (HOST == INADDR_NONE)
    usage ("#can't connect to remote host--invalid hostname");
}

/****************************************************************************************************/
int
connect_host (void)
{

  int i;
  int sock;
  int connected;
  struct sockaddr_in address;

  memset ((char *) &address, 0, sizeof (address));
  address.sin_family = AF_INET;

  for (i = 0; i < 10; i++)
    {
      address.sin_port = (PORT);
      address.sin_addr.s_addr = HOST;
      sock = socket (AF_INET, SOCK_STREAM, 0);
      connected = connect (sock, (struct sockaddr *) &address, sizeof (address));
      if (connected < 0)
	{
	  if (sock > 0)
	    close (sock);
	  sleep (10 * (i + 5));
	  continue;
	}
      return (sock);
    }
  return (-1);
}

/****************************************************************************************************/
int
write_command (int sock, char *command, int command_len)
{

  size_t bytes_sent = 0;
  int this_write;

  while (bytes_sent < command_len)
    {
      do
	this_write = write (sock, command, command_len - bytes_sent);
      while ((this_write < 0) && (errno == EINTR));
      if (this_write <= 0)
	return this_write;
      bytes_sent += this_write;
      command += this_write;
    }
  return command_len;
}
