#!/usr/bin/perl
#######################################
# $Author: bruce $
# $Header: /home/bruce/work/cvsroot/wwwupdate/wwwupdate.pl,v 1.3 1998/08/12 17:46:46 bruce Exp $
#######################################
#
# $Log: wwwupdate.pl,v $
# Revision 1.3  1998/08/12 17:46:46  bruce
# Ignore comments in the config file.
#
# Revision 1.2  1998/02/18 14:20:27  bruce
# First public release.
#
# Revision 1.1.1.1  1998/02/11 13:28:37  bruce
# Initial load
#
# Revision 1.3  1998/01/25 20:56:15  bruce
# Fixed the "relink" function and cleaned a couple of bugs.  Still puts unnessarily
# - something the matter with modtime on the remote machine.
#
# Revision 1.2  1998/01/25 18:48:17  bruce
# Added Variable subsitution to the files
#
#
#######################################
# wwwupload
#
# script program to keep a remote WWW
# current with respect to a local set
# of html documents.
#
# 1.  Updates a remote set of html/gif/jpg/etc
#     files from a local copy.
# 2.  Re-arranges links in the documents so that
#     local copy and the remote copy remain 
#     valid.
#
#

use Net::FTP;
use Getopt::Long;

#
# Globals
local $temp_name = "___";
local @local_ascii;
local @local_binary;

#
# Start here
&setup_defaults; 		                   # setup command defaults
&read_cmdline_args;		                   # read in any cmd line args
&read_config_file;		                   # read in the configuration file
&check_sanity;                                     # is everything set to go.
&build_local_list;		                   # read local files names into memory
&build_remote_list;		                   # read remote file names into memory
&relink_local_files( @local_ascii);		   # change links in local files.
&transfer_files;		                   # dump logs
exit;

#
# Setup the defaults
sub setup_defaults {
    $config{'config-file'}		= './wwwupdate.config';
    $config{'debug-level'}    		= 3;
    $config{'host-local'}		= $ENV{'HOSTNAME'};
    chomp ( $config{'dir-local'}	= `pwd` );
    $config{'url-local'}                = '';
    $config{'url-remote'}               = ''; 
    $config{'host-remote'}              = '';
    $config{'dir-remote'}		= '.';
    $config{'user-remote'}		= $ENV{'USER'};
    $config{'password-remote'}		= '';
    $config{'bin-files'}		= '*.gif|*.jpg';
    $config{'ascii-files'}		= '.*html$|.*shtml$';
    $config{'recursive'}		= true;
    $config{'passive'}                  = false;
}

#
# Read the command line args and update the %config hash
sub read_cmdline_args {

    &GetOptions( "k=s@", \@ar );

    # Cycle throug the array of options and place them
    # into the hash of commandline args.
    foreach ( @ar ) {
	( $first, $second ) = split ( /=/, $_ );
	$cmdline{ $first } = $second;
    }	

    # The config file name is the *ONLY config item
    # we special case.  That is if the config_file is
    # set on the cmd line then we overrided the default
    # value right now!
    if( defined $cmdline{'config-file'}) {
	$config{'config-file'}=$cmdline{'config-file'};
    }	
}

#
# Read the configuration file and update the %config hash
sub read_config_file {
    $CONFIG_FILE=$config{'config-file'};
    open CONFIG_FILE or warn
	"config file \"$CONFIG_FILE\" could not be opened\n";
		
    while( <CONFIG_FILE> ) {
	chomp;
	next if /^#.*$/;
	($first, $second) = split( /=/ );
	$config{$first}=$second;
    }
}

#
# Check the sanity of the %config hash
sub check_sanity {
	
    # First thing: Integrate the cmd line args with config args
    foreach (keys %cmdline) {
	$config{$_} = $cmdline{$_};
    }

    # Now lets print the whole shebang!
    if( $config{'debug-level'} > 1) {
	foreach (sort keys %config) {
	    print "$_ ==> $config{$_}\n";
	}	
    }

    # Check that important stuff is there and
    # try and fudge them if they're not.
    length( $config{'host-remote'} ) > 0 or 
	die "host-remote *MUST* be specified\n";

    if( length( $config{'user-remote'} ) == 0 and 
	length( $config{'password-remote'} ) == 0 ) {

	$config{'user-remote'} = 'anonymous';
	$config{'password-remote'} = $config{'user-local'}.'@'.
	    $config{'host-local'};
    }		
}		

#
# Build the local file list with names and modification times
sub build_local_list {
    open( FIND_FILES, "find $config{'dir-local'} -print |" ) or
	die "Could not \"find\" files in  \"$config{'local-dir'}\"\n";

    while( <FIND_FILES> ) {	
	chomp;

	next if /^\.{1,2}$/;            # Don't mess with . or ..

	if( -d $_ ) {                   # Got a dir?
	    push @local_dirs, $_;       # stash it.
	}
	else {
	    # Make a check for ascii files
	    if( $_ =~ /$config{'ascii-files'}/ ) {
		push @local_ascii, $_;
	    }
	    else {
		push @local_binary, $_;
	    }	
	}	
     }

     if( $config{'debug-level'} > 2 ) {
	 print "Directories:\n";
	 foreach (@local_dirs) {
	     print "$_\n";
	 }

	 print "Ascii files:\n";
	 foreach (@local_ascii) {
	     print "$_\n"
	 }

	 print "Binary files:\n";
	 foreach (@local_binary) {
	     print "$_\n";
	 }
     }	
}	

#
# Build the remote file list with names and modification times
sub build_remote_list {
    $ftp = Net::FTP->new($config{'host-remote'}, 
			 Debug=>$config{'debug-level'},
			 Passive=>$config{'passive'});
    defined $ftp or die "FTP error: $@\n";

    $ftp->login( $config{'user-remote'}, $config{'password-remote'});
    
    # Read the contents of the dir and recurse through all subdirs 
    $ftp->cwd( $config{'dir-remote'});
    push @remote_dir_files, '.';
    scan_remote_dir( $config{'.'} );

    # Do some debugging here
    if( $config{'debug-level'} > 3 ) {
	print "Remote files:\n";
	foreach (@remote_files ) {
	    print "$_\n";
	}
	print "\nRemote directories:\n";
	foreach (@remote_dirs ) {
	    print "$_\n";
	}
    }
}

#
# Recursively build the directory and file structure
sub scan_remote_dir {
    local $cddir = $_[0];
    local @line, $name, $isdir;
    local @remote_dir_files, $cur_dir;

    push @remote_cur_dir, $cddir;

    @remote_dir_files = $ftp->dir();
    
    foreach( @remote_dir_files ) {
	next if /\.{1,2}$/;
	@line = split;
	next if $#line < 5;
	$name = $line[$#line];
	$isdir = ($line[0] =~ /^d/);

	$cur_dir = '.';
	foreach( @remote_cur_dir ) {
	    $cur_dir .= "$_/";
	}

	if( $config{ 'debug-level' } > 3 ) {
       	    print "$cur_dir$name; isdir=$isdir\n";
	}

       	# Ok. if its a dir, add its name to the list of dirs
	# and recurse into it...
	if( $isdir eq 1 ) {
	    push @remote_dirs, $cur_dir . $name;
	    $ftp->cwd( $name );
	    scan_remote_dir( $name );
	    
	    # Ok, done that one, up again and continue scanning
	    $ftp->cdup();
	    pop @remote_cur_dir;
	}
	else {
	    push @remote_files, $cur_dir . $name;
	}
    }
}    

#
# Search for local links and update them for remote system
sub relink_local_files {
    local @locals = @_;
    local $ifile, $ofile;

    if( $config{'debug-level'} > 2 ) {
	print "About to relink from:\n  $config{'url-local'}\n to\n  $config{'url-remote'}\n";
    }

    # Only do this shit if we have the two urls
    if( length( $config{'url-local'} ) > 0 and
	length( $config{'url-remote'} ) > 0 ) {

	foreach( @locals ) {
	    $ifile = $_;
	    $ofile = ">" . $_ . $temp_name;

	    open( IFILE, $ifile ) or die "Could not open \"$ifile\"\n";
	    open( OFILE, $ofile ) or die "Could not open \"$ofile\"\n";

	    while( <IFILE> ) {
		chop;
		s/$config{'url-local'}/$config{'url-remote'}/g;
		print OFILE "$_\n";
	    }
        }       
    }
}

#
# Hack the url strings so that the s///g can work.
sub rehack_the_urls {
    @_;
}

#
# Transfer the local files to the remote machine
sub transfer_files {
    local $this_local_dir, $found, $transfer;
    local $this_local_file, $this_remote_file;
    local $debug = $config{'debug-level'};

    # First check all the dirs on the remote machine,
    # creating them if not found
    if( $debug > 3) {
	print "Checking and creating remote dirs\n";
	print $ftp->pwd(); print "\n";
    }

    foreach( @local_dirs ) {
	$this_local_dir = &dest_file_magic( $_ );
	$found = 0;

	if( $debug > 3 ) {
	    print "Local dir: $this_local_dir\n";
        }

	foreach( @remote_dirs ) {
	    if( $_ eq $this_local_dir ) {
		$found = 1;
		break;
	    }
	}

	if( $found == 0 ) {
	    if( $debug > 3 ) {
		print "->Remote dir not found $this local dir\n";
	    }
	       
	    $ftp->mkdir( $this_local_dir );
	}
    }

    # Ok, now that the remote and local dirs are the same (we hope)
    # check the modification times of each of the files on the
    # remote machine.  Do the binary files first

    if( $debug > 2 ) {
	print "\nTransferring binary files\n";
    }
    $ftp->binary();
    &transfer_set_files( @local_binary );

    if( $debug > 2 ) {
	print "\nTransferring ascii files\n";
    }
    $ftp->ascii();
    &transfer_set_files( @local_ascii );
}

sub transfer_set_files {
    local $transfer, $found;
    local $this_local_file, $this_remote_file;
    local $debug = $config{'debug-level'};

    foreach( @_ ) {
	$this_local_file=$_;
	$mtime = (stat $this_local_file)[9];

	if( $debug > 3 ) {
	    print "LocalFile: " . $this_local_file."-(mtime)->".$mtime."\n";
	}
    
	$found=0; $transfer=0;
	foreach( @remote_files ) {
	    $this_remote_file = $_;

	    if( $debug > 3 ) {
		print "scanning remote file: $this_remote_file\n";
	    }

	    if( $this_remote_file eq $this_local_file ) {
		$found=1;
		if( $debug > 3 ) {
		    print "$this_remote_file matched. ";
		}

		$rem_mtime = $ftp->mdtm( $this_remote_file );

		if( $debug > 3 ) {
		    print "RemoteFile: " . $this_remote_file."-(mtime)->".$rem_mtime."\n";
		}
		    
		if(  $rem_mtime < $mtime ) {
		    if( $debug > 0 ) {
			print "$this_remote_file: $rem_mtime < $mtime : local file older\n";
		    }
		    $tranfer=1;
		}
		break;
	    }
	}

	if( $transfer == 1 ) {
	    if( $debug > 2) {
		print "transferring newer: $this_local_file -> $this_remote_file\n";
	    }
	    &do_ftp_put( $this_local_file, $this_remote_file );
	} 
	elsif( $found == 0 ) {
	    if( $debug > 2 ) {
		print "transferring new file: $this_local_file\n";
	    }
	    $dest_file=&dest_file_magic( $this_local_file );
	    &do_ftp_put( $this_local_file, $dest_file );
	}
    }
}

#
# Modify local filenames so comparions work!
sub dest_file_magic {
    local $local_file = @_[0];
    local $dest_file;

    $dest_file= "." . substr( $local_file, 
			      length($config{'dir_local'}),
			      length( $local_file ));
    $dest_file;
}

#
# Do the put (checking for relinked files all the while!
sub do_ftp_put {
    local $local_file = @_[0];
    local $dest_file = @_[1];
    local $relinked_local = $local_file . $temp_name;

    if( -e $relinked_local ) {
	$ftp->put( $relinked_local, $dest_file );
	unlink $relinked_local;
    }
    else {
	$ftp->put( $local_file, $dest_file );
    }
}

