/* vim: set sw=8 ts=8 si : */
/* Author: Guido Socher, Copyright: GPL */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include "htag.h"
#include "config.h"
static char *filename; /* the file name currently read */
/*end global data*/

void help()
{
        printf("htmlpp -- pre-process a html file for easy post-processing\n\
with awk, perl, sed, etc.\n\
\n\
USAGE: htmlpp [-h] html-files\n\
\n\
htmlpp removes line breaks in html tags that contain one of\n\
href=,name=,background=,src= and compensate the removed newlines\n\
later on by adding them after the next newline outside a tag.\n\
This way all tags start at the same line number as in the original file.\n\
This makes it possible to post-process tags with programs that\n\
work best in a line oriented mode (sed, awk, perl....).\n\
This program does not edit the file. All output goes to stdout.\n\
Note, for anchor tag start and end of anchor is not joined together.\n\
E.g it <a ...> is on one line but not necessarily the </a>.\n\
\n\
OPTIONS: -h this help\n\
	    \n");
#ifdef VERINFO
	puts(VERINFO);
#endif
	exit(0);
}
/* check if this is a tag that we would like to have straight on one line */
int evaltag(char *wholetag,int linenumber){
        char *pathstartptr;
        if (matchpat(wholetag," href *= *",&pathstartptr)){
		return(1);
	}
        if (matchpat(wholetag," name *= *",&pathstartptr)){
		return(1);
	}
        if (matchpat(wholetag," background *= *",&pathstartptr)){
		return(1);
	}
        if (matchpat(wholetag," src *= *",&pathstartptr)){
		return(1);
	}
        return(0);
}


int main(int argc, char *argv[])
{

	/* The following things are used for getopt: */
        extern char *optarg;
        extern int optind;
        extern int opterr;
	int ch;

	opterr = 0;
	while ((ch = getopt(argc, argv, "h")) != -1) {
		switch (ch) {
		case 'h':
			help(); /*no break, help does not return */
		case '?':
			fprintf(stderr, "ERROR: No such option. -h for help.\n");
			exit(1);
		/*no default action for case */
		}
	}
	if (optind == argc){
		help();
	}
	while(optind<argc){
		/* search for html tags and call the function evaltag */
		filename=argv[optind];
		prepro(evaltag,filename);
		optind++;
	}
	return(0);
}
