/***********************************************************
 * EarPlug - a Linux "LiveAudio"-like Plugin
 * Copyright (c) 1999 J.S.Kinnersley. All rights reserved.
 ***********************************************************/

import netscape.plugin.Plugin;

class FadeEarPlug extends Thread {
  int vle,vre;
  int time;
  EarPlug p;

  FadeEarPlug(int vl,int vr,int t,EarPlug pl) {
    p=pl;
    time=t;
    vle=vl; vre=vr;
    start();
  }

  public void run() {
    int vli=p.voll, vri=p.volr;
    int vlf,vrf,i,nsteps=15;
    i=0;
    while(i<nsteps) { 
      if(p.IsPlaying()) {
	i++;
	vlf=vli+(vle-vli)*i/nsteps;
	vrf=vri+(vre-vri)*i/nsteps;
	p.nSetVol(p.calcvol(vlf,vrf));
      } 
      try{sleep(time*1000/nsteps);} catch(Exception e) {}
    }
  }
}

/**
 * The "EarPlug" Plugin class.
 */
public class EarPlug extends Plugin {
  int voll,volr;
  FadeEarPlug fadeThread;
  int pmode,ready;
  int STOPPED,PAUSED,PLAYING;

  public EarPlug(String url) {
    play(0,url);
  }

  public void init() {
    System.out.println("EarPlug initialized");
    fadeThread=null;
    STOPPED=0;
    PAUSED=1;
    PLAYING=2;
  }

  native void nPlay(int loop,String url);
  native void nSetVol(int vol);
  native void nStop();

  int calcvol(int l,int r) {
    if(l>100) l=100; if(l<0) l=0;
    if(r>100) r=100; if(r<0) r=0;
    return l+256*r;
  }
  
  public native void pause();
  public native void pauseAll();
  public native void stopAll();
  public native void playAll();
  public native void disableConsole();
  public native void enableConsole();
  
  public void stop() { 
    if(fadeThread!=null) { fadeThread.stop(); fadeThread=null; }
    nStop();
  }

  /**
   * Plays a sound file 'url', where 'url' may be a local file name 
   * or an http address.
   * 'Loop' specifies the number of repetitions.
   */
  public void play(int loop,String url) { nPlay(loop,url);}
  /**
   * The 'loop' parameter may also either be 'true' for infinite loopiness,
   * or 'false' for a single rendition.
   */
  public void play(boolean loop,String url) {
    if(loop) play(-1,url); else play(1,url);  }
  /**
   * If the 'url' part is missed out, the most recent 
   * sound file is played again.
   */
  public void play(int loop) { nPlay(loop,"NULL");}
  public void play(boolean loop) {
    if(loop) play(-1,"NULL"); else play(1,"NULL");  }

  
  public int GetVolume() { return (voll+volr)/2; }
  public boolean IsReady() {if(ready==1) return true; return false;}
  public boolean IsPlaying() {
    if(pmode==PLAYING) return true; return false;}
  public boolean IsPaused() {
    if(pmode==PAUSED) return true; return false;}
  public boolean IsStopped() {
    if(pmode==STOPPED) return true; return false;}

  public void setvol(int vol) { 
    if(fadeThread!=null) { fadeThread.stop(); fadeThread=null; }
    voll=volr=vol;
    nSetVol(calcvol(vol,vol));
  }

  public void setvol(int voll,int volr) { 
    if(fadeThread!=null) { fadeThread.stop(); fadeThread=null; }
    this.voll=voll;
    this.volr=volr;
    nSetVol(calcvol(voll,volr));
  }
  
  public void fade_from_to(int vlf,int vlt) {
    setvol(vlf);
    fade_to(vlt);
  }

  public void fade_to(int vol) { fade_to(vol,vol,3);}

  public void fade_to(int vll,int vlr) {fade_to(vll,vlr,3);}

  public void fade_to(int vll,int vlr,int time) {
    if(fadeThread!=null) { fadeThread.stop(); fadeThread=null; }
    fadeThread=new FadeEarPlug(vll,vlr,time,this);
  }
}
