/* audioproc.cpp - part of MUSE
 * (c)2000 Denis Roio aka jaromil
 * audio processing core routines
 */

#include "generic.h"

int mixxx_mono_22(int *dest, short *chan, int num, float volume) {
  int c, off, tnum = (num<<1);
  int delta = (num << 16) / tnum;
  float l;
  for(c=0,off=0;c<tnum;c++,off += delta) {
    l = chan[off >> 16]*volume;
    dest[c<<1] = (int) (dest[c<<1]+l);
    dest[(c<<1)+1] = (int) (dest[(c<<1)+1]+l);
  }  
  return(c);
};

int mixxx_stereo_22(int *dest, short *chan, int num, float volume) {
  int c, off,tnum = (num<<1);
  int delta = (num << 16) / tnum;
  for(c=0,off=0;c<tnum;c++, off += delta)
    dest[c] = (int) (dest[c] + (chan[off >> 16]*volume));

  return(c);
  
}

int mixxx_mono_44(int *dest, short *chan, int num, float volume) {
  int c,cc;
  float l;
  
  for(c=0;c<num;c++) {
    cc = c<<1;
    l = chan[c]*volume;
    dest[cc] = (int) (dest[cc]+l);
    dest[cc+1] = (int) (dest[cc+1]+l);
  }

  return(c);

}

int mixxx_stereo_44(int *dest, short *chan, int num, float volume) {
  int c;

  for(c=0;c<num;c++)
    dest[c] = (int) (dest[c]+(chan[c]*volume));

  return(c);
}

void mixxx_stereo_44(int *dest, short *chan, int num) {
  int c;
  
  for(c=0;c<num;c++)
    dest[c] = (int) (dest[c] + chan[c]);

}

void clip_audio(int *pcm, short *clipped, int chunks) {
  int c;
  for(c=0;c<chunks;c++) {
    if(pcm[c]>32767)
      clipped[c]=32767;
    else if(pcm[c]<-32768)
      clipped[c]=-32768;
    else
      clipped[c]=(short)pcm[c];
  }
}

unsigned int get_level(short *pcm, int chunks) {
  int c;
  int max = 0;
  unsigned long int round;

  for(c=0;c<chunks;c+=2)
    if(pcm[c]>max)
      max = pcm[c];

  round = (unsigned long int) max;
  round = (unsigned long int)(round<<7)>>14;

  return((unsigned int)round);
}

/* the following is borrowed from xmms pitch plugin by jammet@lionking.org
   thanks to newmark for making it fit here */

#define DO_PITCH(type, length, newlength, buffer, newbuffer) \
{ \
	int delta = (length << 16) / newlength, i, off; \
	type *ptr = (type *)buffer, *newptr = (type *)newbuffer; \
	for(i = 0, off = 0; i < newlength; i++, off += delta) \
		*newptr++ = ptr[off >> 16]; \
}

int resample(short *in, long int length, short *out,int speed)
  /* lenght is the number of SAMPLES, not bytes
     newlenght returned is number of BYTES */
{ 
	long int newlength;
	newlength = (length * 100) / speed;
	DO_PITCH(int, length, newlength, in, out);

	/* return newlength * 4 */
	return newlength<<2;
}
