#ifndef __GENERIC_H
#define __GENERIC_H

/* soundcard tweaks */
#define SAMPLE_RATE 44100 // 44100
#define BUF_SIZE 4608 // 1152 (mp3 default framesize) *2 (16bit) *2 (stereo)
#define FRAGSIZE 0x000c // 4096 bytes
#define FRAGCOUNT 0x7fff // no limit

/* mp3 channels - the standard interface can't be changed from here
   uhm... you'd better not touch this, does'nt do what you wanna do */
#define MAX_CHANNELS 6

/* interval in seconds between every interface update
   mostly is not needed to tweak this. if you do it,
   do it wise. */
#define UPDATE_INTERVAL 0.0006

/* filesystem */
#define MAX_PATH_SIZE 200

/* port on wich MuSE listens when in daemon mode */
#define LISTENPORT 6969

/* VUMeter tweaks
   be careful: if (SPACING>(PEAK_VOLUME/NUM_CELLS)) bad_things_happen(tm); */
#define PEAK_VOLUME 256
#define NUM_CELLS 20
#define SPACING 2
#define TALK_VOLUME 0.3

/* clipping values *do not change unless you know what you do*
   i assume a thresold of 0.9 */
#define MAX_SAMPLE 32766
#define CLIP 29489
#define CLIP_A 10738729 // ((MAX_SAMPLE-CLIP)*(MAX_SAMPLE-CLIP))
#define CLIP_B 26212 // (MAX_SAMPLE-2*CLIP)

#endif
