#include <stdio.h>
#include <iostream.h>
#include <config.h>

/* headers needed for config stuff */
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
/* ------------------------------- */

#include "generic.h"
#include "gui_muse.h"
#include "gui_pixmaps.h"
#include "jmixer.h"
#include "libsync/synchronous.h"
#include <FL/fl_ask.H>
#include <FL/fl_file_chooser.H>

static LTI::Synchronous *dealer;
static Stream_mixer *mixer;
static Amuse *amuse;

/* where to store volumes for the talk func */
static float store_vol[MAX_CHANNELS];

/* resolves the bitrate widget choice */
int solve_bps(int bps_choice) {
  int bps = 0;

  switch(bps_choice) {
  case 0:
    bps = 8;
    break;
  case 1:
    bps = 16;
    break;
  case 2:
    bps = 24;
    break;
  case 3:
    bps = 32;
    break;
  case 4:
    bps = 56;
    break;
  case 5:
    bps = 64;
    break;
  case 6:
    bps = 96;
    break;
  case 7:
    bps = 128;
    break;
  }
  return(bps);
}

int solve_frequency(int freq) {
  int f = 0;
  switch(freq) {
  case 0:
    f = freq;
    break;
  case 1:
    f = 11000;
    break;
  case 2:
    f = 16000;
    break;
  case 3:
    f = 22050;
    break;
  case 4:
    f = 44100;
    break;
  }
  return(f);
}

inline void sync_mixer() {
  dealer->select.call(0,mixer,Stream_mixer::id_stream_mixer);
  dealer->wait();
}

/* ================================== config file stuff */

void save_conf() {
  char *home, *line;
  char config[MAX_PATH_SIZE];
  char temp[256];
  FILE *fd;
  
  home = getenv("HOME");
  sprintf(config,"%s/.muse/muserc",home);

  fd = fopen(config,"r+");
  if(fd==NULL) {
    fprintf(stderr,"cannot save configuration defaults to %s\n",config);
    return;
  }

  while(strncmp(temp,"[server]",8)!=0) {
    line = fgets(temp,256,fd);
    if(line==NULL) {
      fprintf(stderr,"configuration file broken: missing [server] section\n");
      return;
    }
  }

  /* 1 - server address */
  sprintf(temp,"%s\n",amuse->ip_input->value());
  fputs(temp,fd);

  /* 2 - port number */
  sprintf(temp,"%s\n",amuse->port_input->value());
  fputs(temp,fd);

  /* 3 - mount point */
  sprintf(temp,"%s\n",amuse->mount_input->value());
  fputs(temp,fd);

  /* 4 - bps TODO */
  sprintf(temp,"%u\n",amuse->bitrate_choice->value());
  fputs(temp,fd);
  
  /* 5 - metadata: name */
  sprintf(temp,"%s\n",amuse->name_input->value());
  fputs(temp,fd);

  /* 6 - metadata: url */
  sprintf(temp,"%s\n",amuse->url_input->value());
  fputs(temp,fd);
  
  /* 7 - metadata: description */
  sprintf(temp,"%s\n",amuse->description_input->value());
  fputs(temp,fd);

  fclose(fd);
}

void load_conf(FILE *fd) { 
  char *line = NULL, *p;
  char temp[256];
  
  while(strncmp(temp,"[server]",8)!=0) {
    line = fgets(temp,256,fd);
    if(line==NULL) break;
  }
  
  /* we don't have a server entry already */  
  if(line==NULL) return;
  
  /* 1 - server address */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->ip_input->value(temp);

  /* 2 - port number */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->port_input->value(temp);

  /* 3 - mount point */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->mount_input->value(temp);

  /* 4 - bps TODO */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->bitrate_choice->value(atoi(temp));

  /* 5 - metadata: name */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->name_input->value(temp);
  
  /* 6 - metadata: url */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->url_input->value(temp);

  /* 7 - metadata: description */
  line = fgets(temp,256,fd);
  if(line==NULL) return;
  p = temp; while(*p!='\n') p++; *p = '\0';
  amuse->description_input->value(temp);
  
}

void create_conf() {
  FILE *fd;
  char *home;
  char temp[MAX_PATH_SIZE];
  
  home = getenv("HOME");

  sprintf(temp,"%s/.muse",home);
  mkdir(temp,0744);
  
  sprintf(temp,"%s/.muse/muserc",home);
  fd = fopen(temp,"w");
  if(fd==NULL) {
    fprintf(stderr,"i don't reach to create a new default config file!\nbailing out :(\n");
    exit(1);
  }

  fprintf(stderr,"A new default config file has been created in %s\n",temp);
  fputs("# Config file generated automaticly by MuSE\n",fd);
  fputs("# the lines below are position sensitive\n",fd);
  fputs("# if you edit by hand here, do it wise ;^)\n",fd);
  sprintf(temp,"[version]\n%s\n",VERSION);
  fputs(temp,fd);
  fputs("[server]\n",fd);
  fclose(fd);

}

void check_conf() {
  FILE *fd;
  char *home;
  char temp[MAX_PATH_SIZE];
  
  home = getenv("HOME");

  sprintf(temp,"%s/.muse/muserc",home);
  fd = fopen(temp,"r");
  if(fd != NULL) {

    /* here we read what we need from muse.conf */    
    load_conf(fd);

    fclose(fd);
  } else {
    fprintf(stderr,"This seems the first time you run MuSE\n");
    create_conf();
  }
}



/* ============================== end config file stuff */

void init_callbacks(Stream_mixer *mix, Amuse *gui) {
  mixer = mix;
  amuse = gui;
  dealer = (LTI::Synchronous *)gui->getSynchronous();
  check_conf();
}

void set_channel(Fl_Widget *o, void *ch, int song){
  int tmpchan = *(int*)ch;
  int result;
  /* playlist starts from 0   Fl browser value starts from 1 */ 
  if (mixer->playlist[tmpchan].loaded) {
    sync_mixer();
    result = mixer->set_channel(tmpchan,(song-1));
    switch (result) {
    case 0:
      amuse->status_main->value("unable to open the bitstream");
      break;
    case 1:
      amuse->chan[tmpchan]->playlist_browser->value(song);
      amuse->chan[tmpchan]->timeline_slider->activate();
      amuse->chan[tmpchan]->timeline_slider->value(0.0);     
      amuse->chan[tmpchan]->time->value("00:00:00");
      amuse->chan[tmpchan]->name->value(amuse->chan[tmpchan]->playlist_browser->text(song)); 
      break;
    case 2:
      amuse->chan[tmpchan]->playlist_browser->value(song);
      amuse->chan[tmpchan]->timeline_slider->deactivate();     
      amuse->chan[tmpchan]->time->value("");
      amuse->chan[tmpchan]->name->value(amuse->chan[tmpchan]->playlist_browser->text(song));
      break;
    }
  }
}

void cb_set_channel(Fl_Widget *o, void *ch) {
  int song = ((Fl_Select_Browser *)o)->value();
  set_channel(o, ch, song);
}

void cb_set_channel_plus(Fl_Widget *o, void *ch) {  
  int tmpchan = *(int*)ch;
   int song = amuse->chan[tmpchan]->playlist_browser->value();
   song++;
   if (song <= amuse->chan[tmpchan]->playlist_browser->size())
     set_channel(o, ch, song);
   else cout << "no more left \n";
}

void cb_set_channel_minus(Fl_Widget *o, void *ch) {
  int tmpchan = *(int*)ch;  
   int song = amuse->chan[tmpchan]->playlist_browser->value();
   song--;
   if (song > 0)
     set_channel(o, ch, song);
   else cout << "no more in playlist \n";
}

void cb_play_channel(Fl_Widget *o, void *ch) {
  sync_mixer();
  mixer->play_channel(*(int*)ch);
}

void cb_stop_channel(Fl_Widget *o, void *ch) {
  int tmpchan = *(int*)ch;
  sync_mixer();
  mixer->stop_channel(tmpchan);
  amuse->chan[tmpchan]->timeline_slider->value(0.0);
  amuse->chan[tmpchan]->time->value("00:00:00");
}

void cb_pause_channel(Fl_Widget *o, void *ch) {
  sync_mixer();
  mixer->pause_channel(*(int*)ch);
}

void cb_set_volume(Fl_Widget *o, void *ch) {
  float vol = ((Fl_Slider *)o)->value();
  sync_mixer();
  mixer->set_volume(*(int*)ch,vol);
}

void cb_set_speed(Fl_Widget *o, void *ch) {
  int speed = (int) ((Fl_Slider *)o)->value();
  sync_mixer();
  mixer->set_speed(*(int*)ch,speed);
}

void cb_set_position(Fl_Widget *o, void *ch) {
  float pos = ((Fl_Slider *)o)->value();
  sync_mixer();
  if(!mixer->set_position(pos,*(int*)ch)) {
    char temp[100];
    sprintf(temp,"Urg! it seems i can't seek position on channel [%u]",*(int*)ch);
    fl_alert(temp);
  }
}

void cb_set_playmode(Fl_Widget *o, void *ch) {
  int i = *(int*)ch;

  switch (mixer->xach[i]->playmode)
    {
    case 0: /* LOOP -> PLAY */
      o->label("play");
      mixer->xach[i]->playmode = mixer->xach[i]->PLAY;
      break;
    case 1: /* CONT -> LOOP */
      o->label("loop");
      mixer->xach[i]->playmode = mixer->xach[i]->LOOP;
      break;
    case 2: /* PLAY -> CONT */
      o->label("cont");
      mixer->xach[i]->playmode = mixer->xach[i]->CONT;
      break;
    }

}

void cb_set_icecast(Fl_Widget *o) {

  if(((Fl_Light_Button *)o)->value()==0) { /* stop the stream */
  
    sync_mixer();
    mixer->stop_icecast();
    
    amuse->ip_input->activate();
    amuse->port_input->activate();
    amuse->mount_input->activate();
    amuse->name_input->activate();
    amuse->url_input->activate();
    amuse->description_input->activate();
    amuse->pass_input->activate();
    amuse->connect_button->label("connect");
    amuse->bitrate_choice->activate();
    amuse->login_choice->activate();

  } else { /* set the stream */
    
    char *ip, *port, *mount, *pass, *name, *url, *desc;
    int bps, login;
    int frequency, lowpass = 0, highpass = 0, mode, quality;
    unsigned long int nport;

    ip = (char*)amuse->ip_input->value();
    port = (char*)amuse->port_input->value();
    nport = strtol(port,(char **)NULL,10);
    
    mount = (char*)amuse->mount_input->value();
    pass = (char*)amuse->pass_input->value();
    bps = amuse->bitrate_choice->value();

    name = (char*)amuse->name_input->value();
    url = (char*)amuse->url_input->value();
    desc = (char*)amuse->description_input->value();

    frequency = amuse->resample_choice->value();
    mode = amuse->channels_choice->value();
    quality = (int)amuse->quality_slide->value();
    
    switch(amuse->filtering_choice->value()) {
    case 0:
      lowpass = 0; highpass = 0;
      break;
    case 1:
      lowpass = -1; highpass = -1;
      break;
    case 2:
      lowpass = atoi(amuse->lowpassfreq_input->value());
      highpass = atoi(amuse->highpassfreq_input->value());
      break;
    }

    bps = solve_bps(bps);
    frequency = solve_frequency(frequency);
    login = amuse->login_choice->value();
    
    sync_mixer();

    mixer->set_lame(bps, frequency, mode, quality, lowpass, highpass);

    sync_mixer();

    if(mixer->set_icecast(ip,nport,pass,mount,bps, name, url, desc, login)) {
      ((Fl_Light_Button *)o)->set();
      save_conf();
    } else
      ((Fl_Light_Button *)o)->clear();      
  }

}

void cb_set_talk(Fl_Widget *o) {
  int i;
  float temp_vol[amuse->numch];


  if(((Fl_Light_Button *)o)->value()==1) { 
    /* talk is not active; activate it */  
    for (i = 0; i < amuse->numch; i++) {
      store_vol[i] = amuse->chan[i]->volume_slider->value();
      if(store_vol[i]<TALK_VOLUME)
	temp_vol[i] = 0.0;
      else
	temp_vol[i] = TALK_VOLUME;
      amuse->chan[i]->volume_slider->value(temp_vol[i]);
    }

    sync_mixer();
    mixer->set_all_volumes(&temp_vol[0]);

  } else {   
    /* deactivate talk : bring volumes back up */
    for (i = 0; i < amuse->numch; i++)
      amuse->chan[i]->volume_slider->value(store_vol[i]);
    
    sync_mixer();
    mixer->set_all_volumes(&store_vol[0]);
    
  }

}

void cb_set_linein(Fl_Widget *o) {
  bool res;

  sync_mixer();

  res = mixer->set_live(((Fl_Light_Button *)o)->value());

  if(res)
    ((Fl_Light_Button *)o)->set();
  else
    ((Fl_Light_Button *)o)->clear();
}

void cb_set_lineout(Fl_Widget *o) {
  bool res;

  sync_mixer();

  res = mixer->set_lineout(((Fl_Light_Button *)o)->value());
  
  if(res)
    ((Fl_Light_Button *)o)->set();
  else
    ((Fl_Light_Button *)o)->clear();
  
}

void cb_save_file(Fl_Widget *o) {
  const char *filename;

  filename = amuse->filesave_input->value();

  /* TURNING ON */
  if (((Fl_Light_Button *)o)->value() == 1)
    {
      if ((filename[0] == '\0') || (filename[0] ==  ' '))   
	{
	  amuse->status_main->value("you need to type in a filename");
	  amuse->filesave_button->value(0);
	} else {
	  int res, bps, freq, mode, quality, lowpass = 0, highpass = 0;	  

	  /* retrieve lame settings */
	  bps = solve_bps(amuse->bitrate_choice->value());
	  freq = amuse->resample_choice->value();
	  mode = amuse->channels_choice->value();
	  quality = (int) amuse->quality_slide->value();
	  
	  switch(amuse->filtering_choice->value()) {
	  case 0:
	    lowpass = 0; highpass = 0;
	    break;
	  case 1:
	    lowpass = -1; highpass = -1;
	    break;
	  case 2:
	    lowpass = atoi(amuse->lowpassfreq_input->value());
	    highpass = atoi(amuse->highpassfreq_input->value());
	    break;
	  }
	  freq = solve_frequency(freq);
	  
	  sync_mixer();
	  mixer->set_lame(bps, freq, mode, quality, lowpass, highpass);

	  /* input syntax ok, let's start recording */
	  sync_mixer();
	  res = mixer->set_mp3file((char*)filename, bps);
	  /* if res -1 should notice error */

	  amuse->filebrowse_button->deactivate();
	  amuse->filesave_input->deactivate();
	  amuse->status_main->value(filename);
	}
    }

  /* TURNING OFF */
  if (((Fl_Light_Button *)o)->value() == 0)
    {
      /* let's shutdown file recording */
      sync_mixer();
      mixer->stop_mp3file();

      amuse->filebrowse_button->activate();
      amuse->filesave_input->activate();
      amuse->status_main->value(" ");
      
    }
}

void cb_browse_file(Fl_Widget *o) {
    char *filename;
    filename = fl_file_chooser("Pick a file", "*", "");
    amuse->filesave_input->value(filename); 
}

void cb_browse_playlist(Fl_Widget *o, void *ch) {
  char *filename;
  int i = *(int *)ch;
  filename = fl_file_chooser("Pick a playlist", "*", "");

  sync_mixer();
  mixer->set_playlist(filename,i);
  //    amuse->status_main->value("ehy! where is that playlist file you said??");
}

void cb_filtering_choice(Fl_Widget *o) {

  int i = amuse->filtering_choice->value();
  switch(i) {
  case 0:
  case 1:
    amuse->lowpassfreq_input->deactivate();
    amuse->highpassfreq_input->deactivate();
    break;
  case 2:
    amuse->lowpassfreq_input->activate();
    amuse->highpassfreq_input->activate();
    break;
  }
}

Fl_Window *infowindow = NULL;
inline void infoz() {

  static char temp[128];

  infowindow = new Fl_Window(300, 350, "Multiple Streaming Engine");
  
  sprintf(temp,"%s v%s\nhttp://muse.dyne.org",PACKAGE,VERSION);

  Fl_Box *box = new Fl_Box(35, 15, 250, 30, temp);
  box->align(FL_ALIGN_LEFT|FL_ALIGN_TOP|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
  box->labelsize(12);
  box->labelfont(1);

  Fl_Box *authors = new Fl_Box(15, 70, 250, 50, "Authors:\n   engine by jaromil\n   gui by august black\n\n");
  authors->align(FL_ALIGN_LEFT|FL_ALIGN_TOP|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
  authors->labelsize(12);
  authors->labelfont(1);
  
  Fl_Box *contribs = new Fl_Box(15,130,250,50, "Contributors:\n   markus seidl, newmark, asbesto\n");
  contribs->align(FL_ALIGN_LEFT|FL_ALIGN_TOP|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
  contribs->labelsize(11);
  contribs->labelfont(1);

  Fl_Box *thanks = new Fl_Box(15,170,250,50, "Thanks to:\n   SERVUS.AT, hell voyager, loa,\n   bbk, alex+rasty+martinez");
  thanks->align(FL_ALIGN_LEFT|FL_ALIGN_TOP|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
  thanks->labelsize(11);
  thanks->labelfont(1);

  Fl_Box *radio = new Fl_Box(15,220,250,50, "MuSE screams on:\n   radiocybernet - http://kyuzz.org/radiocybernet\n   fundamental radio - http://funda.ment.org\n   standup radio - http://standup.dyne.org");
  radio->align(FL_ALIGN_LEFT|FL_ALIGN_TOP|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
  radio->labelsize(11);
  radio->labelfont(1);
  
  Fl_Box *disclaimer = new Fl_Box(15,280,290,50, "MuSE comes with ABSOLUTELY NO WARRANTY\n This is Free Software, and you are welcome\n to redistribute it under certain conditions\n refer to the Gnu Public License for details");
  disclaimer->align(FL_ALIGN_LEFT|FL_ALIGN_TOP|FL_ALIGN_INSIDE|FL_ALIGN_WRAP);
  disclaimer->labelsize(11);
  disclaimer->labelfont(1);
    
  Fl_Button *but = new Fl_Button(10, 15, 20, 20);
  but->box(FL_FLAT_BOX);
  but->down_box(FL_FLAT_BOX);
  pixmap_peach.label(but);

 
  infowindow->end();
  infowindow->show();
}

void cb_open_info(Fl_Widget *o) {
  if(infowindow!=NULL) {
    if(!infowindow->shown())
      infoz();
  } else
    infoz();
}

void cb_add(Fl_Widget *o){
  //  Amuse *amuse = ((Amuse *)o->parent());
  if (amuse->numch < MAX_CHANNELS) {
    sync_mixer();
    if (mixer->create_channel(amuse->numch)) {

      if (amuse->numch == 0) amuse->talk_button->show();
      amuse->chan[amuse->numch]->show(); // = new GuiChannel(0, 0, 300, 150, "whatever", amuse->numch);
      amuse->add(amuse->chan[amuse->numch]);
      amuse->numch++;
      if (amuse->col < amuse->colwidth) {
	amuse->col++;
      } else {  
	amuse->row++;
	amuse->col = 1; 
      }
      amuse->reshape();
      amuse->redraw(); 
    }
  }
}

void cb_remove(Fl_Widget *o){
  if (amuse->numch > 0) {
    sync_mixer();


    amuse->numch--; 
    mixer->delete_channel(amuse->numch);
    amuse->chan[amuse->numch]->hide();     

    amuse->col--;
    if (amuse->col <= 0) {
      amuse->row--;
      amuse->col = amuse->colwidth; 
    }
    amuse->reshape();
    amuse->redraw(); 
  } 
}

void cb_view(Fl_Widget *o) {
  if (amuse->conf_win->visible() == false)
    amuse->conf_win->show();
  else amuse->conf_win->hide();
}
void cb_levels(Fl_Widget *o) {
  if (amuse->level_win->visible() == false) {
    amuse->mix_monitor->showit = true;
    amuse->level_win->show();
  }  else {
    amuse->mix_monitor->showit = false;
    amuse->level_win->hide();
  }
}
void gui_quit(Fl_Menu_* o, void* v) {
  amuse->quit = true;
}
