#ifndef __GUI_CALLBACKS_H__
#define __GUI_CALLBACKS_H__

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Slider.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Browser.H>
#include <FL/Fl_Round_Button.H>

#include "jmixer.h"
#include "libsync/synchronous.h"

inline void sync_mixer();
void init_callbacks(Stream_mixer *mix, Amuse *gui);
void set_channel(Fl_Widget *o, void *ch, int song);
void cb_set_channel(Fl_Widget *o, void *ch);
void cb_set_channel_plus(Fl_Widget *o, void *ch);
void cb_set_channel_minus(Fl_Widget *o, void *ch);
void cb_play_channel(Fl_Widget *o, void *ch);
void cb_stop_channel(Fl_Widget *o, void *ch);
void cb_pause_channel(Fl_Widget *o, void *ch);
void cb_set_volume(Fl_Widget *o, void *ch);
void cb_set_speed(Fl_Widget *o, void *ch);
void cb_set_position(Fl_Widget *o, void *ch);
void cb_set_playmode(Fl_Widget *o, void *ch);
void cb_set_icecast(Fl_Widget *o);
void cb_set_talk(Fl_Widget *o);
void cb_set_linein(Fl_Widget *o);
void cb_set_lineout(Fl_Widget *o);
void cb_save_file(Fl_Widget *o);
void cb_browse_file(Fl_Widget *o);
void cb_browse_playlist(Fl_Widget *o, void *ch);
void cb_filtering_choice(Fl_Widget *o);
void cb_open_info(Fl_Widget *o);
void cb_add(Fl_Widget *o);
void cb_remove(Fl_Widget *o);
void cb_view(Fl_Widget *o);
void cb_levels(Fl_Widget *o);

void gui_quit(Fl_Menu_* o, void* v);

#endif
