#include "gui_channel.h"
#include "gui_callbacks.h"
#include "gui_pixmaps.h"
#include <iostream.h>


void cb_resize(Fl_Widget *o, void *ch) {
  GuiChannel *tmp = ((GuiChannel*)o->parent());
  Amuse *amuse = ((Amuse *)tmp->parent());
  //change
  if (tmp->fullsize == true) {
    tmp->playlist_browser->hide();
    tmp->resize(tmp->x(), tmp->y(), tmp->w(), 150);
    tmp->resize_button->resize(tmp->x()+278, tmp->y()+130, 15, 15);
    tmp->resize_button->label("@2>");
    tmp->corner_button->resize(tmp->x()+250, tmp->y()+133, 10, 10);
    tmp->playmode_button->resize(tmp->x()+200, tmp->y()+130, 40, 15);
    tmp->volume_slider->type(3);
    tmp->volume_slider->resize(tmp->x()+12, tmp->y()+105, 280, 20);
    tmp->volume_slider->minimum(0);
    tmp->volume_slider->maximum(1);
    tmp->fullsize = false;
  } else {
    tmp->resize(tmp->x(), tmp->y(), tmp->w(), 220);
    tmp->resize_button->resize(tmp->x()+278, tmp->y()+200, 15, 15);
    tmp->resize_button->label("@8>");
    tmp->corner_button->resize(tmp->x()+250, tmp->y()+203, 10, 10);
    tmp->playmode_button->resize(tmp->x()+200, tmp->y()+200, 40, 15);
    tmp->volume_slider->type(4);
    tmp->volume_slider->resize(tmp->x()+12, tmp->y()+104, 25, 90);
    tmp->volume_slider->minimum(1);
    tmp->volume_slider->maximum(0);
    tmp->playlist_browser->resize(tmp->x()+44, tmp->y()+98, 248, 96);
    tmp->playlist_browser->show();
    tmp->fullsize = true;
  }
    //dont change
  tmp->time->resize(tmp->x()+10, tmp->y()+12, 100, 25);
  //tmp->resize_button->resize(tmp->x()+278, tmp->y()+75, 15, 15);
  tmp->stepback_button->resize(tmp->x()+130, tmp->y()+12, 25, 25);
  tmp->play_for_button->resize(tmp->x()+165, tmp->y()+12, 25, 25);
  tmp->pause_button->resize(tmp->x()+195, tmp->y()+12, 25, 25);
  tmp->stop_button->resize(tmp->x()+230, tmp->y()+13, 23, 23);
  tmp->goforward_button->resize(tmp->x()+265, tmp->y()+12, 25, 25);
  tmp->timeline_slider->resize(tmp->x()+12, tmp->y()+47, 280, 17);
  tmp->name->resize(tmp->x()+12, tmp->y()+75, 280, 23);

  amuse->reshape();
  tmp->parent()->redraw();
}


GuiChannel::GuiChannel(int x, int y, int w, int h, char *label, int z) : Fl_Group(x,y,w,h) {
  id =z;
  fullsize=false;
  box(FL_UP_BOX);
  labeltype(FL_ENGRAVED_LABEL);
  labelsize(12);
  align(FL_ALIGN_TOP_LEFT);
  //color(15);

  { Fl_Output* o = time = new Fl_Output(x+10, y+12, 100, 25);
  o->box(FL_BORDER_BOX);
  o->color(9);
  o->selection_color(9);
  o->labelsize(12);
  o->labeltype(FL_NO_LABEL);
  o->textfont(0);
  o->textsize(24);
  o->value("00:00:00");
  }
  { 
    Fl_Button* o = stepback_button = new Fl_Button(x+130, y+12, 25, 25, "@|<");
    o->box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->callback(cb_set_channel_minus, (void *) &id);
    o->selection_color(15);
    o->labelcolor(24);
  }
  { 
    Fl_Button* o =  play_for_button = new Fl_Button(x+165, y+12, 25, 25, "@>");
    o->box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->callback(cb_play_channel, (void *) &id);
    o->selection_color(15);
    //o->color(15);
    o->labelcolor(24);
  }
  { 
    Fl_Button* o = pause_button = new Fl_Button(x+195, y+12, 25, 25, "@||");
    o->box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->callback(cb_pause_channel, (void *) &id);
    //o->color(15);
    o->selection_color(15);
    o->labelcolor(24);
  }
  { 
    Fl_Button* o = stop_button = new Fl_Button(x+230, y+13, 23, 23, "@circle");
    o->box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->labelsize(10);
    o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    o->callback(cb_stop_channel, (void *) &id);
    //o->color(15);
    o->selection_color(15);
    o->labelcolor(24);
  }
  { 
    Fl_Button* o = goforward_button = new Fl_Button(x+265, y+12, 25, 25, "@>|");
    o->box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->callback(cb_set_channel_plus, (void *) &id);
    //o->color(15);
    o->selection_color(15);
    o->labelcolor(24);
  }
  
  { 
    Fl_Slider* o = volume_slider = new Fl_Slider(x+12, y+105, 280, 20, "vol");
    o->type(3);
    o->align(FL_ALIGN_BOTTOM_LEFT);
    o->labelsize(9);
    o->minimum(0);
    o->maximum(1);
    o->value(1);
    o->slider_size(.14);
    o->step(.01);
    o->callback(cb_set_volume, (void *) &id);
    //o->color(15);
  }
  { 
    Fl_Slider* o = timeline_slider = new Fl_Slider(x+12, y+47, 280, 17);
    o->type(5);
    //o->box(FL_FLAT_BOX);
    //o->color(15);
    o->slider_size(.14);
    o->callback(cb_set_position, (void *) &id);
    //o->color(15);
  }
  { 
    Fl_Select_Browser * o = playlist_browser = new Fl_Select_Browser(x+44, y+98, 248, 96, "label");
    o->box(FL_FLAT_BOX);
    o->color(0);
    o->textcolor(23);
    o->selection_color(55);
    o->labeltype(FL_NO_LABEL);
    o->textsize(10);
    o->callback(cb_set_channel, (void *) &id);
    o->hide();
  }
  { 
    Fl_Output* o = name = new Fl_Output(x+12, y+75, 280, 23);
    o->box(FL_FLAT_BOX);
    o->color(0);
    o->selection_color(0);
    o->labeltype(FL_NO_LABEL);
    o->textsize(12);
    o->textcolor(23);
  }
  { 
    Fl_Button* o = resize_button = new Fl_Button(x+278, y+130, 15, 16, "@2>");
    o->box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->callback(cb_resize, (void *) &id);
    //o->color(15);
    o->labelcolor(24);
  }
  { 
    Fl_Button* o = corner_button = new Fl_Button(x+250, y+133, 10, 10, "@+");
    o->box(FL_FLAT_BOX);
    o->down_box(FL_FLAT_BOX);
    o->labeltype(FL_SYMBOL_LABEL);
    o->labelsize(10);
    //o->color(15);
    o->labelcolor(24);
    //pixmap_dots3.label(o);
    o->callback(cb_browse_playlist, (void *)&id);
  }
  { 
    Fl_Button* o = playmode_button = new Fl_Button(x+200, y+130, 40, 16, "play");
    o->box(FL_FLAT_BOX);
    o->labelsize(10);
    //o->color(15);
    //o->labelcolor(24);
    o->callback(cb_set_playmode, (void *) &id);
  }
  end(); 
  
}
