#include "gui_extras.h"
#include <FL/fl_draw.H>
#include <iostream.h>

LevelBlock::LevelBlock(int X, int Y, int W, int H) : Fl_Widget(X,Y,W,H)
{ 
  Color[0] = 15;
  Color[1] = 15;
  color_index = 0;
  x = X;
  y = Y;
  w = W;
  h = H;
}

void LevelBlock::draw()
{
  fl_rectf(x, y, w, h);
}

Level::Level(int X, int Y, int W, int H) : Fl_Group(X,Y,W,H) 
{
  showit = false;

  unsigned int totalspacing = (unsigned int)(H - (SPACING * NUM_CELLS))/NUM_CELLS; 
  unsigned int blockheight = (unsigned int)totalspacing - SPACING;

  int n = 0;
  int i = 0;
  unsigned int x = PEAK_VOLUME;
  block[NUM_CELLS-1] = new LevelBlock(X,Y,W,blockheight);
  block[NUM_CELLS-1]->Color[1] = FL_RED;
  for (i = NUM_CELLS-2; i>=0; i--)
    { 
      x = x - (PEAK_VOLUME/NUM_CELLS);
      n  = n + totalspacing;
      block[i] = new LevelBlock(X, Y+n, W, blockheight);
      if (x > (PEAK_VOLUME/NUM_CELLS)*(NUM_CELLS-2))
	{
	  block[i]->Color[1] = FL_YELLOW;
	}
      else
	{
	  block[i]->Color[1] = FL_GREEN;
	}
    }
  
  n = NUM_CELLS;
  for (i = NUM_CELLS-1; i >= 0; i--)
    {
      value[i] = (PEAK_VOLUME/NUM_CELLS)*n;
      //      cout << "value[" << i << "]:  " << value [i] << endl;
      n--;
    }
  end();  // from the FLTK documentation....says this is needed for extending Fl_Group
}

void Level::draw() 
{
  for (int i = 0; i < NUM_CELLS; i++)
    {
      fl_color(block[i]->Color[block[i]->color_index]);
      block[i]->draw();
    }
}

void Level::draw_levels(unsigned short int x) 
{
 
  int i;
  
  for(i=0;i<NUM_CELLS;i++) {
    if(x>value[i])
      block[i]->color_index = 1;
    else
      block[i]->color_index = 0;
  }
  redraw();

}

/*
  int j,i;
  for (i = 0; i < NUM_CELLS; i++)
    {
      if (x > value[i]) 
	 {
  	  for (j = i; j < NUM_CELLS; j++) //count up from i, paint its color
  	      block[j]->color_index = 1;

	  i--;  //step one down in the array

    	  for(j = i; j >= 0; j--)  // count down from i, paint grey
    	      block[j]->color_index = 0;
  	  break;
  	} else
	  for(j = i; j >= 0; j--)
	    block[j]->color_index = 0;
	  
    }
  redraw();

}
*/
