#include "gui_muse.h"
#include "gui_callbacks.h"
#include "gui_extras.h"
#include "gui_pixmaps.h"
#include <iostream.h>
#include "config.h"

static char muse_version[16];
Fl_Menu_Item Amuse::menu_main_menu[] = {
  { "Click", 0, 0, 0, FL_SUBMENU, 4, 0, 12, 0},
    { "Add Chan",  FL_ALT + 'a', (Fl_Callback*)cb_add, 0, 0, 5, 0, 12, 0},
    { "Rem Chan",  FL_ALT + 'r', (Fl_Callback*)cb_remove, 0, 0, 5, 0, 12, 0},
    { "Connect",  FL_ALT + 'c', (Fl_Callback*)cb_view, 0, 0, 5, 0, 12, 0 },
    { "Levels",  FL_ALT + 'l', (Fl_Callback*)cb_levels, 0, 0, 5, 0, 12, 0 },
    { "About ...", 0, (Fl_Callback*)cb_open_info,0, 0, 5, 0, 12, 0},
    { "Quit", FL_CTRL + 'q' , (Fl_Callback*)gui_quit, 0, 0, 5, 0, 12, 0},
    { 0 },
  { 0 }
};

Fl_Menu_Item Amuse::menu_bitrate_choice[] = {
 {"8", 0,  0, 0, 4, 4, 0, 12, 0},
 {"16", 0,  0, 0, 4, 4, 0, 12, 0},
 {"24", 0,  0, 0, 4, 4, 0, 12, 0},
 {"32", 0,  0, 0, 4, 4, 0, 12, 0},
 {"56", 0,  0, 0, 4, 4, 0, 12, 0},
 {"64", 0,  0, 0, 4, 4, 0, 12, 0},
 {"96", 0,  0, 0, 4, 4, 0, 12, 0},
 {"128", 0,  0, 0, 4, 4, 0, 12, 0},
 {0}
};

Fl_Menu_Item Amuse::menu_resample_choice[] = {
  {"auto", 0, 0, 0, 4, 4, 0, 12, 0},
  {"11Khz", 0, 0, 0, 4, 4, 0, 12, 0},
  {"16khz", 0, 0, 0, 4, 4, 0, 12, 0},
  {"22khz", 0, 0, 0, 4, 4, 0, 12, 0},
  {"44khz", 0, 0, 0, 4, 4, 0, 12, 0},
  {0}
};

Fl_Menu_Item Amuse::menu_channels_choice[] = {
  {"stereo", 0, 0, 0, 4, 4, 0, 12, 0},
  {"jstereo", 0, 0, 0, 4, 4, 0, 12, 0},
  {"dual chan", 0, 0, 0, 4, 4, 0, 12, 0},
  {"mono", 0, 0, 0, 4, 4, 0, 12, 0},
  {0}
};

Fl_Menu_Item Amuse::menu_filtering_choice[] = {
   {"auto", 0, 0, 0, 4, 4, 0, 12, 0},
   {"none", 0, 0, 0, 4, 4, 0, 12, 0},
   {"manual", 0, 0, 0, 4, 4, 0, 12, 0},
   {0}
};
   
Fl_Menu_Item* Amuse::eight = Amuse::menu_bitrate_choice + 0;
Fl_Menu_Item* Amuse::sixteen = Amuse::menu_bitrate_choice + 1;
Fl_Menu_Item* Amuse::twentyfour = Amuse::menu_bitrate_choice + 2;
Fl_Menu_Item* Amuse::thirtytwo = Amuse::menu_bitrate_choice + 3;
Fl_Menu_Item* Amuse::fiftysix = Amuse::menu_bitrate_choice + 4;
Fl_Menu_Item* Amuse::sixtyfour = Amuse::menu_bitrate_choice + 5;
Fl_Menu_Item* Amuse::ninetysix = Amuse::menu_bitrate_choice + 6;
Fl_Menu_Item* Amuse::onetwentyeight = Amuse::menu_bitrate_choice + 7;

Fl_Menu_Item Amuse::menu_login[] = {
 {"x_audiocast", 0,  0, 0, 4, 4, 0, 12, 0},
 {"icy", 0,  0, 0, 4, 4, 0, 12, 0},
 {0}
};
Fl_Menu_Item* Amuse::icy = Amuse::menu_login + 0;
Fl_Menu_Item* Amuse::x_audiocast = Amuse::menu_login + 1;


void Amuse::reshape() {
  int row_height[row+1];
  int tempH, tmp, newX, newY, tmpCol, tmpRow;
  newX = 200; newY = 50;  
  tmp = 0;
  for (int n = 0; n <= row; n++) 
    row_height[n] = 0;

  if (numch > 0 && chan[0]) {
    /* find out the height of each row */
    for (int n = 0; n <= row; n++) {
      row_height[n] = 0;
      for (int i = 0; i < colwidth; i++) {
	tempH = chan[tmp]->h();
	if (tempH > row_height[n])
	  row_height[n] = tempH;
	if (++tmp >= numch) break;
      }
    }
    
    /* move each to new X and Y coords */
    newX =10;
    tmpCol = 0; tmpRow = 0;
    for (int count = 0; count < numch; count++) {
      if (tmpCol == (colwidth)) {
	newY = newY + row_height[tmpRow] +10;
	newX = 10;
	tmpRow++;
	tmpCol=0;
      }
      chan[count]->position(newX, newY);
      newX += 310;
      tmpCol++;
    }
  }
  
  if (numch == 0) {
    this->resize(x(),y(), 310 , 70);
    talk_button->hide();
  }else {   /* get dimensions for main window  */  
    this->resize(x(),y(), (row > 0) ? (colwidth*310 +10): newX , (newY+row_height[row]+30));
  }
  status_ice->resize(10, 30, w()-20, 12);
  status_main->resize(10, h()-20, w()-100, 12);
  talk_button->position(w() - 190, 5);
  linein_button->position(w() - 140, 5);
  lineout_button->position(w() - 77, 5);
  version->position(w()-100, h() -20);
  significalafica->position(w()-25, h()-23);
    
}


Amuse::Amuse(int w, int h, const char *title) : Fl_Double_Window(w,h,title) {

  synchronous.registerObjectName("Amuse");

  numch = 0;
  row = col = 0;
  colwidth = 2;
  sprintf(muse_version, "%s %s", PACKAGE, VERSION);

  for (int i = 0; i < MAX_CHANNELS; i++) {
    chan[i] = new GuiChannel(0, 0, 300, 150, "whatever", i);
    chan[i]->hide();
  }

  { 
    Fl_Menu_Bar* o = main_menu = new Fl_Menu_Bar(2, 5, 190, 22, " ");
    o->box(FL_FLAT_BOX);
    o->down_box(FL_FLAT_BOX);
    o->selection_color(95);
    o->labeltype(FL_NO_LABEL);
    o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    o->menu(menu_main_menu);
    //o->color(15);
  }

  { 
    Fl_Output* o = status_ice = new Fl_Output(10, 30, w-20, 12);
    o->box(FL_FLAT_BOX);
    o->color(FL_GRAY);
    o->textcolor(36);
    o->labeltype(FL_NO_LABEL);
    o->textsize(10);
    o->selection_color(49);
    //o->value("Ice Area");
  }
  { 
    Fl_Light_Button* o = talk_button = new Fl_Light_Button(w-190, 5, 49, 20, "talk");
    o->labeltype(FL_ENGRAVED_LABEL);
    o->labelsize(12);
    o->type(FL_TOGGLE_BUTTON);
    o->shortcut(0x20);
    //o->color(15);
    o->hide();
    o->callback(cb_set_talk);
  }
  { 
    Fl_Light_Button* o = linein_button = new Fl_Light_Button(w-140, 5, 62, 20, "line-in");
    o->labeltype(FL_ENGRAVED_LABEL);
    o->labelsize(12);
    o->type(FL_TOGGLE_BUTTON);
    //o->color(15);
    o->callback(cb_set_linein);
  }
  { 
    Fl_Light_Button* o = lineout_button = new Fl_Light_Button(w-77, 5, 68, 20, "speaker");
    o->labeltype(FL_ENGRAVED_LABEL);
    o->labelsize(12);
    o->type(FL_TOGGLE_BUTTON);
    //o->color(15);
    o->callback(cb_set_lineout);
  }
  { 
    Fl_Output* o = status_main = new Fl_Output(10, h-20, w-100, 12);
    o->box(FL_FLAT_BOX);
    o->color(FL_GRAY);
    o->textcolor(40);
    o->textfont(2);
    o->labeltype(FL_NO_LABEL);
    o->textsize(10);
    //o->value("Status Area");
  }  
  { 
    Fl_Button* o = version = new Fl_Button(w-100, h-20, 77, 20, muse_version);
    o->box(FL_FLAT_BOX);
    o->down_box(FL_FLAT_BOX);
    o->labeltype(FL_ENGRAVED_LABEL);
    o->labelfont(2);
    o->labelsize(12);
    //o->color(15);
  }
  { 
    Fl_Button* o = significalafica = new Fl_Button(w-25, h-23, 23, 25);
    o->box(FL_FLAT_BOX);
    o->down_box(FL_FLAT_BOX);
    //o->color(15);
    pixmap_peach.label(o);
    //o->callback(cb_open_info);
  }
  /*----LEVELS -------------*/
  {
    Fl_Window* o = level_win = new Fl_Window(70, 225, muse_version);
    o->hide();
    mix_monitor = new Level(25, 25, 20, 200); 
    o->end();
  }
  /*END LEVELS -------------*/
  { 
    Fl_Window* o = conf_win = new Fl_Window(500,400, muse_version);
    o->hide();
    {
      Fl_Input* o = ip_input = new Fl_Input(100, 50, 135, 20, "Host");
      o->color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Int_Input* o = port_input = new Fl_Int_Input(270, 50, 45, 20, "Port");
      o->color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Input* o = mount_input = new Fl_Input(370, 50, 72, 20, "MntPnt");
      o->color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Input* o = name_input = new Fl_Input(100, 80, 165, 20, "Name");
      o->color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Input* o = url_input = new Fl_Input(300, 80, 142, 20, "Url");
      o->color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Input* o = description_input = new Fl_Input(100, 110, 342, 20, "Description");
      o->color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Input* o = pass_input = new Fl_Input(252, 140, 80, 20, "Pass");
      o->type(5);
      o->color(52);
      o->selection_color(52);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->hide();
    }
    {
      Fl_Choice* o = login_choice = new Fl_Choice(100, 140, 100, 20, "login type");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(11);
      o->menu(menu_login);
      o->value(0);
      //o->callback(cb_set_bitrate);
      //o->hide();
    }
    {
      Fl_Light_Button* o = connect_button = new Fl_Light_Button(342, 140, 100, 20, "connect");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->selection_color(FL_RED);
      o->type(FL_TOGGLE_BUTTON);
      o->callback(cb_set_icecast);
      //o->value(1);
      //o->hide();
    } 

    {
      Fl_Choice* o = bitrate_choice = new Fl_Choice(100, 230, 95, 20, "bitrate");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(11);
      o->menu(menu_bitrate_choice);
      o->value(2);
      //o->hide();
    }
    {
      Fl_Choice* o = resample_choice = new Fl_Choice(100, 260, 95, 20, " frequency ");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(11);
      o->menu(menu_resample_choice);
      o->value(0);
      //o->hide();
    } 
    {
      Fl_Choice* o = channels_choice = new Fl_Choice(100, 290, 95, 20, " channels ");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(11);
      o->menu(menu_channels_choice);
      o->value(3);
      //o->hide();
    }
    
    {
      Fl_Value_Slider* o = quality_slide = new Fl_Value_Slider(305, 300, 130, 20, " quality (1 = best)");
      o->type(1);
      o->selection_color(15);
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(11);
      o->minimum(1);
      o->maximum(9);
      o->step(1);
      o->value(4);
      // o->callback((Fl_Callback*)callback);
      //o->hide();
    }
    /* FREQUENCY FILTERING */
    {
      Fl_Choice* o = filtering_choice = new Fl_Choice(360, 230, 75, 20, " frequency filtering ");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->textsize(11);
      o->menu(menu_filtering_choice);
      o->value(0);
      o->callback(cb_filtering_choice);
      //o->hide();
    }
    {
      Fl_Input* o = lowpassfreq_input = new Fl_Input(275, 260, 50, 20, " lowpass Hz ");
      o->color(52);
      o->labelsize(9);
      o->textsize(12);
      o->deactivate();
      //o->hide();
    }
    
    {
      Fl_Input* o = highpassfreq_input = new Fl_Input(385, 260, 50, 20, " highpass Hz ");
      o->color(52);
      o->labelsize(9);
      o->textsize(12);
      o->deactivate();
      //o->hide();
    }
    /* SAVE FILE TO DISK PART */
    {
      Fl_Light_Button* o = filesave_button = new Fl_Light_Button(100, 350, 100, 20, "Save to File:");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->selection_color(FL_RED);
      o->type(FL_TOGGLE_BUTTON);
      o->callback(cb_save_file);
      //o->hide();
    } 
    {
      Fl_Input* o = filesave_input = new Fl_Input(205, 350, 145, 20, "Save to File:");
      o->color(52);
      o->labeltype(FL_NO_LABEL);
      o->labelsize(12);
      o->textsize(12);
      //o->align(FL_ALIGN_TOP_LEFT);
      //o->value("saved.mp3");
      //o->hide();
    }
    { 
      Fl_Button* o = filebrowse_button = new Fl_Button(360, 350, 72, 20, "Browse..");
      o->labeltype(FL_ENGRAVED_LABEL);
      o->labelsize(12);
      o->callback(cb_browse_file);
      //o->hide();
    }
    /* --- end FILE TO DISK --- */
    /* ----------------------- */ 
    {
      Fl_Output* o = status_lame = new Fl_Output(50, 190, 395, 24);
      o->box(FL_FLAT_BOX);
      o->color(47);
      o->textcolor(36);
      o->labeltype(FL_NO_LABEL);
      o->textsize(12);
      o->selection_color(49);
      o->value("no encoder detected!");
      //o->hide();
    }
    {
      Fl_Output* o = status_libshout = new Fl_Output(50, 20, 395, 24);
      o->box(FL_FLAT_BOX);
      o->color(47);
      o->textcolor(36);
      o->labeltype(FL_NO_LABEL);
      o->textsize(12);
      o->selection_color(49);
      o->value("Streaming source authentication");
      //o->hide();
    }
    o->end();
  }
  //color(15);
  end();

  quit = false;

}

  

void Amuse::run() {

  //mainwindow->show();
  show();

    while(!quit) {	
      if(Fl::wait(UPDATE_INTERVAL)<0.0 || !shown()) 
        quit = true;
    }

  fprintf(stderr,"Amuse gui exiting\n");

}




