/* inchannels.h - MuSE
   (c)2000 Denis Roio aka jaromil
   see COPYING for licensing stuff

   different classes for different IN channels
   they are instantiated and used by the Stream_mixer class (jmixer.cpp)
*/

#ifndef __INCHANNELS_H
#define __INCHANNELS_H

#define MP3CHAN 1
#define OGGCHAN 2

#include <stdio.h>
#include <config.h>

/* muse generic tweakin headers */
#include "generic.h"

/* mixing and audioprocessing */
#include "audioproc.h"

#ifdef HAVE_XAUDIO
/* xaudio lib */
#include "xaudio/include/decoder.h"
#endif

#ifdef HAVE_VORBIS
/* oggvorbis lib */
extern "C" {
#include <ogg/ogg.h>
#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>
}
#endif

/* mpeg lib (splay) */
#include "libmpeg/mpegsound.h"

struct timecode {
  int h;
  int m;
  int s;
  float f;
};

typedef int (Mixer )(int*, short*, int, float);

/* parent class Channel
   this class shadows codec specific classes to the jmixer
   never instantiated: it's being inherited from decoders
*/

class Channel {
 private:
  virtual float get_audio() = 0;

 public:
  Channel() { };
  virtual ~Channel() { };

  virtual int set(char *file) = 0;
  virtual bool play() = 0;
  virtual bool stop() = 0;
  virtual bool pos(float pos) = 0;
  virtual float mix(int *mixpcm) = 0;

  float upd_time();
  bool set_mixer();
  Mixer *mixxx;  

  float volume;
  float position;
  int speed;
  struct timecode time;

  int samplerate;
  int channels;
  int bitrate;
  
  enum { LOOP, CONT, PLAY } playmode;

  bool opened;
  bool on;
  bool update;
  bool seekable;
  int in_smp;
  int frametot, framepos, fps;  

  int type;
};

#ifdef HAVE_XAUDIO
/* Xaudio Channel // mp3 layer I,II decoding */

class XaudioChannel: public Channel {
private:
  XA_DecoderInfo *decoder;
  float get_audio();
  
public:
  XaudioChannel();
  ~XaudioChannel();
  int set(char *file);
  bool play();
  bool stop();
  bool pos(float pos);
  float mix(int *mixpcm);

  XA_InputInfo *input;
  XA_StatusInfo *status;
  XA_OutputBufferInfo *buffer;
};
#endif

#ifdef HAVE_VORBIS

/* OggVorbis Channel // ogg-vorbis decoding */

class OggChannel: public Channel {
 private:
  OggVorbis_File   *vf;
  vorbis_info      *vi;
  
  int current_section, old_section;

  FILE *oggfile;
  float get_audio();

 public:
  OggChannel();
  ~OggChannel();

  int set(char *file);
  bool play();
  bool stop();
  bool pos(float pos);
  float mix(int *mixpcm);
};

#endif

/* Mpeg Channel // MPEG-1 layer 1,2,3 and MPEG-2 layer 3 */

class MpegChannel: public Channel {
 private:
  Soundinputstream *loader;
  Mpegtoraw *server;
  void clean();
  float get_audio();
  int framesize;
  
 public:
  MpegChannel();
  ~MpegChannel();
  
  int set(char *file);
  bool play();
  bool stop();
  bool pos(float pos);
  float mix(int *mixpcm);

};

/* dsp-in Channel // get sound from soundcard's dsp */
  
class LiveIn {
 private:
  int *dsp;
  unsigned int num_samples;
  int sample_rate;
  int opt;

  int get_audio();  

 public:
  LiveIn(int smpr, int chans, int *thedsp);
  ~LiveIn();
  
  int mix(int *mixpcm);

  short *gotin;
  int channels;
  int rate;
  bool on;
};

#endif
