/* jmixer.h - MuSE
   (c)2000-2001 Denis Roio aka jaromil
   see COPYING for licensing stuff

   Stream mixer headerfile
*/

#ifndef __JMIXER_H
#define __JMIXER_H

#include <unistd.h>
#include <stdlib.h>

#include "generic.h"
#include "inchannels.h"
#include "outchannels.h"
#include "libsync/synchronous.h"
#include "gui_muse.h"
#include "playlist.h"

class Stream_mixer: public LTI::Object {

private:

  Amuse *gui;
  bool have_gui;

  int dsp;
  bool fullduplex;
  bool have_sound;

  LiveIn *livein;
  
  void close_soundcard();
  void upd_timeline(int ch, float res);
  void updchan(int ch, float res);
  
public:
  Stream_mixer();

  void run();

  void register_gui(Amuse *reg_gui);
  bool open_soundcard();
  bool set_icecast(char *ip, int port, char *pass, char *mountpoint, int bps, char *name, char *url, char *desc, int login);
  void set_lame(int bps, int freq, int mode, int quality, int lowpass, int highpass);
  void stop_icecast();
  int set_mp3file(char *file, int bps);
  void stop_mp3file();
  void cafudda();
  int set_channel(int ch, int playlist_pos);
  bool create_channel(int ch);
  void delete_channel(int ch);
  void play_channel(int ch);
  bool stop_channel(int ch);
  void pause_channel(int ch);
  void set_all_volumes(float *vol);
  void set_volume(int ch, float vol);
  void set_speed(int ch, int speed);
  bool set_position(float pos, int ch);
  bool set_live(bool stat);
  bool set_lineout(bool stat);
  bool set_playlist(char *file, int ch);

  /* channels and playlists */
  Channel *xach[MAX_CHANNELS];
  Playlist playlist[MAX_CHANNELS];

  /* encoder outchannel */
  LameEnc lame;

  /* ice shouter */
  IcecastOut ice;

  /* file dump */
  Mp3fileOut mp3file;

  /* this is for the libsync - registering synchronized id */
  static const int id_stream_mixer = 1;

  bool dspout;
  bool icecastout;
  bool fileout;
  bool quit;
  
  /* that's the socket registered from netlistener */
  int *client;

  ~Stream_mixer();
};

#endif
