/* timing.c
 * - Timing functions
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#ifdef _WIN32
#include <mmsystem.h>
#endif /* WIN32 */

#include "timing.h"

/* 
 * Returns milliseconds no matter what. 
 */
long long timing_get_time(void)
{
#ifdef _WIN32
	return timeGetTime();
#else 
	struct timeval mtv;

	gettimeofday(&mtv, NULL);

	return (long long)(mtv.tv_sec) * 1000 + (long long)(mtv.tv_usec) / 1000;
#endif /* _win32 */
}

/* When anyone feels like doing it this way.
   Note that checking the sleeper struct values
   after a call to select() is _not_ portable 
void
timing_sleep (long long sleeptime)
{
	struct timeval sleeper, remains;
	remains.tv_sec = sleeptime / 1000;
	remains.tv_usec = (sleeptime % 1000) * 1000;
#ifdef HAVE_NANOSLEEP
	do {
		sleeper.tv_sec = remains.tv_sec;
		sleeper.tv_usec = remains.tv_usec;
	} while (nanosleep (&sleeper, &remains) == -1);
#else		
	select (1, NULL, NULL, NULL, &sleeper);
#endif	
}
*/


void timing_sleep(long long sleeptime)
{
	struct timeval sleeper;

	sleeper.tv_sec = 0;
	sleeper.tv_usec = sleeptime * 1000;

	select (1, NULL, NULL, NULL, &sleeper);
}
