Name: libsync
Summary: A C++ framework for synchronous active objects
Version: 1.01
Release: 1
Source: libsync-%{version}.tar.gz
Group: Development/Libraries
URL: http://ltiwww.epfl.ch/~dbarth/libsync
BuildRoot: /var/tmp/%{name}-buildroot
Copyright: GPL
Packager: David Barth <David.Barth@epfl.ch>
Prefix: /usr

%description
This library contains C++ classes implementing the concept of synchronous active objects, providing a framework to ease the production of robust, secure distributed and/or multi-threaded applications.
This library is adapted from sJava (see http://ltiwww.epfl.ch/sJava) which itselfs builds on the basics of sC++, a synchronous extension to C++.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q -n libsync-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
	--prefix=%{prefix}
make

%install
make install prefix=$RPM_BUILD_ROOT/%{prefix}
rm -f libsync/docs/en/Makefile*
mv libsync/main.cpp libsync/example.cpp

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' \
			 > $RPM_BUILD_DIR/file.list.%{name}

find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' \
       >> $RPM_BUILD_DIR/file.list.%{name}

find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' \
				>> $RPM_BUILD_DIR/file.list.%{name}

%clean
rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files -f ../file.list.%{name}
%doc AUTHORS COPYING ChangeLog INSTALL README TODO
%doc libsync/docs/en/index.html libsync/docs/en/index-1.html
%doc libsync/docs/en/index-2.html libsync/docs/en/index-3.html
%doc libsync/docs/en/index-4.html libsync/docs/en/index-5.html
%doc libsync/api
%doc libsync/example.cpp
%defattr(-,root,root,0755)

%changelog
* Tue May  2 2000 David Barth <David.Barth@epfl.ch>
- changed build process to automate doc generation
- bumped version to 1.01 to reflect the stable state

* Wed Mar 29 2000 David Barth <David.Barth@epfl.ch>
- more documentation

* Mon Dec 13 1999 David Barth <David.Barth@epfl.ch>
- first release
