/* muse.cpp - MuSE
   (c)2000 Denis Roio aka jaromil
   see COPYING for licensing stuff

   here command line is parsed
   synchronous object are launched depending on mode selection
   threads are joined at the end */

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "config.h"
#include "generic.h"
#include "jmixer.h"
#include "netlistener.h"
#include "scheduler.h"
#include "gui_muse.h"
#include "gui_callbacks.h"
//#include "libsync/synchronous.h"

/* command line stuff */

char *version =
"%s version %s [ http://muse.dyne.org ]\n"
"(c)2000-2001 jaromil & august black\n\n";

char *help =
"Usage: muse [options]\n\n"
"Generic options\n"
"-h --help\tthis help\n"
"-v --version\tversion information\n"
//"-d --debug\tturn debug informations on\n"
"-D --daemon\tdaemon mode: do not spawn amuse local interface\n"
"-l --playlist\tuse filename as playlist (default ./playlist)\n"
"-q --queue\tqueue mode: process filename as a queue (default ./queue)\n"
"\n"
"--\n"
"for any further information refer to http://muse.dyne.org\n";

static const struct option long_options[] = {
  { "help", no_argument, NULL, 'h' },
  { "version", no_argument, NULL, 'v' },
  { "debug", no_argument, NULL, 'd' },
  { "daemon", no_argument, NULL, 'D' },
  { "playlist", required_argument, NULL, 'l' },
  { "queue", required_argument, NULL, 'q' },
  { 0, 0, 0, 0 }
};

char *short_options = "hvdDl:q:";

/* misc settings */
bool debug = false;
bool daemon_mode = false;
bool queue_mode = false;
char playlist[256];
char queue_file[256];

void take_args(int argc, char **argv) {
  int res;
  char temp[256];

  strcpy(playlist,"./playlist");
  strcpy(queue_file,"./queue");

  sprintf(temp,version,PACKAGE,VERSION,PACKAGE);
  fprintf(stderr,"%s",temp);
  
  do {
    res = getopt_long(argc, argv, short_options, long_options, NULL);

    switch(res) {
    case 'h':
      fprintf(stderr,"%s",help);
      exit(0);
      break;
    case 'v':
      exit(0);
      break;
    case 'd':
      debug = true;
      break;
    case 'D':
      daemon_mode = true;
      break;
    case 'q':
      strncpy(queue_file,optarg,256);
      queue_mode = true;
    case 'l':
      strncpy(playlist,optarg,256);
      break;
    }
  } while(res > 0);

}

int main(int argc, char **argv) {

  take_args(argc, argv);

  /* change those for having the stderr flodded by
     the libsync threaded kernel debugging messages */
  LTI::Kernel::trace = false;
  LTI::Kernel::debug = false;

  fprintf(stderr,"starting engine...\n");

  Stream_mixer *mix = new Stream_mixer();

  if(!mix->open_soundcard()) {
    fprintf(stderr,"exiting.\n");
    exit(1);
  }

  if(queue_mode) {

    mix->start();
  
    Scheduler *queue = new Scheduler(queue_file,mix);
    
    queue->start();
    
    queue->join();
    mix->join();
    
  } else if(daemon_mode) {
    
    mix->start();

    Net_listener *net = new Net_listener(LISTENPORT,mix);
    
    net->start();
    
    net->join();
    mix->join();
  } else {
    
    Amuse *gui = new Amuse(310, 70, PACKAGE);

    init_callbacks(mix,gui);

    mix->register_gui(gui);

    gui->start();
    mix->start();

    gui->join();
    mix->quit = true;
    mix->join();
  }

  fprintf(stderr,"cya!\n");

  exit(0);
}
