/* outchannels.cpp - MuSE
   (c)2000 Denis Roio aka jaromil
   see COPYING for licensing stuff

   different classes for different OUT channels
   they are instantiated and used by the Stream_mixer class (jmixer.cpp)
*/

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "generic.h"
#include "outchannels.h"

/* mp3 encoder */

#define ENCBUFFER_SIZE 65536

static unsigned char buffer[ENCBUFFER_SIZE];
static unsigned long int encoded;

LameEnc::LameEnc() {
  initialized = false;
}

/* note: num is number of samples in the L (or R) channel
   not the total number of samples in pcm[] */
void LameEnc::encode(short int *pcm, int num) {
  encoded = lame_encode_buffer_interleaved(&enc_flags, pcm, num, (char *)buffer, ENCBUFFER_SIZE);
}

void LameEnc::init(int nbps, int freq, int mode, int quality, int lowpass, int highpass) {

  lame_init(&enc_flags);
  enc_flags.num_channels = 2; /* the mixed input stream is stereo */
  enc_flags.in_samplerate = SAMPLE_RATE; /* the mixed input stream is 44khz */
  if(freq>0) enc_flags.out_samplerate = freq;
  enc_flags.brate = nbps;
  enc_flags.mode = mode; /* 0,1,2,3 stereo,jstereo,dual channel,mono */
  enc_flags.quality = quality;
  enc_flags.error_protection = 1; /* 2 bytes per frame for a CRC checksum */
  
  /* lame chooses for us frequency filtering when values are 0 */
  enc_flags.lowpassfreq = lowpass;
  enc_flags.highpassfreq = highpass;

  lame_init_params(&enc_flags);
  initialized = true;
  bps = nbps;

}

char *LameEnc::version() {
  lame_version(&enc_flags,&ver[0]);
  return(&ver[0]);
}

LameEnc::~LameEnc() { }

/* IcecastOut */

IcecastOut::IcecastOut() {

  initialized = false;
  running = false;

}

IcecastOut::~IcecastOut() {
  if(running)
    stop();
}

bool IcecastOut::start() {

  if(initialized&&!running) {
    shout_init_connection(&ice_conn);
    ice_conn.ip = ip;
    ice_conn.port = port;
    ice_conn.password = pass;
    ice_conn.mount = mountpoint;
    ice_conn.bitrate = bps*1000;
    ice_conn.name = name;
    ice_conn.url = url;
    ice_conn.description = description;
    ice_conn.icy_compat = login;

    fprintf(stderr,"Contacting icecast server ...");
    
    if(shout_connect(&ice_conn)) {
      fprintf(stderr," done\n");
      running = true;
    } else {
      fprintf(stderr," ops!\nunable to connect or reach host\n");
      running = false;
    }
    return(running);
  } else
    return(false); /* icecast connection not initialized or already running */
}

void IcecastOut::stop() {
  if(running) {
    shout_disconnect(&ice_conn);
    running = false;
  }
}

bool IcecastOut::set_server(char *naddress, int nport, char *npass, char *nmountpoint, int nbps, int nlogin) {
  struct sockaddr_in server_addr;
  struct hostent *h;

  stop();

  memset(&server_addr, 0, sizeof(struct sockaddr_in));
  server_addr.sin_family = AF_INET;

#ifdef HAVE_INET_ATON
  inet_aton(naddress,&server_addr.sin_addr);
#else
  server_addr.sin_addr.s_addr=inet_addr(naddress);
#endif

  if(!(h = gethostbyname(naddress)))
     return(false);
     
  server_addr.sin_family = AF_INET;
  memcpy(&server_addr.sin_addr, h->h_addr, h->h_length);    
  
  sprintf(ip,"%s",
	  inet_ntoa(*(struct in_addr *) &server_addr.sin_addr.s_addr));
  
  port = nport;
  strncpy(pass,npass,64);
  strncpy(mountpoint,nmountpoint,32);
  bps = nbps;
  login = nlogin;
  
  initialized = true;
  return(initialized);
}

void IcecastOut::set_meta(char *nname, char *nurl, char *ndesc) {
  if(strcmp(nname,"")!=0)
    strncpy(name,nname,64);
  else
    strcpy(name,"succhio");
  
  if(strcmp(nurl,"")!=0)
    strncpy(url,nurl,128);
  else
    strcpy(url,"http://muse.dyne.org");

  if(strcmp(ndesc,"")!=0)
    strncpy(description,ndesc,256);
  else
    strcpy(description,"Broadcasting with MuSE Multiple Streaming Engine !");
}

int IcecastOut::send() {
  if(running&&(encoded>0)) {
    int res;
    sync();
    res = shout_send_data(&ice_conn, buffer, encoded);
    if(!res)
      return(ice_conn.error);
  }
  return(0);  
}

void IcecastOut::sync() {
  shout_sleep(&ice_conn);
}

/* Mp3fileOut */

Mp3fileOut::Mp3fileOut() { 
  opened = false;
}

bool Mp3fileOut::openmp3(char *file) {

  if(opened)
    closemp3();

  strncpy(filename,file,MAX_PATH_SIZE);
  
  /* creates a file write only non blocking (-rw-rw-r--) */
  fd = fopen(filename,"w");

  if(fd!=NULL)
    opened = true;

  return(opened);
}

int Mp3fileOut::writemp3() {
  int res = -1;
  
  if(opened&&(encoded>0)) {
    syncmp3();
    res = fwrite(buffer,1,encoded,fd);
  }
  return(res);
}

void Mp3fileOut::closemp3() {
  if(opened) {
    fclose(fd);
    opened = false;
  }
}

bool Mp3fileOut::syncmp3() {
  if(fflush(fd)!=0)
    return(false);
  else
    return(true);
}

Mp3fileOut::~Mp3fileOut() {
  if(opened)
    closemp3();
}
