/* outchannels.h - MuSE
   (c)2000 Denis Roio aka jaromil
   see COPYING for licensing stuff

   different classes for different OUT channels
   they are instantiated and used by the Stream_mixer class (jmixer.cpp)
*/

#ifndef __OUTCHANNELS_H
#define __OUTCHANNELS_H

#include "generic.h"

extern "C" {
#include <lame.h>
#include "libshout/shout.h"
}

class LameEnc {
 private:
  lame_global_flags enc_flags;
 public:
  LameEnc();
  void encode(short int *pcm, int num);
  void init(int nbps, int freq, int mode, int quality, int lowpass, int highpass);
  char *version();
  int bps;
  bool initialized;
  char ver[30];

  ~LameEnc();
};

class IcecastOut {
private:
  void sync();

  shout_conn_t ice_conn;
  
  char ip[64];
  int port;
  char pass[64];
  char mountpoint[32];
  int bps;
  int login;
  char name[64];
  char url[128];
  char description[256];
  bool initialized;

public:
  IcecastOut();

  bool start();
  void stop();
  bool set_server(char *naddress, int nport, char *npass, char *nmountpoint, int nbps,int nlogin);
  void set_meta(char *nname, char *nurl, char *ndesc);
  int send();

  bool running;

  ~IcecastOut();
};

class Mp3fileOut {
 private:
  FILE *fd;
  char filename[MAX_PATH_SIZE];
  bool opened;

  bool syncmp3();

 public:
  Mp3fileOut();
  bool openmp3(char *file);
  int writemp3();
  void closemp3();
  
  ~Mp3fileOut();
};

#endif
