/* playlist.cpp - MuSE
   (c)2000 Denis Roio aka jaromil
   see COPYING for licensing stuff

   playlist container class
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "playlist.h"
#include "generic.h"

Entry::Entry(char *file) {
  name = strdup(file);
}

Entry::~Entry() {
  free(name);
}

Playlist::Playlist() {
  loaded = false;
  length = 0;
  first = NULL;
  selected = NULL;
  last = NULL;
}

Playlist::~Playlist() {
  clear();
}

void Playlist::add(char *file) {
  Entry *ptr;

  if(first==NULL) { /* that's the first entry */
    first = new Entry(file);
    first->next = NULL;
    first->prev = NULL;
  } else { /* add the entry to the end */
    ptr = first;
    while(ptr->next!=NULL)
      ptr = ptr->next;
    
    ptr->next = new Entry(file);
    ptr->next->next = NULL;
    ptr->next->prev = ptr;
  }
  length++;
}
  
void Playlist::clear() {
  if(loaded) {
    Entry *ptr = first, *tptr;
    int c;
    free(filename);
    for(c=0;c<length;c++) {
      tptr = ptr->next;
      delete ptr;
      ptr = tptr;
    }
    length = 0;
    first = NULL;
    selected = NULL;
    last = NULL;
    loaded = false;
  }
      
}

bool Playlist::load(char *file) {
  char temp[MAX_PATH_SIZE], *p;
  int c = 0;
  FILE *fd;

  clear();

  fd = fopen(file, "r");
  if(fd==NULL)
    return(false);
  while(fgets(temp,MAX_PATH_SIZE,fd)!=NULL) {
    p = temp;
    while(*p!='\n') p++;
    *p='\0';
    add(temp);
    c++;
  }
  fclose(fd);
  if(c>0) {
    filename = strdup(file);
    length = c;
    loaded = true;
  }
  return(loaded);
}

char *Playlist::song(int pos) {
  
  if(!loaded)
    return(NULL);
  
  Entry *ptr;
  int c;
  
  ptr = first;
  for(c=0;c<pos;c++) {
    if(ptr->next == NULL)
      return(NULL);
    ptr = ptr->next;
  }
  return(ptr->name);
}

void Playlist::select(int pos) {
  if(loaded) {
    Entry *ptr = first;
    int c;
   
    for(c=0;c<pos;c++) {
      if(ptr->next == NULL)
	break;
      ptr = ptr->next;
    }
    selected = ptr;
  }
}
