
/*
 * SEE COPYRIGHT NOTE IN THE FILE main.c 
 * Version 1.9.2
 */

/*****************************  DEFINES  *************************************/

#define CACHE_FILE "index.db"
#define WIN_CACHE_FILE "fat.db"
#define DEST_DIR "cached"		/* Goes under $HOME */
#define SUMMARY_FILE "index.html"	/* Under DEST_DIR */
#define DEFAULT_HTML "index.html"	/* Under site's directory tree */

#define perror_exit(str) {perror ("\n" str); unlink (lock_file); exit (EXIT_FAILURE);}

#define VERSION "1.9.2"

/*****************************  TYPEDEFS  ************************************/

typedef unsigned char bool;	/* Boolean True (1) or False (0) */

typedef struct node_of_btree
  {
    char *or_url;
    char *url;
    char *url_w_index;
    char *r_url;		/* Link to url or url_w_index */
    int type;
    char *file_name;
    char *title;
    size_t dup;
    time_t mod_time;
    struct node_of_btree *sx;
    struct node_of_btree *dx;
  }
NODE;

typedef struct cmd_options
  {
    unsigned int var;		/* Bit-mapped */
    int view_window;
    char *cache_dir, *dest_dir, *summary_file, *str_tbc;
  }
T_OPT;


/************************  FUNCTION DECLARATIONS  ****************************/

void *gt_malloc (size_t size);
void *gt_realloc (void *aap, size_t size);
NODE *get_data (NODE * start, time_t cut_time, char *sub_str);
NODE *add_url (NODE * node, char *or_url, char *url,
	       int type, char *file_name, time_t mtime);
NODE *find_url (NODE * node, char *url);

bool check_html_url (char *str, bool only_test);
bool copy_file (char *url, char *file);
bool make_link (char *url, char *file);
bool url_is_valid (char *str);
bool process_reference (char *ref, char *base, char *mod_base,
			char *file_name, FILE * out, int operation);
char *dirs_and_name (char *url);
char *cut_path (char *path, char *base);
char *check_path (char *cleaned, char *base, char *entry);
char *standardize (char *str);
char *relative_position (char *url, char *base, char *ref);
char *gt_strshift (char *name, int pos);
void process_html_file (NODE * node);
void process_arg (char *str, char **store, bool need_abs_path);
void sig_handler (int sig_number);
void help ();
void check_file_stream (FILE *f, char *path);
void print_error (char option, char *prg_name, int what_error);
void visit_tree (NODE * node, int operation);
void put_in_summary_files (NODE * data, bool close_all);
FILE *start_summary_files (int what, long *nd);

/*****************************  OTHERS  **************************************/

enum errors
  {
    illegal = 1, need_arg, already_supplied
  };

enum opt_bits			/* For T_OPT */
  {
    SILENT = 1, MISSING_IMAGES = 2, REPORT_TIME = 4,
    NO_LINKS = 8, WIN_CACHE = 16
  };

enum type_bits			/* For NODE.type */
  {
    IS_HTML = 1, NEED_INDEX = 2, PR_MAIN = 4,
    PR_REL = 8, SHOW = 16, PROCESSED = 32, 
    IGNORE_LOCK = 64, LINK_FOR_IMAGES = 128
  };

enum what_index
  {
    DOM, FULL, CONST
  };
