/* $Id: audioIO_SunOS.c,v 1.2 1997/11/15 23:50:16 okke Exp $ */

/* this file is a part of amp software, (C) tomislav uzelac 1996,1997

	Origional code by: tomislav uzelac
	Modified by:
	* Andrew Richards - moved code from audio.c
	* Okke Timm - Substituted AUDIO_GETINFO ioctl with AUDIO_INITINFO()
 */

#include "amp.h"
#include <sys/types.h>
#include <sys/stropts.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/audioio.h>
#include <errno.h>
#include "audioIO.h"


/* declare these static to effectively isolate the audio device */

static audio_fd;
static audio_info_t auinfo;

/* audioOpen() */
/* should open the audio device and perform any special initialization */
/* returns the file descriptior of the audio device										 */


void
audioOpen(int frequency, int stereo, int volume)
{
	int res, retval;

	if ((audio_fd = open("/dev/audio",O_RDWR))==-1)
	        die(" unable to open the audio device\n");
	DB(audio, msg("Audio device opened on %d\n",audio_fd) );

	/* On some Sun systems the AUDIO_GETINFO ioctl does not work
	   properly. Therefore it's better to generate an non-changing
	   audio_info_t with AUDIO_INITINFO().

	if (ioctl(audio_fd,AUDIO_GETINFO,&auinfo)<0)
	        die("Unable to get audio info\n");
	if (auinfo.play.active)
	        die("Device is busy.\n");
	*/
	
        AUDIO_INITINFO(&auinfo);
	auinfo.play.precision=16;
	auinfo.play.encoding=AUDIO_ENCODING_LINEAR;
	auinfo.play.channels=(stereo ? 2 : 1);
	DB(audio, msg("setting sample rate to %d Hz", frequency) );
	auinfo.play.sample_rate=frequency;

#if 0
	msg("Audio settings:\n");
	msg("Avail. Ports: %i Open: %i\n", auinfo.play.avail_ports, auinfo.play.open);
	msg("Channels: %i Sample rate: %i\n", auinfo.play.channels, auinfo.play.sample_rate);
	msg("Port: %i Gain: %i Buffer size: %x\n", auinfo.play.port, auinfo.play.gain, auinfo.play.buffer_size);
	msg("Samples: %i EOF: %i Pause: %i\n", auinfo.play.samples, auinfo.play.eof, auinfo.play.pause);
	msg("Error: %i, Waiting: %i Balance: %i\n", auinfo.play.error, auinfo.play.waiting, auinfo.play.balance);
	msg("Minordev: %i\n", auinfo.play.minordev);
#endif
	retval = ioctl(audio_fd,AUDIO_SETINFO,&auinfo);
	if (retval == EINVAL)
		die("Unable to set audio info: Invalid arguments\n");
	else if (retval == EBUSY)
                die("Unable to set audio info: Device busy\n");
	else if (retval)
                die("Unable to set audio info: %i.\n", retval);

	if (volume != -1)
		audioSetVolume(volume);
}


/* audioSetVolume */
/* sets the output volume 0-100 */

void
audioSetVolume(int volume)
{
	int res;

	DB(audio, msg("Setting volume to: %d\n",volume) );
	auinfo.play.gain=(volume*255)/100;
	if (ioctl(audio_fd,AUDIO_SETINFO,&auinfo)<0)
		warn("Unable to set sound volume\n");
}


/* audioFlush() */
/* should flush the audio device */

inline void
audioFlush()
{
	DB(audio, msg("audio: flush %d\n",audio_fd) );
}


/* audioClose() */
/* should close the audio device and perform any special shutdown			 */

void
audioClose()
{
	close(audio_fd);
}


/* audioWrite */
/* writes count bytes from buffer to the audio device */
/* returns the number of bytes actually written */

int inline
audioWrite(char *buffer, int count)
{
	return(write(audio_fd,buffer,count));
}

/* Let buffer.c have the audio descriptor so it can select on it. This means	*/
/* that the program is dependent on an file descriptor to work. Should really */
/* move the select's etc (with inlines of course) in here so that this is the */
/* ONLY file which has hardware dependent audio stuff in it										*/

int
getAudioFd()
{
	return(audio_fd);
}
