/******************************************************************************
 * $Id: npamp.c,v 1.5 1997/11/16 17:00:23 okke Exp $
 *
 * npamp.c - Integrate amp into Netscape via Plugin-API. 
 * Copyright (C) 1997 Okke Timm 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * Based on UnixShell.c which is Copyright (c) 1996 Netscape Communications 
 * and audio.c which is Copyright (c) 1996,1997 tomislav uzelac.
 *
 ******************************************************************************/

#include <stdio.h>
#include "amp.h"
#include "audio.h"
#include "formats.h"
#include "getbits.h"
#include "huffman.h"
#include "layer2.h"
#include "layer3.h"
#include "position.h"
#include "rtbuf.h"
#include "transform.h"
#include "controldata.h"
#include "guicontrol.h"
#include "npamp.h"

#include "npapi.h"

int instance_count;

int streamoffset;
int streamlen;
void *streampointer;

int fatal_error;

int global_frame_size;

/***********************************************************************
 *
 * Empty implementations of plugin API functions
 *
 * PLUGIN DEVELOPERS:
 *	You will need to implement these functions as required by your
 *	plugin.
 *
 ***********************************************************************/

char*
NPP_GetMIMEDescription(void)
{
  return(MIME_TYPE);
}

NPError
NPP_GetValue(void *future, NPPVariable variable, void *value)
{
  NPError err = NPERR_NO_ERROR;
  
  switch (variable) {
  case NPPVpluginNameString:
    *((char **)value) = "amp MPEG layer II/III audio player";
    break;
  case NPPVpluginDescriptionString:
    *((char **)value) = "This plugin plays MPEG layer II/III audio data. It is based on amp written by Tomislav Uzelac.";
    break;
  default:
    err = NPERR_GENERIC_ERROR;
  }

  return err;
}

NPError
NPP_Initialize(void)
{
  instance_count = 0;
  fatal_error = 0;

  initialise_decoder();	/* initialise decoder */

  A_DUMP_BINARY=FALSE;
  A_AUDIO_PLAY=TRUE;
  A_WRITE_TO_FILE=FALSE;
  A_FORMAT_WAVE=FALSE;
  A_SHOW_TIME=FALSE;
  A_MSG_STDOUT=FALSE;

  /* debugFlags.conf  = TRUE; */
  /* debugFlags.audio = TRUE; */
  /* debugFlags.npamp = TRUE; */

  npamp_config(); /* read and parse the .npamp config file */

  return NPERR_NO_ERROR;
}


jref
NPP_GetJavaClass()
{
  return NULL;
}

void
NPP_Shutdown(void)
{
}


NPError 
NPP_New(NPMIMEType pluginType,
	NPP instance,
	uint16 mode,
	int16 argc,
	char* argn[],
	char* argv[],
	NPSavedData* saved)
{
  PluginInstance* This;
  
  if (instance == NULL) {
    die("Netscape delivired an invalid instance, bailing out.\n");
    return NPERR_INVALID_INSTANCE_ERROR;
  }
  
  if (instance_count >= 1) {
    die("Only one instance, please.\n"); 
    return NPERR_GENERIC_ERROR;
  }

  instance_count++;

  instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
  
  This = (PluginInstance*) instance->pdata;

  if (This != NULL) {
    displayDisclaimer();
    return NPERR_NO_ERROR;
  } else {
    die("Netscape has just run out of Memory.\nPlease be seated and stay calm.\n");
    return NPERR_OUT_OF_MEMORY_ERROR;
  }
}


NPError 
NPP_Destroy(NPP instance, NPSavedData** save)
{
  PluginInstance* This;
  
  if (instance == NULL) {
    die("Netscape delivired an invalid instance, bailing out.\n");
    return NPERR_INVALID_INSTANCE_ERROR;
  }
  
  This = (PluginInstance*) instance->pdata;
  
  /* PLUGIN DEVELOPERS:
   *	If desired, call NP_MemAlloc to create a
   *	NPSavedDate structure containing any state information
   *	that you want restored if this plugin instance is later
   *	recreated.
   */
  
  if (This != NULL) {
    NPN_MemFree(instance->pdata);
    instance->pdata = NULL;
  }
  
  instance_count--;

  DB(npamp, msg("Netscape killed me. C U soon.\n"));
  return NPERR_NO_ERROR;
}



NPError 
NPP_SetWindow(NPP instance, NPWindow* window)
{
  PluginInstance* This;
  
  if (instance == NULL) {
    die("Netscape delivired an invalid instance, bailing out.\n");
    return NPERR_INVALID_INSTANCE_ERROR;
  }
  
  if (window == NULL)
    return NPERR_NO_ERROR;
  
  This = (PluginInstance*) instance->pdata;
  
  /*
   * PLUGIN DEVELOPERS:
   *	Before setting window to point to the
   *	new window, you may wish to compare the new window
   *	info to the previous window (if any) to note window
   *	size changes, etc.
   */
  
  return NPERR_NO_ERROR;
}


NPError 
NPP_NewStream(NPP instance,
	      NPMIMEType type,
	      NPStream *stream, 
	      NPBool seekable,
	      uint16 *stype)
{
  NPByteRange range;
  PluginInstance* ThisPlugin;
  StreamInstance* ThisStream;

  if (instance == NULL) {
    die("Netscape delivired an invalid instance, bailing out.\n");
    return NPERR_INVALID_INSTANCE_ERROR;
  }

  ThisPlugin = (PluginInstance*) instance->pdata;

  stream->pdata = NPN_MemAlloc(sizeof(StreamInstance));
  ThisStream = (StreamInstance*) stream->pdata;
  
  ThisStream->block_count=0;
  ThisStream->frame_count=0;
  ThisStream->frame_buffer_offset=0;

  initialise_globals();

  fatal_error = 0;

  msg(">>> Now playing URL: %s <<<\n\n", stream->url);


  DB(npamp, msg("NewStream: Seekable %i Length %x MIME Type: %s\n", seekable, stream->end, type));

  return NPERR_NO_ERROR;
}


/* PLUGIN DEVELOPERS:
 *	These next 2 functions are directly relevant in a plug-in which
 *	handles the data in a streaming manner. If you want zero bytes
 *	because no buffer space is YET available, return 0. As long as
 *	the stream has not been written to the plugin, Navigator will
 *	continue trying to send bytes.  If the plugin doesn't want them,
 *	just return some large number from NPP_WriteReady(), and
 *	ignore them in NPP_Write().  For a NP_ASFILE stream, they are
 *	still called but can safely be ignored using this strategy.
 */

/* 64k stream buffer */
#define STREAMBUFSIZE 0x00007FFF

int32 
NPP_WriteReady(NPP instance, NPStream *stream)
{
  PluginInstance* This;
  if (instance != NULL)
    This = (PluginInstance*) instance->pdata;

  DB(npamp, msg("Write ready size: %x\n", STREAMBUFSIZE));

  return STREAMBUFSIZE;
}


int32 
NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer)
{

  int g, bytes_read;

  PluginInstance* ThisPlugin;
  StreamInstance* ThisStream;

  if (instance != NULL)
    ThisPlugin = (PluginInstance*) instance->pdata;
  
  ThisStream = (StreamInstance*) stream->pdata;

  if (fatal_error) {
    return -1;
  }

  memcpy(ThisStream->frame_buffer + ThisStream->frame_buffer_offset,
		 buffer, len);

  streamoffset = 0;
  streampointer = ThisStream->frame_buffer;
  streamlen = ThisStream->frame_buffer_offset + len;

  DB(npamp, msg("Block count: %i Stream length: %x\n", ThisStream->block_count, streamlen));

  if (ThisStream->block_count == 0) {
    if ((g=gethdr(&ThisStream->header))!=0) {
      report_header_error(g);
      return -1;
    }
    
    if (ThisStream->header.protection_bit==0) getcrc();

    if (setup_audio(&ThisStream->header)!=0) {
      warn("Cannot set up audio. Exiting\n");
      return -1;
    }

    show_header(&ThisStream->header);
    
    if (ThisStream->header.layer==1) {
      if (layer3_frame(&ThisStream->header, ThisStream->frame_count)) {
		warn(" error. blip.\n");
		return -1;
      }
    } else if (ThisStream->header.layer==2)
      if (layer2_frame(&ThisStream->header, ThisStream->frame_count)) {
		warn(" error. blip.\n");
		return -1;
      }

    ThisStream->frame_count++;
  } /* ThisStream->block_count == 0 */

  /*
   * decoder loop **********************************
   */

  while ((streamlen - streamoffset) >= global_frame_size) {
    if ((g=gethdr(&ThisStream->header)) != 0) {
      report_header_error(g);
	  NPN_DestroyStream(instance, stream, NPRES_NETWORK_ERR);
	  return -1;
    }
    
    if (ThisStream->header.protection_bit==0) getcrc();
    
    DB(npamp, msg("Frame buffer size: %i\n", streamlen - streamoffset));
    DB(npamp, msg("Frame count: %i\n", ThisStream->frame_count));

    statusDisplay(&ThisStream->header, ThisStream->frame_count);
    
    if (ThisStream->header.layer == 1) {
      if (layer3_frame(&ThisStream->header, ThisStream->frame_count)) {
		warn(" error. blip.\n");
		return -1;
      }
    } else if (ThisStream->header.layer == 2)
      if (layer2_frame(&ThisStream->header, ThisStream->frame_count)) {
		warn(" error. blip.\n");
		return -1;
      }
    ThisStream->frame_count++;
  }

  ThisStream->block_count++;

  DB(npamp, msg("Block end. Stream offset: %x\n", streamoffset));

  bytes_read = streamoffset - ThisStream->frame_buffer_offset; 
  if ( bytes_read < len) {
	memcpy(ThisStream->frame_buffer, 
		   (void *) ((int) buffer + bytes_read),
		   len - bytes_read);
	ThisStream->frame_buffer_offset = len - bytes_read;
  }

  return streamoffset;			/* The number of bytes accepted */
}


NPError 
NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
  PluginInstance* This;

  if (instance == NULL)
    return NPERR_INVALID_INSTANCE_ERROR;
  This = (PluginInstance*) instance->pdata;

  NPN_MemFree(stream->pdata);
  stream->pdata = NULL;
  
  DB(npamp, msg("\nThank you for using amp!\n"));

  close_audio();

  return NPERR_NO_ERROR;
}


void 
NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
  PluginInstance* This;
  if (instance != NULL)
    This = (PluginInstance*) instance->pdata;
}


void 
NPP_Print(NPP instance, NPPrint* printInfo)
{
  if(printInfo == NULL)
    return;
  
  if (instance != NULL) {
    PluginInstance* This = (PluginInstance*) instance->pdata;
    
    if (printInfo->mode == NP_FULL) {
      /*
       * PLUGIN DEVELOPERS:
       *	If your plugin would like to take over
       *	printing completely when it is in full-screen mode,
       *	set printInfo->pluginPrinted to TRUE and print your
       *	plugin as you see fit.  If your plugin wants Netscape
       *	to handle printing in this case, set
       *	printInfo->pluginPrinted to FALSE (the default) and
       *	do nothing.  If you do want to handle printing
       *	yourself, printOne is true if the print button
       *	(as opposed to the print menu) was clicked.
       *	On the Macintosh, platformPrint is a THPrint; on
       *	Windows, platformPrint is a structure
       *	(defined in npapi.h) containing the printer name, port,
       *	etc.
       */

      void* platformPrint =
	printInfo->print.fullPrint.platformPrint;
      NPBool printOne =
	printInfo->print.fullPrint.printOne;
			
      /* Do the default*/
      printInfo->print.fullPrint.pluginPrinted = FALSE;
    }
    else {			/* If not fullscreen, we must be embedded */
      /*
       * PLUGIN DEVELOPERS:
       *	If your plugin is embedded, or is full-screen
       *	but you returned false in pluginPrinted above, NPP_Print
       *	will be called with mode == NP_EMBED.  The NPWindow
       *	in the printInfo gives the location and dimensions of
       *	the embedded plugin on the printed page.  On the
       *	Macintosh, platformPrint is the printer port; on
       *	Windows, platformPrint is the handle to the printing
       *	device context.
       */

      NPWindow* printWindow =
	&(printInfo->print.embedPrint.window);
      void* platformPrint =
	printInfo->print.embedPrint.platformPrint;
    }
  }
}
