/******************************************************************************
 * $Id: npampconf.c,v 1.2 1997/11/16 17:00:24 okke Exp $
 * 
 * npampconf.c - read and parse .npamp config files
 * Copyright (C) 1997 Okke Timm 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "amp.h"
#include "audio.h"
#include "npampconf.h"

FILE *conf_file;

int 
npamp_config()
{

  char *home;
  char conf_path[255];
  char line[255];

  /* Defaults */
  AUDIO_BUFFER_SIZE=128*1024;
  A_QUIET=FALSE;
  A_SHOW_CNT=FALSE;
  A_SET_VOLUME=-1;
  A_SHOW_TIME=FALSE;
  A_MSG_STDOUT=FALSE;
  A_DOWNMIX=FALSE;

  /* Generate the $HOME/.npamp path in conf_path */ 
  home = getenv("HOME");
  if (home == NULL)
    die("Couldn't get $HOME\n");
  strcpy(conf_path, home);
  strcat(conf_path, "/.npamp");

  conf_file = fopen(conf_path, "r");
  if (conf_file == NULL) {
    warn("Couldn't open %s, using defaults.\n", conf_path);
    return 0;
  }

  yyparse();
  return 0;
}

