/*************************************************************************/
/*                                                                       */
/*        chopper.ch   : Eric Lavillonniere 2005                         */
/*        company       : Mitsubishi Electric ITE                        */
/*                                                                       */
/*************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public License
   along with this program; see the file COPYING. If not, write to 
   the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   */
language syndex;

#include "token.h"
#include <sys/types.h>
#include "syndex.h"
#include <fcntl.h>
#include "decsyndex.h"

void    ChopTree (PTREE) ;
void    decomp (PTREE) ;

int main ( int argc, char **argv )
{
    PTREE   tree ;
    char    name [50];
    char    *ptName ;
    
    MetaInit();
    syndex().AsLanguage();
    if ( argc < 2 ) {
        sprintf(name, "Bad name for your source file \n");
        _write(2, name, strlen(name));
        exit(0);
    } else {
        ptName = *(argv + 1);
    }
    tree = syndex().ReadFile(ptName);
    AddRef(tree);
    ChopTree(tree);
    MetaEnd();
    if ( !firstError ) 
        return 1 ;
    else 
        return 0 ;
}

/*************************************************************************/
/*   ChopTree : chop the tree : here call decomp                         */
/*************************************************************************/
void ChopTree ( PTREE tree )
{
    DecompSyndex    decompSyndex ;
    
    decompSyndex.startComment = decompSyndex.middleComment = decompSyndex.endComment = decompSyndex.plusComment = "";
    DecompSyndex::ptDecomp = &decompSyndex ;
    decomp_syndex(tree);
    NewLine();
}


