#include "erlsock.h"
#include "quickconnect.h"
#include "asn.h"
#include "xcode.h"
#include "gentic_read.h"
#include "gentic_write.h"
#include "../evaluator.h"
#include "../operatormedia.h"

static QConnection          connection ;
EString                     genticName("gentic-client-");
EString                     genticChannel("gentic-channel-");
EString                     commonChannel("Gentic");
static int                  echoPort = 2000 ;
static std::vector<int>     proc ;
static std::vector<int>     trail ;
SchedulerEvaluate           *pSched ;
static EString              randomVal ;

// ComputeResponse : compute response from received data
// parameters :
//              data : the received data
EString ComputeResponse ( EString &data, bool flush = true )
{
    
    // decode data pduRoot_closeIndQ
    VString vdata ;
    IE      ie ;
    
    DecodePacketGentic(ie, data.c_str(), data.length());
    
    bool    isOk = true ;
    int     type ;
    
    WITH_JUMP(jumpEnv, GENTIC::pdu_read_rootQ(&ie, jumpEnv, type), (isOk = false));
    if ( isOk ) {
        switch ( type ) {
            case loadRqst_chosen : 
                {
                    VString fileName ;
                    VString fileContent ;
                    GENTIC::pdu_read_loadRqstQ(&ie, 0, fileName, fileContent);
                    if ( fileContent == "" ) {
                        
                        // set scheduler for this fileName
                        SetExternScheduler(fileName);
                    } else {
                        
                        // compute fileName 
                        EString fileName = EString("gentic-") << randomVal ;
                        
                        // store data in file name
                        int     outFile = _open(fileName.c_str(), O_CREAT | O_RDWR | O_TRUNC, 0666);
                        if ( outFile <= 0 ) 
                            MetaExit(3, "Cannot Store Data\n");
                        _write(outFile, fileContent.c_str(), fileContent.length());
                        _close(outFile);
                        
                        // read it
                        SetExternScheduler(fileName);
                    }
                    
                    // reencode data
                    IE  ie ;
                    IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
                    VString currChannel = genticChannel ;
                    GENTIC::pdu_write_loadRspsQ(&ie, 0, currChannel);
                    unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
                    if ( !sizePacket ) 
                        MetaExit(3, "Invalid encoding \n");
                    else {
                        data = VString(encodeBuffer2, sizePacket);
                        connection.SendString(commonChannel, data);
                    }
                }
                break ;
            case computeRqst_chosen : 
                {
                    unsigned int    id ;
                    unsigned int    evaluatorId ;
                    GENTIC::pdu_read_computeRqstQ(&ie, 0, evaluatorId, id, proc, trail);
                    (*pSched)(&proc [0], &trail [0]);
                    
                    // reencode data
                    IE  ie ;
                    IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
                    GENTIC::pdu_write_computeRspsQ(&ie, 0, evaluatorId, id, pSched->Latency(), pSched->Cadency());
                    unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
                    if ( !sizePacket ) 
                        MetaExit(3, "Invalid encoding \n");
                    else {
                        data = VString(encodeBuffer2, sizePacket);
                        connection.SendString(genticChannel, data, flush);
                    }
                }
                break ;
            default : 
                {
                    return "";
                }
        }
    }
    return "";
}

int main ( int argc, char **argv )
{
    PTREE           message ;
    isockinet       isin (sockbuf::sock_stream) ;
    VString         name ;
    EString         destAddr("127.0.0.1");
    unsigned int    offset = 0 ;
    
    pSched = new SchedulerEvaluate(&pScheduler [0]);
    nbThread = 1 ;
    MetaInit("gentic");
    
    // SwitchLang("asn");
    while ( true ) {
        if ( argc - offset < 2 ) 
            break ;
        name = *(argv + 1 + offset);
        
        // look if parameters
        if ( VString("-ip") == name ) {
            destAddr = *(argv + 2 + offset);
            offset += 2 ;
        } else if ( VString("-port") == name ) {
            echoPort = atoi(*(argv + 2 + offset));
            offset += 2 ;
        } else 
            MetaExit(1, "Invalid Parameters : [-ip ip | -port port ] \n");
    }
    protectBoard.FreeRessource(1);
    srandom(time(0));
    
    char    hostname [512];
    
    if ( gethostname((char *)hostname, 512) >= 0 ) {
        genticName = VString(hostname) << "-" << genticName ;
        genticChannel = VString(hostname) << "-" << genticChannel ;
    }
    randomVal = Compactlltoa(random());
    genticName << randomVal ;
    genticChannel << randomVal ;
    
    // configure connection
    {
        connection.Open(genticName.c_str(), "127.0.0.1", (char *)(destAddr.c_str()) /* for distant */ , echoPort, -1, true);
        connection.OpenChannel(commonChannel);
        connection.OpenChannel(genticChannel);
        
        // set time for reading wait
        {
            struct timeval tval ;
            tval.tv_sec = 5 ;
            tval.tv_usec = 0 ;
            connection.TimeVal(tval);
        }
    }
    
    VString data ;
    PTREE   dataTree ;
    SOCKET  socket = 0 ;
    
    // say that we are here
    {
        IE  ie ;
        IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
        VString currChannel = genticChannel ;
        GENTIC::pdu_write_newIndQ(&ie, 0, currChannel);
        unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
        if ( !sizePacket ) 
            MetaExit(3, "Invalid encoding \n");
        else {
            VString data = VString(encodeBuffer2, sizePacket);
            connection.SendString(commonChannel, data);
        }
    }
    
    // echo
    while ( true ) {
        message = connection.ReceiveContent(true);
        data = "";
        if ( message != PTREE(0) ) {
            
            // first case is valid only if there is one connection      
            {
                data = GetStringFromTree(message);
                if ( data.length() > 0 ) {
                    ComputeResponse(data, connection.Empty());
                }
            }
        }
    }
    return 0 ;
}
