#include "xcode.h"
#include "erlsock.h"
#include "iefunct_gen.h"

char    encodeBuffer [SIZE_BUFFER];
char    encodeBuffer2 [SIZE_BUFFER];
char    encodeBuffer3 [SIZE_BUFFER];

unsigned int EncodePacketGentic ( IE &ie, char *buffer, unsigned int length )
{
    
    /* init coding context */
    CodingContext   rootCodingContext ;
    
    memset(&rootCodingContext, 0, sizeof(CodingContext));
    rootCodingContext.strRes = buffer ;
    rootCodingContext.lengthStrRes = length ;
    rootCodingContext.fixedAlloc = 1 ;
    rootCodingContext.nonAligned = ALIGNED_ENCODING ;
    
    /* encode data */
    SGenEncode(&ie, &rootCodingContext, &GENTIC::GENTIC_langReferencer, GENTIC::Root_T);
    
    /* encode length */
    return rootCodingContext.strResOffset ;
}

bool DecodePacketGentic ( IE &ie, const char *buffer, int length, int *pReadLength )
{
    CodingContext   rootCodingContext ;
    
    /* init coding context */
    memset(&rootCodingContext, 0, sizeof(CodingContext));
    rootCodingContext.strRes = (char *)buffer ;
    rootCodingContext.lengthStrRes = length + 1 ;
    rootCodingContext.fixedAlloc = 0 ;
    rootCodingContext.nonAligned = ALIGNED_ENCODING ;
    rootCodingContext.strResOffset = 0 ;
    
    // decode data
    int retCode
        = SGenDecodeFixed(&ie, &rootCodingContext, &GENTIC::GENTIC_langReferencer, GENTIC::Root_T, encodeBuffer3
            , SIZE_BUFFER);
    
    // set length read
    if ( pReadLength ) 
        *pReadLength = rootCodingContext.strResOffset ;
    
    // return success
    return !retCode ;
}
