/*************************************************************************/
/*                                                                       */
/*        computeunit.ch   : Eric Lavillonniere 2005                     */
/*        company          : Mitsubishi Electric ITE                     */
/*                                                                       */
/*************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public License
   along with this program; see the file COPYING. If not, write to 
   the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   */
language syndex;

#include "computeunit.h"
#include "syndex.h"

// SearchConnected : search the connected to a given port
void ComputeUnit::SearchConnected ( PTREE &name, std::vector<ComputeUnit *> &connected, ComputeUnit *transUnit, bool first )
{
    PTREE   reference = Reference();
    PTREE   dependences ;
    PTREE   condition ;
    PTREE   references ;
    
    if ( reference == <CONDITIONS,condition,<REFERENCES,references>,<DEPENDENCES,dependences>> ) {
        PTREE   aDependence ;
        
        // maybe name is the condition box connect all the subbox
        if ( VString(Value(name)) == "" || VString(Value(name)) == Value(condition) || name == <PRECEDENCE_LINK> ) {
            PTREE   reference ;
            PTREE   name1 = name ;
            if ( name1 != <CONS> && VString(Value(name1)) == Value(condition) ) {
                name1 = <CONS,(),CopyTree(condition)>;
            }
            while ( reference = nextl(references) ) {
                Unit(VString(Value(reference [3]))).SearchConnected(name1, connected, transUnit, first);
            }
            return ;
        }
        
        // not the condition box
        while ( aDependence = nextl(dependences) ) {
            PTREE   start ;
            PTREE   end ;
            PTREE   listDepend ;
            aDependence == <DEPENDENCE,<>,start,end>;
            
            // if named port is connected to a box, search in this box for the real box connection
            start == <END_DEPEND,start>;
            end == <END_DEPEND,end>;
            PTREE   box ;
            PTREE   port ;
            
            // !first => !output => entry or fist part of dependence
            if ( !first && ListLength(start) == 1 && VString(Value(name)) == VString(Value(start)) ) {
                if ( ListLength(end) != 1 ) {
                    box = nextl(end);
                    port = end ;
                } else {
                    EString message("To be seen later \n");
                    DisplayError(message);
                }
            } else if ( first && ListLength(end) == 1 && VString(Value(name)) == VString(Value(end)) ) {
                box = nextl(start);
                port = start ;
            }
            
            // this was connected to something so treat it 
            if ( box ) {
                Unit(VString(Value(box))).SearchConnected(port, connected, transUnit, first);
            }
        }
    } else {
        PTREE   algoDescription, listAlgo ;
        PTREE   elem, list ;
        PTREE   port ;
        PTREE   portName ;
        
        // expand all the elements 
        PTREE   algo = Reference();
        
        // if really an algo expand it
        if ( algo == <ALGORITHM,<>,<>,algoDescription = <ALGO_ELEM,listAlgo>>
                || algo == <SENSOR,<>,<>,algoDescription = <ALGO_ELEM,listAlgo>>
                || algo == <ACTUATOR,<>,<>,algoDescription = <ALGO_ELEM,listAlgo>>
                || algo == <CONSTANT,<>,<>,algoDescription = <ALGO_ELEM,listAlgo>>
                || algo == <MEMORY,<>,<>,algoDescription = <ALGO_ELEM,listAlgo>> ) {
            
            // if no port connect all the box
            if ( name == <CONS> && !first || name == <PRECEDENCE_LINK> ) {
                connected.push_back(this);
                if ( name != <PRECEDENCE_LINK> && transUnit ) {
                    pvInEndConnectionsRef [VString(Value(name [2]))] = transUnit ;
                }
                
                // transUnit->Reference(port);
                return ;
            }
            
            // treat all the ports
            while ( port = nextl(listAlgo) ) {
                
                // first is on for the generator of data on the link
                switch ( port ) {
                    case <IN,<,<>,<>,portName>> : 
                        {
                            if ( !first && VString(Value(portName)) == VString(Value(name)) ) {
                                connected.push_back(this);
                                if ( transUnit ) {
                                    pvInEndConnectionsRef [VString(Value(portName))] = transUnit ;
                                    transUnit->Reference(port);
                                }
                                return ;
                            }
                        }
                        break ;
                    case <OUT,<,<>,<>,portName>> : 
                        {
                            if ( first && VString(Value(portName)) == VString(Value(name)) ) {
                                connected.push_back(this);
                                if ( transUnit ) {
                                    pvOutEndConnectionsRef [VString(Value(portName))] = transUnit ;
                                    transUnit->Reference(port);
                                }
                                return ;
                            }
                        }
                        break ;
                    default : break ;
                }
            }
        }
    }
}

// Display : display an unit 
void ComputeUnit::Display ()
{
    EString message ;
    
    message << Name() << "\n";
    message << " In : ";
    
    // if one predecesor has not been visited yet cannot insert
    std::map<EString, ComputeUnit *, LessString> ::iterator iterIn ;
    
    for ( iterIn = InEndConnectionsRef().begin() ; iterIn != InEndConnectionsRef().end() ; iterIn++ ) {
        TransUnit       *pTransUnit2 = (TransUnit *)((*iterIn).second);
        
        // look if predecessors computed
        unsigned int    indexComm2 ;
        for ( indexComm2 = 0 ; indexComm2 < pTransUnit2->ConnectedOut().size() ; indexComm2++ ) {
            ComputeUnit *pComputeUnit2 = pTransUnit2->ConnectedOut()[indexComm2];
            message << pComputeUnit2->Name() << " ";
        }
    }
    message << "\n";
    message << " Out : ";
    
    // if one predecesor has not been visited yet cannot insert
    std::map<EString, ComputeUnit *, LessString> ::iterator iterOut ;
    
    for ( iterOut = OutEndConnectionsRef().begin() ; iterOut != OutEndConnectionsRef().end() ; iterOut++ ) {
        TransUnit       *pTransUnit2 = (TransUnit *)((*iterOut).second);
        
        // look if predecessors computed
        unsigned int    indexComm2 ;
        for ( indexComm2 = 0 ; indexComm2 < pTransUnit2->ConnectedIn().size() ; indexComm2++ ) {
            ComputeUnit *pComputeUnit2 = pTransUnit2->ConnectedIn()[indexComm2];
            message << pComputeUnit2->Name() << " ";
        }
    }
    message << "\n";
    _write(2, message.c_str(), message.length());
}


