/*************************************************************************/
/*                                                                       */
/*        decompsyndex.ch   : Eric Lavillonniere 2005                    */
/*        company           : Mitsubishi Electric ITE                    */
/*                                                                       */
/*************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public License
   along with this program; see the file COPYING. If not, write to 
   the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   */
language syndex;

#include <sys/types.h>
#include <fcntl.h>
#include "token.h"
#include "syndex.h"
#include "decsyndex.h"

DecompSyndex    *DecompSyndex::ptDecomp = 0 ;

/*************************************************************************/
/*  decomp : display your program  : here dump tree                      */
/*************************************************************************/
PTREE DecompSyndex::IntDecomp ( const PTREE &tree, int )
{
    PTREE   val1, val2, val3, val4, pos, list ;
    
    //   DumpTree(tree);
    switch ( tree ) {
        case <IDENT> : 
            PrintString(Value(tree));
            break ;
        case <VERSION,val1> : 
            {
                "syndex_version" <S> ":" <S>
                if ( val1 ) {
                    "\"" PrintString(Value(tree)) "\"";
                }
            }
            break ;
        case <DESCRIPTION,val1> : 
            {
                "application" "description" <S> ":" <S>
                if ( val1 ) {
                    "\"" PrintString(Value(tree)) "\"";
                }
            }
            break ;
        case <SYNDEX_TOP,val1,val2,val3> : 
            {
                @val1 <NL>
                @val2 <NL>
                <NL,2>
                DecompList(val3, (char *)0, (char *)0, 2);
            }
            break ;
        case <NEG,val1> : 
            {
                "-" @val1
            }
            break ;
        case <NUMB> : 
            {
                PrintString(Value(tree));
            }
            break ;
        case <TIME,val1> : 
            {
                @val1 ".";
            }
            break ;
        case <MAIN_ALGORITHM,val1> : 
            {
                "main algorithm" @val1 ";" <NL>
            }
            break ;
        case <MAIN_ARCHITECTURE,val1> : 
            {
                "main architecture" @val1 ";" <NL>
            }
            break ;
        case <POS1,val1,val2> : 
            {
                if ( val1 ) {
                    @val1 "," @val2
                } else 
                    <S> 
                ":" <NL>
            }
            break ;
        case <POS2,val1,val2> : 
            {
                if ( val1 ) {
                    <S> "@" @val1 "," @val2
                }
                ";" <NL>
            }
            break ;
        case <ALGORITHM,val1,pos,val3> : 
            {
                "def algorithm" @val1 @pos <NL>
                @val3
            }
            break ;
        case <SENSOR,val1,pos,val3> : 
            {
                "def sensor" @val1 @pos <NL>
                @val3
            }
            break ;
        case <ACTUATOR,val1,pos,val3> : 
            {
                "def actuator" @val1 @pos <NL>
                @val3
            }
            break ;
        case <CONSTANT,val1,pos,val3> : 
            {
                "def constant" @val1 @pos <NL>
                @val3
            }
            break ;
        case <MEMORY_PARAM,val1,val2> : 
            {
                <S> "[" @val1 ".." @val2 "]" <S>
            }
            break ;
        case <MEMORY,val1,pos,val3> : 
            {
                "def memory" @val1 @pos <NL>
                @val3
            }
            break ;
        case <INTERNAL,val1,val2> : 
            {
                "def internal " @val1 <S>
                if ( val2 ) {
                    "<" @val2 ">";
                }
                ":";
            }
            break ;
        case <ALGO_ELEM,val1> : 
            {
                DecompList(val1, (char *)0, (char *)0, 0);
            }
            break ;
        case <IN,val1,val2> : 
            {
                <S> "?" <S> @val1
                if ( val2 ) 
                    @val2 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <OUT,val1,val2> : 
            {
                <S> "!" <S> @val1
                if ( val2 ) 
                    @val2 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <IN_OUT,val1,val2> : 
            {
                <S> "?!" <S> @val1
                if ( val2 ) 
                    @val2 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <TRUE> : 
            "true";
            break ;
        case <REFERENCES,val1> : 
            {
                "references" ":" <NL>
                DecompList(val1, " ", (char *)0, 0);
            }
            break ;
        case <DEPENDENCES,val1> : 
            {
                "dependences" ":" <NL>
                DecompList(val1, " ", (char *)0, 0);
            }
            break ;
        case <PARAMETER,val1,val2> : 
            {
                "<";
                if ( val1 ) {
                    "{";
                    DecompList(val1, ",", (char *)0, 0);
                    "}";
                }
                if ( val2 ) {
                    ";" @val2
                }
                ">" <S>
            }
            break ;
        case <SYMBOLIC_PARAMETER,val1,val2> : 
            {
                "<";
                if ( val1 ) {
                    DecompList(val1, ";", (char *)0, 0);
                }
                ">" <S>
            }
            break ;
        case <REFERENCE,val1,val2,val3,val4> : 
            {
                <S> @val1
                if ( val2 ) 
                    @val2 
                @val3
                if ( val4 ) 
                    @val4 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <END_DEPEND,val1> : 
            {
                DecompList(val1, ".", (char *)0, 0);
            }
            break ;
        case <DEPENDENCE,val1,val2,val3> : 
            {
                <S> "strong_precedence_data" @val2 <S> "->" <S> @val3 ";" <NL>
            }
            break ;
        case <PRECEDENCE,val1,val2,val3> : 
            {
                <S> "precedence" @val2 <S> "->" <S> @val3 ";" <NL>
            }
            break ;
        case <TYPE,val1,val2,val3,val4> : 
            {
                @val1
                if ( val2 == <SIZE,val2> ) {
                    "[" @val2 "]" <S> @val3 @val4
                }
            }
            break ;
        case <CONDITION_SELECTOR,val1,val2> : 
            {
                @val1 <S> "=" <S> @val2
            }
            break ;
        case <CONDITIONS,val1,val2,val3> : 
            {
                "conditions" ":" <S> @val1 ";" <NL>
                if ( val2 ) 
                    @val2 
                if ( val3 ) 
                    @val3 
            }
            break ;
        case <OPERATOR,val1,pos,val3> : 
            {
                "def operator" @val1 @pos <NL>
                @val3
            }
            break ;
        case <MEDIA,val1,pos,val3> : 
            {
                "def media" @val1 @pos <NL>
                @val3
            }
            break ;
        case <ARCHITECTURE,val1,pos,val3> : 
            {
                "def architecture" @val1 @pos <NL>
                @val3
            }
            break ;
        case <OPERATOR_MEDIA_LIST,val1> : 
        case <ARCHITECTURE_LIST,val1> : 
            DecompList(val1, (char *)0, (char *)0, 0);
            break ;
        case <ARCH_OPERATOR_LIST,val1> : 
            "operators:" <NL>
            DecompList(val1, (char *)0, (char *)0, 0);
            break ;
        case <ARCH_MEDIA_LIST,val1> : 
            "medias:" <NL>
            DecompList(val1, (char *)0, (char *)0, 0);
            break ;
        case <ARCH_CONNECTION_LIST,val1> : 
            "connections:" <NL>
            DecompList(val1, (char *)0, (char *)0, 0);
            break ;
        case <CODE_PHASE,val1> : 
            {
                "code_phases:" <S> @val1 ";" <NL>
            }
            break ;
        case <LOOPSEQ> : 
            {
                "loopseq";
            }
            break ;
        case <GATE,val1,val2> : 
            {
                "gate" @val1 @val2 ";" <NL>
            }
            break ;
        case <CODE_TIME,val1,val2> : 
            {
                @val1
                if ( val2 ) {
                    <S> "=" <S> @val2
                }
                ";" <NL>
            }
            break ;
        case <MAIN_OPERATOR,val1,val2> : 
            {
                <S> "main operator" @val1
                if ( val2 ) 
                    @val2 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <OPERATOR_DEF,val1,val2,val3> : 
            {
                <S> @val1 @val2
                if ( val3 ) 
                    @val3 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <MEDIA_DEF,val1,val2,val3,val4> : 
            {
                <S> @val1 @val2 @val3
                if ( val4 ) 
                    @val4 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <CONNECTION_DEF,val1,val2,val3> : 
            {
                <S> @val1 @val2
                if ( val3 ) 
                    @val3 
                else {
                    ";" <NL>
                }
            }
            break ;
        case <NAME_AND_PARAM,val1,val2> : 
            {
                @val1 @val2
            }
            break ;
        case <VAL,val1> : 
            @val1
            break ;
        case <NONE> : break ;
        case <SOFT_ENTRY,val1,val2> : 
            {
                "[" "\\";
                PTREE   elem ;
                while ( elem = nextl(val1) ) {
                    "\\" @elem
                }
                "," @val2 "]";
            }
            break ;
        case <SOFT_COMPONENT,val1,<SOFT_ENTRIES,val2>> : 
            {
                "software_component" @val1 <S> ":" <NL>
                if ( val2 ) 
                    DecompList(val2, (char *)0, (char *)0, 1);
                <NL>
                ";";
            }
            break ;
        case <CONSTRAINTS,val1> : 
            DecompList(val1, (char *)0, (char *)0, 1);
            break ;
        case <CONSTRAINT,val1,val2> : 
            {
                "absolute constraint : " @val1 "on";
                DecompList(val2, (char *)0, (char *)0, 0);
                " ;";
            }
            break ;
        case <MEMORY_IDENT,val1,val2,val3> : 
            {
                @val1
                if ( val2 ) {
                    @val2
                }
                if ( val3 ) {
                    @val3
                }
            }
            break ;
        case <PROC,val1,val2> : 
            {
                @val1 "." @val2
            }
            break ;
        case <ADD,val1,val2> : 
            {
                @val1 "+" @val2
            }
            break ;
        case <SUB,val1,val2> : 
            {
                @val1 "-" @val2
            }
            break ;
        case <MUL,val1,val2> : 
            {
                @val1 "*" @val2
            }
            break ;
        case <DIV,val1,val2> : 
            {
                @val1 "/" @val2
            }
            break ;
        case <PAR,val2> : 
            {
                "(" @val2 ")";
            }
            break ;
        default : 
            {
                DumpTree(tree);
                <NL>
            }
            break ;
    }
    return PTREE(0);
}


