/*************************************************************************/
/*                                                                       */
/*        evaluator.h   : Eric Lavillonniere 2005                        */
/*        company       : Mitsubishi Electric ITE                        */
/*                                                                       */
/*************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public License
   along with this program; see the file COPYING. If not, write to 
   the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   */
#ifndef EVALUATOR_FILE
#   define EVALUATOR_FILE 
#   include "syndex.h"
#   include "scheduler.h"
#   include "individual.h"
#   include "optimgenetic.h"
#   include "semaphop.h"
#   include "ethread.h"
#   ifdef WITH_CONNECTION
#       include "quickconnect.h"
#       include "client/xcode.h"
#       include "client/gentic_write.h"
#       include "client/gentic_read.h"
#   endif
    class SchedulerEvaluate ;
    class Board ;
    double                      BoardEvaluator (bool, SchedulerEvaluate *pSched, Board *) ;
    std::vector<unsigned int>   GetRandomTrail (SchedulerEvaluate *) ;
    bool                        DirectDescent (SchedulerEvaluate *, int, int) ;
    void                        MutateTrail (SchedulerEvaluate *, int *) ;
    void                        AddWaitingBoards (Board *pBoard) ;
    static Semaphop             *pWaitingSemaphop = 0 ;
    static int                  nbThread = 0 ;
#   ifdef WITH_CONNECTION
        static EString      genticName("gentic-server");
        static EString      genticChannel("Gentic");
        static QConnection  eConnection ; // connection on evaluators
        static unsigned int currIndividual = 0 ;
#   endif
#   define CADENCY_FACTOR 8
#   define LATENCY_FACTOR 2
#   define MAX_THREAD 64
#   define LOAD_PER_CPU 200    
#   define TIME_INDIVIDUAL 60
    static Semaphop     protectBoard ;
    static bool         distributed = false ;
    static Semaphop     availableCpu ;
    static EString      currentFileName ;
    static unsigned int newPopulationSize = 0 ;
#   define INC_INDEX(index) ((index) =( (index) == LOAD_PER_CPU ?0:(index)+1))
    
    class ExternEvaluator {
        
        public :
        
            ExternEvaluator ()
                : on(false),  nbTreated(0),  indexRead(0),  indexWrite(0),  lastResult(0),  toStore(10),  startStore(time(0)),  throughPut(0)
            {}
            
            EString         channel ;   // channel for this evaluator
            unsigned int    nbTreated ; // number waiting to be treated
            bool            on ;        // is it on
            int             treated [LOAD_PER_CPU + 5];
            unsigned int    indexRead ;
            unsigned int    indexWrite ;
            time_t          lastResult ;
            time_t          startStore ;
            unsigned int    nbStore ;
            unsigned int    toStore ;
            double          notCorrected ;
            double          throughPut ;
    };
    static std::vector<ExternEvaluator>     tabExternEvaluators ;
    static std::map<unsigned int, Board *>  tabEvaluatedBoards ;
    
    class Classic : public Individual<int, DiscreteFeatureLimit<int> > {
        
        public :
        
            Classic () {}
            
            virtual ~Classic () {}
            
            virtual void Display ( int file )
            {
                unsigned int    index = 0 ;
                VString         sep = "***************************************\n";
                VString         sep1 = "---------------------------------------\n";
                
                _write(file, sep.c_str(), sep.length());
                
                EString outStr ;
                
                for ( index = 0 ; index < Size() ; index++ ) {
                    outStr << Feature(index) << " \n";
                }
                _write(file, outStr.c_str(), outStr.length());
                _write(file, sep1.c_str(), sep1.length());
                for ( index = 0 ; index < Size() ; index++ ) {
                    Limits(index).Display(file);
                }
            }
            
            virtual void Read ( int file )
            {
                unsigned int    index = 0 ;
                EString         line ;
                
                ReadOneFileLine(file, line);
                for ( index = 0 ; index < Size() ; index++ ) {
                    ReadOneFileLine(file, line);
                    Feature(index, atoi(line.c_str()));
                }
                ReadOneFileLine(file, line);
                for ( index = 0 ; index < Size() ; index++ ) {
                    ReadOneFileLine(file, line);
                }
            }
    };
    
    class Ordered : public OrderedIndividual<int, SimpleLimit<int> > {
        
        public :
        
            Ordered ( Individual<int, SimpleLimit<int> > *pindividual )
            {
                pvIndividual = pindividual ;
            }
            
            virtual ~Ordered () {}
            
            Ordered ( const Ordered &ordered )
                : OrderedIndividual<int, SimpleLimit<int> > ((OrderedIndividual<int, SimpleLimit<int> > &)ordered)
            {
                pvIndividual = ordered.pvIndividual ;
            }
            
            virtual bool CanExchange ( unsigned int index1, unsigned int index2 )
            {
                if ( pvIndividual ) 
                    return pvIndividual->CanExchange(index1, index2);
                else 
                    return false ;
            }
            
            Ordered &SetIndividual ( Individual<int, SimpleLimit<int> > &individual )
            {
                pvIndividual = &individual ;
                return *this ;
            }
            
            Individual<int, SimpleLimit<int> >  *pvIndividual ;
            
            virtual void Display ( int file )
            {
                unsigned int    index = 0 ;
                VString         sep = "***************************************\n";
                VString         sep1 = "---------------------------------------\n";
                
                _write(file, sep.c_str(), sep.length());
                
                EString outStr ;
                
                for ( index = 0 ; index < Size() ; index++ ) {
                    outStr << Feature(index) << " \n";
                }
                _write(file, outStr.c_str(), outStr.length());
                _write(file, sep1.c_str(), sep1.length());
                for ( index = 0 ; index < Size() ; index++ ) {
                    Limits(index).Display(file);
                }
            }
            
            virtual void Read ( int file )
            {
                unsigned int    index = 0 ;
                EString         line ;
                
                ReadOneFileLine(file, line);
                for ( index = 0 ; index < Size() ; index++ ) {
                    ReadOneFileLine(file, line);
                    Feature(index, atoi(line.c_str()));
                }
                ReadOneFileLine(file, line);
                for ( index = 0 ; index < Size() ; index++ ) {
                    ReadOneFileLine(file, line);
                }
            }
    };
    
    class Board : public Classic {
        
        public :
        
            Board ()
                : pCostFunction(0),  pvOrdered(0),  pSchedulerEvaluate(0),  pvpSemaphop(0)
            {}
            
            // constructor
            Board ( SchedulerEvaluate *pSched, double(*pCost)(bool, SchedulerEvaluate *, Board *) )
                : pCostFunction(pCost),  pvOrdered(0),  pSchedulerEvaluate(pSched)
            {}
            
            // copy constructor 
            Board ( const Board &individual )
                : Classic(),  pvOrdered(individual.pvOrdered)
            {
                Affect((Individual<int, DiscreteFeatureLimit<int> > &)(Classic &)individual);
            }
            
            // copy constructor 
            Board &operator= ( const Board &individual )
            {
                Affect((Individual<int, DiscreteFeatureLimit<int> > &)(Classic &)individual);
                return *this ;
            }
            
            ~Board () {}
            
            virtual void Affect ( const Individual<int, DiscreteFeatureLimit<int> > &src )
            {
                pCostFunction = ((Board &)(Classic &)src).pCostFunction ;
                pSchedulerEvaluate = ((Board &)(Classic &)src).pSchedulerEvaluate ;
                Individual<int, DiscreteFeatureLimit<int> > ::Affect(src);
                pvOrdered.Affect(((Board &)src).pvOrdered);
            }
            
            // Evaluate individual 
            virtual float Evaluate ( Semaphop *pSemaphop )
            {
                pvpSemaphop = pSemaphop ;
                if ( pCostFunction && pSchedulerEvaluate ) 
                    return (*pCostFunction)(pSemaphop == 0, pSchedulerEvaluate, this);
                return 0.0 ;
            }
            
            // equality test
            bool operator== ( const Board &individual )
            {
                return *((Individual<int, DiscreteFeatureLimit<int> > *)this) == (Individual<int, DiscreteFeatureLimit<int> > &)individual
                        && pvOrdered == individual.pvOrdered ;
            }
            
            // equality test
            bool operator!= ( const Board &individual )
            {
                return *((Individual<int, DiscreteFeatureLimit<int> > *)this) != (Individual<int, DiscreteFeatureLimit<int> > &)individual
                        || !(pvOrdered == individual.pvOrdered);
            }
            
            // RandomFill : random fill an individual
            virtual void RandomFill ()
            {
                ((Classic *)this)->Individual<int, DiscreteFeatureLimit<int> > ::RandomFill();
                
                // get trail 
                std::vector<unsigned int>               trail = GetRandomTrail(pSchedulerEvaluate);
                std::vector<unsigned int> ::iterator    iterTrail ;
                unsigned int                            index = 0 ;
                
                for ( iterTrail = trail.begin() ; iterTrail != trail.end() ; iterTrail++ ) {
                    pvOrdered.Feature(index++, (*iterTrail), SimpleLimit<int> (0, 0));
                }
            }
            
            virtual void MergeFrom ( Board &father, Board &mother )
            {
                pCostFunction = ((Board &)(Classic &)father).pCostFunction ;
                Individual<int, DiscreteFeatureLimit<int> > ::MergeFrom((Individual<int, DiscreteFeatureLimit<int> > &)father
                    , (Individual<int, DiscreteFeatureLimit<int> > &)mother);
                pvOrdered.MergeFrom(father.pvOrdered, mother.pvOrdered);
            }
            
            virtual bool CanExchange ( unsigned int index1, unsigned int index2 )
            {
                return !DirectDescent(pSchedulerEvaluate, pvOrdered.Feature(index1), pvOrdered.Feature(index2));
            }
            
            virtual void Mutate ()
            {
                if ( RandomValue(0, 2) ) {
                    Individual<int, DiscreteFeatureLimit<int> > ::Mutate();
                } else {
                    Evaluated(false);
                    
                    //       cerr << "Before\n";
                    // DisplayTrail();
                    //                        pvOrdered.Mutate();
                    int             *param2 = new int [((Ordered *)this)->Size() + 1];
                    unsigned int    index ;
                    for ( index = 0 ; index < pvOrdered.Size() ; index++ ) 
                        param2 [index] = pvOrdered.Feature(index);
                    param2 [index] = 0 ;
                    MutateTrail(pSchedulerEvaluate, param2);
                    for ( index = 0 ; index < pvOrdered.Size() ; index++ ) 
                        pvOrdered.Feature(index, param2 [index]);
                    
                    // float   oldCost = (*pCostFunction)(param);
                    // cerr << "After\n";
                    // DisplayTrail();
                    delete [] param2 ;
                }
            }
            
            void DisplayTrail ( Scheduler &scheduler )
            {
                EString message ;
                
                message << "Trail : \n";
                for ( unsigned int index = 0 ; index < pvOrdered.Size() ; index++ ) {
                    message << scheduler.GetAlgoByNumber(pvOrdered.Feature(index))->Name() << " ";
                }
                std::cerr << message << "\n";
            }
            
            Ordered &GetOrdered ()
            {
                return pvOrdered ;
            }
            
            Semaphop *GetSemaphop ()
            {
                return pvpSemaphop ;
            }
            
            virtual void Display ( int file )
            {
                ((Classic *)this)->Classic::Display(file);
                pvOrdered.Display(file);
            }
            
            virtual void Read ( int file )
            {
                ((Classic *)this)->Classic::Read(file);
                pvOrdered.Read(file);
            }
            
            double              (*pCostFunction)(bool, SchedulerEvaluate *, Board *) ;
            SchedulerEvaluate   *pSchedulerEvaluate ;
            Ordered             pvOrdered ;
            Semaphop            *pvpSemaphop ;
    };
    
    class SchedulerEvaluate {
        
        public :
        
            // constructor
            SchedulerEvaluate ( Scheduler **pScheduler )
                : pvpScheduler(pScheduler),  param1Size(0),  param2Size(0)
            {}
            
            // destructor
            virtual ~SchedulerEvaluate () {}
            
            // evaluation function
            virtual double operator() ( int param [], int param2 [] )
            {
                std::map<EString, ComputeUnit *, LessString> ::iterator iter ;
                int                                                     index = 0 ;
                std::vector<int>                                        trail ;
                
                for ( iter = (*pvpScheduler)->LeafAlgorithm().begin() ; iter != (*pvpScheduler)->LeafAlgorithm().end() ; iter++ ) {
                    (*pvpScheduler)->AffectProcessor((*iter).second, param [index++]);
                }
                index = 0 ;
                for ( iter = (*pvpScheduler)->LeafAlgorithm().begin() ; iter != (*pvpScheduler)->LeafAlgorithm().end() ; iter++ ) {
                    trail.push_back((param2 [index++]));
                }
                (*pvpScheduler)->ClearSchedule();
                (*pvpScheduler)->Schedule(trail);
                (*pvpScheduler)->Cost(latency, cadency);
                
                double  ret = (double)cadency * CADENCY_FACTOR + (double)latency * LATENCY_FACTOR ;
                
                //            double  ret = latency + mean / 20 ;
                //double  ret = latency ;
                ret = -ret ;
                return ret ;
            }
            
            void ExtractParam ( Board *pBoard )
            {
                
                // EString message = "Start of cost \n";
                // write(2, message.c_str(), message.length());
                // allocate space for getting value of param
                if ( param1Size && param1Size < ((Classic *)(pBoard))->Size() + 1 ) {
                    free(param1);
                    param1Size = 0 ;
                }
                if ( param2Size && param2Size < pBoard->GetOrdered().Size() + 1 ) {
                    free(param2);
                    param2Size = 0 ;
                }
                if ( !param1Size ) {
                    param1 = (int *)malloc(sizeof(int) * (param1Size = ((Classic *)(pBoard))->Size() + 1));
                }
                if ( !param2Size ) {
                    param2 = (int *)malloc(sizeof(int) * (param2Size = pBoard->GetOrdered().Size() + 1));
                }
                
                int index ;
                
                pBoard->FeatureCopy(param1, 0, pBoard->Size());
                *(param1 + pBoard->Size()) = 0 ;
                pBoard->GetOrdered().FeatureCopy(param2, 0, pBoard->GetOrdered().Size());
                *(param2 + pBoard->GetOrdered().Size()) = 0 ;
            }
            
            double Cost ( Board *pBoard )
            {
                if ( pBoard->Evaluated() ) {
                    EString message = "AllReady Evaluated \n";
                    _write(2, message.c_str(), message.length());
                    double  ret = pBoard->Cost();
                    pBoard->Evaluated(true, pBoard->GetSemaphop());
                    return ret ;
                }
                
                // extract parameters
                ExtractParam(pBoard);
                
                // evaluate individual                
                double  ret ;
                
                pBoard->Cost(ret = (*this)(param1, param2));
                
                // be careful after this board might be again not evaluated
                pBoard->Evaluated(true, pBoard->GetSemaphop());
                return ret ;
            }
            
            void CostConnection ( Board *pBoard, bool flush = true, unsigned int nbIndividual = 0, bool compact = true )
            {
#               ifdef WITH_CONNECTION
                    if ( !pBoard ) 
                        return ;
                    if ( pBoard->Evaluated() ) {
                        EString message = "AllReady Evaluated \n";
                        _write(2, message.c_str(), message.length());
                        pBoard->Evaluated(true, pBoard->GetSemaphop());
                        availableCpu.FreeRessource(1);
                    }
                    
                    // extract parameters
                    ExtractParam(pBoard);
                    
                    std::vector<ExternEvaluator> ::iterator iterEvaluator = tabExternEvaluators.end();
                    std::vector<ExternEvaluator> ::iterator iterEvaluatorFound ;
                    std::vector<ExternEvaluator> ::iterator iterEvaluatorZero ;
                    unsigned int                            index = 0 ;
                    int                                     indexSelected = -1 ;
                    int                                     indexZero = -1 ;
                    unsigned int                            maxEvaluated ;
                    bool                                    oneOff = false ;
                    bool                                    allEmpty = true ;
                    
                    while ( true ) {
                        
                        // initialize variable 
                        {
                            iterEvaluator = tabExternEvaluators.end();
                            indexZero = indexSelected = -1 ;
                            maxEvaluated = LOAD_PER_CPU ;
                            oneOff = false ;
                            allEmpty = true ;
                        }
                        for ( index = 0, iterEvaluator = tabExternEvaluators.begin() ; iterEvaluator != tabExternEvaluators.end() ; 
                                iterEvaluator++, index++ ) {
                            if ( (*iterEvaluator).on ) {
                                if ( (*iterEvaluator).nbTreated < (*iterEvaluator).toStore && (*iterEvaluator).nbTreated < maxEvaluated ) {
                                    maxEvaluated = (*iterEvaluator).nbTreated ;
                                    iterEvaluatorFound = iterEvaluator ;
                                    indexSelected = index ;
                                }
                                if ( (*iterEvaluator).nbTreated ) {
                                    allEmpty = false ;
                                }
                                if ( (*iterEvaluator).nbTreated == 0 && (*iterEvaluator).toStore == 0 ) {
                                    indexZero = index ;
                                    iterEvaluatorZero = iterEvaluator ;
                                }
                            } else 
                                oneOff = true ;
                        }
                        
                        // if necessary compact
                        if ( false && compact && allEmpty && oneOff ) {
                            std::vector<ExternEvaluator>    newTabExternEvaluators ;
                            for ( iterEvaluator = tabExternEvaluators.begin() ; iterEvaluator != tabExternEvaluators.end() ; iterEvaluator++ ) {
                                if ( (*iterEvaluator).on ) {
                                    newTabExternEvaluators.push_back(*iterEvaluator);
                                }
                            }
                            tabExternEvaluators = newTabExternEvaluators ;
                            continue ;
                        }
                        break ;
                    }
                    if ( indexZero >= 0 ) {
                        (*iterEvaluatorZero).startStore = time(0);
                        (*iterEvaluatorZero).nbTreated = LOAD_PER_CPU ;
                        (*iterEvaluatorZero).nbStore = LOAD_PER_CPU ;
                        (*iterEvaluatorZero).lastResult = time(0);
                        INC_INDEX((*iterEvaluatorZero).indexWrite);
                        (*iterEvaluatorZero).treated [(*iterEvaluatorZero).indexWrite] = 0 ;
                        {
                            
                            // send parameters
                            {
                                
                                // ask for extern evaluator
                                IE  ie ;
                                IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
                                GENTIC::pdu_write_computeRqstQ(&ie, 0, indexZero, 0, param1, ((Classic *)(pBoard))->Size(), param2
                                    , pBoard->GetOrdered().Size());
                                unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
                                VString         data = VString(encodeBuffer2, sizePacket);
                                if ( !sizePacket ) 
                                    MetaExit(3, "Invalid encoding \n");
                                else {
                                    int nbSend = LOAD_PER_CPU - 1 ;
                                    while ( nbSend-- > 0 ) {
                                        eConnection.SendString((*iterEvaluatorZero).channel, data, false);
                                    }
                                    eConnection.SendString((*iterEvaluatorZero).channel, data, flush);
                                }
                            }
                        }
                    }
                    if ( indexSelected >= 0 ) {
                        while ( !nbIndividual ) 
                            nbIndividual = currIndividual++ ;
                        tabEvaluatedBoards [nbIndividual] = pBoard ;
                        if ( (*iterEvaluatorFound).nbTreated == 0 ) {
                            (*iterEvaluatorFound).startStore = time(0);
                            (*iterEvaluatorFound).nbStore = 0 ;
                        }
                        (*iterEvaluatorFound).nbTreated++ ;
                        (*iterEvaluatorFound).nbStore++ ;
                        (*iterEvaluatorFound).lastResult = time(0);
                        INC_INDEX((*iterEvaluatorFound).indexWrite);
                        (*iterEvaluatorFound).treated [(*iterEvaluatorFound).indexWrite] = nbIndividual ;
                        {
                            
                            // send parameters
                            {
                                
                                // ask for extern evaluator
                                IE  ie ;
                                IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
                                GENTIC::pdu_write_computeRqstQ(&ie, 0, indexSelected, nbIndividual, param1, ((Classic *)(pBoard))->Size(), param2
                                    , pBoard->GetOrdered().Size());
                                unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
                                VString         data = VString(encodeBuffer2, sizePacket);
                                if ( !sizePacket ) 
                                    MetaExit(3, "Invalid encoding \n");
                                else 
                                    eConnection.SendString((*iterEvaluatorFound).channel, data, flush);
                            }
                        }
                    } else {
                        
                        // flush data and put back board
                        EString channel = "";
                        eConnection.SendString(channel, "", true);
                        AddWaitingBoards(pBoard);
                    }
#               endif
            }
            
#           define DEBUG_MEAN 1
            
            // CheckEvaluator : check if one evaluator is not sleeping
            void CheckEvaluator ()
            {
                unsigned int    runSize = 0 ;
                double          coeffPopulation = 1.0 ;
                
#               ifdef WITH_CONNECTION
                    
                    std::vector<ExternEvaluator> ::iterator iterEvaluator ;
                    unsigned int                            minEvaluated = LOAD_PER_CPU ;
                    EString                                 mean("\nMean : ");
                    double                                  minMean = 100000.0 ;
                    
                    for ( iterEvaluator = tabExternEvaluators.begin() ; iterEvaluator != tabExternEvaluators.end() ; iterEvaluator++ ) {
                        if ( (*iterEvaluator).on && (*iterEvaluator).lastResult && (*iterEvaluator).nbTreated < minEvaluated ) {
                            minEvaluated = (*iterEvaluator).nbTreated ;
                        }
                    }
                    for ( iterEvaluator = tabExternEvaluators.begin() ; iterEvaluator != tabExternEvaluators.end() ; iterEvaluator++ ) {
                        if ( (*iterEvaluator).on && (*iterEvaluator).throughPut ) {
#                           if DEBUG_MEAN
                                mean << (*iterEvaluator).throughPut << " ";
#                           endif
                            if ( (*iterEvaluator).throughPut < minMean ) 
                                minMean = (*iterEvaluator).throughPut ;
                            runSize += (int)((*iterEvaluator).notCorrected);
                        }
                    }
#                   if DEBUG_MEAN
                        mean << "\n";
#                   endif
                    if ( runSize > newPopulationSize ) {
                        coeffPopulation = ((float)newPopulationSize) / ((float)runSize);
                    }
#                   if DEBUG_MEAN
                        mean << "total population : " << (int)runSize << " new population " << (int)newPopulationSize << " coeff : "
                            << (int)coeffPopulation << "\n";
#                   endif
                    for ( iterEvaluator = tabExternEvaluators.begin() ; iterEvaluator != tabExternEvaluators.end() ; iterEvaluator++ ) {
                        if ( (*iterEvaluator).on && (*iterEvaluator).throughPut && minMean ) {
                            (*iterEvaluator).notCorrected = LOAD_PER_CPU * minMean / (*iterEvaluator).throughPut ;
                            unsigned int    newVal = (int)((*iterEvaluator).notCorrected * coeffPopulation);
                            if ( (*iterEvaluator).notCorrected < LOAD_PER_CPU / 10 ) 
                                newVal = 0 ;
                            if ( newVal > (*iterEvaluator).toStore ) {
                                availableCpu.PutRessource(newVal - (*iterEvaluator).toStore);
                            } else if ( newVal < (*iterEvaluator).toStore ) {
                                
                                // will be auto regulated
                                // availableCpu.GetRessource((*iterEvaluator).toStore - newVal);
                            }
                            (*iterEvaluator).toStore = newVal ;
#                           if DEBUG_MEAN
                                mean << (*iterEvaluator).channel << " : " << (int)(*iterEvaluator).toStore << " ";
#                           endif
                        }
                    }
#                   if DEBUG_MEAN
                        mean << "\n";
                        std::cerr << mean.c_str();
#                   endif
                    if ( minEvaluated == 0 ) 
                        for ( iterEvaluator = tabExternEvaluators.begin() ; iterEvaluator != tabExternEvaluators.end() ; iterEvaluator++ ) {
                            if ( (*iterEvaluator).on
                                    && (*iterEvaluator).nbTreated > 0
                                    && (*iterEvaluator).lastResult
                                    && time(0) - (*iterEvaluator).lastResult > TIME_INDIVIDUAL ) {
                                
                                // disable it
                                (*iterEvaluator).on = false ;
                                
                                // dispatch its messages
                                unsigned int    index = (*iterEvaluator).indexRead ;
                                unsigned int    indexMax = (*iterEvaluator).indexWrite ;
                                while ( index != (*iterEvaluator).indexWrite ) {
                                    INC_INDEX(index);
                                    CostConnection(tabEvaluatedBoards [(*iterEvaluator).treated [index]], true /* flush */ 
                                        , (*iterEvaluator).treated [index], false /* no compacting*/ );
                                }
                                availableCpu.GetRessource(LOAD_PER_CPU - (*iterEvaluator).nbTreated);
                                (*iterEvaluator).nbTreated = 0 ;
                                
                                // close channel
                                eConnection.CloseChannel((*iterEvaluator).channel);
                                
                                // will see next after
                                break ;
                            }
                        }
#               endif
            }
            
            // Scheduler : return the scheduler
            Scheduler &GetScheduler ()
            {
                return **pvpScheduler ;
            }
            
            unsigned int &Latency ()
            {
                return latency ;
            }
            
            unsigned int &Cadency ()
            {
                return cadency ;
            }
        
        private :
        
            Scheduler       **pvpScheduler ;
            unsigned int    param1Size ;
            unsigned int    param2Size ;
            int             *param1 ;
            int             *param2 ;
            unsigned int    latency ;
            unsigned int    cadency ;
    };
    static Scheduler                        *pScheduler [MAX_THREAD] = { 0 };
    static Scheduler                        *pSchedulerConnection = 0 ;
    
    void SetExternScheduler ( EString fileName )
    {
        int indexThread ;
        
        currentFileName = fileName ;
        
        // compute with three processors
        PTREE   tree = syndex().ReadFile(fileName.c_str());
        
        for ( indexThread = 0 ; indexThread < nbThread ; indexThread++ ) {
            if ( pScheduler [indexThread] ) 
                delete pScheduler [indexThread];
            pScheduler [indexThread] = new Scheduler(tree);
            pScheduler [indexThread]->Explore();
        }
#       ifdef WITH_CONNECTION
            if ( distributed ) {
                protectBoard.GetRessource(1);
                {
                    if ( pSchedulerConnection ) 
                        delete pSchedulerConnection ;
                    pSchedulerConnection = new Scheduler(tree);
                    pSchedulerConnection->Explore();
                }
                if ( eConnection.Connected() ) {
                    
                    // reset evaluators
                    tabExternEvaluators.clear();
                    tabEvaluatedBoards.clear();
                    
                    // ask for extern evaluator
                    IE  ie ;
                    IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
                    VString currFileName = fileName ;
                    
                    // read file
                    EString fileContent ;
                    {
                        int readData [512];
                        int nbRead = 0 ;
                        int inFile = _open(fileName.c_str(), O_RDONLY, 0666);
                        while ( (nbRead = read(inFile, &readData, 512)) > 0 ) {
                            fileContent << VString((char *)readData, nbRead);
                        }
                        _close(inFile);
                    }
                    
                    // write order
                    GENTIC::pdu_write_loadRqstQ(&ie, 0, currFileName, fileContent);
                    unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
                    VString         data = VString(encodeBuffer2, sizePacket);
                    if ( !sizePacket ) 
                        MetaExit(3, "Invalid encoding \n");
                    else 
                        eConnection.SendString(genticChannel, data);
                }
                {
                    unsigned int    stock = availableCpu.GetStockInfo();
                    if ( stock ) 
                        availableCpu.GetRessource(stock);
                }
                protectBoard.FreeRessource(1);
            }
#       endif
    }
    
    std::vector<unsigned int> GetRandomTrail ( SchedulerEvaluate *pSchedEv )
    {
        return pSchedEv->GetScheduler().RandomTrail();
    }
    
    bool DirectDescent ( SchedulerEvaluate *pSchedEv, int pComp1, int pComp2 )
    {
        return pSchedEv->GetScheduler().DirectDescent(pSchedEv->GetScheduler().GetAlgoByNumber(pComp1)
            , pSchedEv->GetScheduler().GetAlgoByNumber(pComp2));
    }
    
    void MutateTrail ( SchedulerEvaluate *pSchedEv, int *pInt )
    {
        pSchedEv->GetScheduler().MutateTrail(pInt);
    }
#endif
