#include <vector>
#include <stdio.h>
#include "erlstring.h"

int main ( int argc, char **argv )
{
    std::vector<EString>    currVector ;
    std::vector<EString>    lastVector ;
    std::vector<EString>    newLastVector ;
    int                     nb = atoi(*(argv + 1));
    int                     index ;
    EString                 name ;
    
    currVector.push_back("n1");
    lastVector = currVector ;
    
    std::vector<EString> ::iterator iter ;
    
    for ( index = 2 ; index <= nb ; index++ ) {
        for ( iter = lastVector.begin() ; iter != lastVector.end() ; iter++ ) {
            name = *iter ;
            name << "1";
            currVector.push_back(name);
            newLastVector.push_back(name);
            name = *iter ;
            name << "2";
            currVector.push_back(name);
            newLastVector.push_back(name);
        }
        lastVector = newLastVector ;
        newLastVector.clear();
    }
    
    EString message ;
    
    for ( iter = currVector.begin() ; iter != currVector.end() ; iter++ ) {
        message = "";
        message << "node_type " << *iter << ";\n";
        std::cout << message.c_str();
    }
    for ( iter = currVector.begin() ; iter != currVector.end() ; iter++ ) {
        message = "";
        message << "dual_node_type dual_" << *iter << ";\n";
        std::cout << message.c_str();
    }
    message = "dependences :\n";
    std::cout << message.c_str();
    
    // compute the number of node to be connected
    unsigned int nbConnected = 0 ;
    
    nbConnected = 1 ;
    if ( nb >= 2 ) {
        nbConnected <<= nb ;
        nbConnected -= 2 ;
    }
    
    // do the connections
    unsigned int    done ;
    
    for ( iter = currVector.begin(), (done = 1) ; iter != currVector.end() && done++ <= nbConnected / 2 ; iter++ ) {
        message = " strong_precedence_data ";
        name = *iter ;
        name << "1";
        message << *iter << ".out1 -> " << name << ".in;\n";
        std::cout << message.c_str();
        message = " strong_precedence_data ";
        name = *iter ;
        name << "2";
        message << *iter << ".out2 -> " << name << ".in;\n";
        std::cout << message.c_str();
    }
    for ( iter = currVector.begin(), (done = 1) ; iter != currVector.end() && done++ <= nbConnected / 2 ; iter++ ) {
        message = " strong_precedence_data ";
        name = *iter ;
        name << "1";
        message << "dual_" << name << ".out -> " << "dual_" << *iter << ".in1;\n";
        std::cout << message.c_str();
        message = " strong_precedence_data ";
        name = *iter ;
        name << "2";
        message << "dual_" << name << ".out -> " << "dual_" << *iter << ".in2;\n";
        std::cout << message.c_str();
    }
    
    // interconnect dual and not dual
    for (; iter != currVector.end() ; iter++ ) {
        message = " strong_precedence_data ";
        message << *iter << ".out1 -> " << "dual_" << *iter << ".in1;\n";
        std::cout << message.c_str();
        message = " strong_precedence_data ";
        message << *iter << ".out2 -> " << "dual_" << *iter << ".in2;\n";
        std::cout << message.c_str();
    }
    return 0 ;
}
