/*************************************************************************/
/*                                                                       */
/*        operatormedia.ch   : Eric Lavillonniere 2005                   */
/*        company            : Mitsubishi Electric ITE                   */
/*                                                                       */
/*************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public License
   along with this program; see the file COPYING. If not, write to 
   the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   */
language syndex;

#include <vector>
#include "operatormedia.h"
#include "syndex.h"

static OperatorMedia    defaultOperMedia ;
OperatorMedia           *OperatorMedia::pOperatorMedia ;

class Initializer {
    
    public :
    
        Initializer ()
        {
            OperatorMedia::pOperatorMedia = &defaultOperMedia ;
        }
};
static Initializer      initializer ;

// SearchConnection : search a connection between to proc
OperatorMedia *HardProcUnit::SearchConnection ( OperatorMedia *proc )
{
    std::vector<OperatorMedia *> & linked = Linked();
    
    unsigned int    index ;
    
    for ( index = 0 ; index < linked.size() ; index++ ) {
        OperatorMedia   *pOperatorMedia = linked [index];
        std::vector<OperatorMedia *> & linkedMedia = pOperatorMedia->Linked();
        unsigned int    indexLink ;
        for ( indexLink = 0 ; indexLink < linkedMedia.size() ; indexLink++ ) {
            if ( linkedMedia [indexLink] == proc ) {
                return pOperatorMedia ;
            }
        }
    }
    
    // fail
    return 0 ;
}

// SearchConnection : search a connection between to proc
std::vector<OperatorConnect> HardProcUnit::AllConnections ()
{
    std::vector<OperatorMedia *> & linked = Linked();
    
    std::vector<OperatorConnect>    allLinked ;
    unsigned int                    index ;
    
    for ( index = 0 ; index < linked.size() ; index++ ) {
        OperatorMedia   *pOperatorMedia = linked [index];
        std::vector<OperatorMedia *> & linkedMedia = pOperatorMedia->Linked();
        unsigned int    indexLink ;
        for ( indexLink = 0 ; indexLink < linkedMedia.size() ; indexLink++ ) {
            if ( linkedMedia [indexLink] != this ) {
                OperatorConnect operConnect = { linkedMedia [indexLink], pOperatorMedia };
                allLinked.push_back(operConnect);
            }
        }
    }
    
    // connections
    return allLinked ;
}

// InsertTaskExtract : insert a task in planning
unsigned OperatorMedia::InsertTaskExtract ( unsigned int name, time_t startTime, time_t transferTime, std::vector<ConditionType> &conditions )
{
    
    // create the task 
    std::multimap<time_t, unsigned> ::iterator  iterAfter ;
    std::multimap<time_t, unsigned> ::iterator  iterBefore ;
    std::multimap<time_t, unsigned> ::iterator  startSearch = PlanningExtract().end();
    std::multimap<time_t, unsigned> ::iterator  planningEnd = PlanningExtract().end();
    time_t                                      realStartTime = 0 ;
    unsigned                                    task = 0 ;
    
    startSearch = planningEnd ;
    if ( !PlanningExtract().empty() ) {
        time_t  timeBefore ;
        iterAfter = PlanningExtract().lower_bound(startTime);
        if ( iterAfter != PlanningExtract().begin() ) {
            iterAfter-- ;
        }
        for (; iterAfter != planningEnd ; iterAfter++ ) {
            if ( (*iterAfter).first > startTime ) {
                bool    atBeginning = false ;
                iterBefore = iterAfter ;
                if ( iterBefore != PlanningExtract().begin() ) 
                    iterBefore-- ;
                else 
                    atBeginning = true ;
                if ( atBeginning || TaskContent((*iterBefore).second)->End() < startTime ) {
                    if ( startTime + transferTime < (*iterAfter).first ) {
                        task = InsertPlanningExtract(startTime, transferTime, name, conditions);
                    } else {
                        startSearch = iterAfter ;
                        break ;
                    }
                } else {
                    startSearch = iterBefore ;
                    break ;
                }
            } else if ( TaskContent((*iterAfter).second)->End() > startTime ) {
                startSearch = iterAfter ;
                break ;
            }
        }
    }
    if ( startSearch != planningEnd ) {
        for (; startSearch != planningEnd ; startSearch++ ) {
            iterAfter = startSearch ;
            iterAfter++ ;
            if ( iterAfter != planningEnd ) {
                if ( (*iterAfter).first - TaskContent((*startSearch).second)->End() > transferTime ) {
                    task = InsertPlanningExtract(TaskContent((*startSearch).second)->End(), transferTime, name, conditions);
                    break ;
                }
            }
        }
        if ( iterAfter == planningEnd ) {
            startSearch = planningEnd ;
            if ( startSearch != PlanningExtract().begin() ) 
                startSearch-- ;
            task = InsertPlanningExtract(TaskContent((*startSearch).second)->End(), transferTime, name, conditions);
        }
    } else {
        task = InsertPlanningExtract(startTime, transferTime, name, conditions);
    }
    
    // return task
    return task ;
}

// InsertTask : insert a task in planning
unsigned OperatorMedia::InsertTask ( unsigned int name, time_t startTime, time_t transferTime, std::vector<ConditionType> &conditions, int nbRef )
{
    
    // create the task 
    std::multimap<time_t, unsigned> ::iterator  iterAfter ;
    std::multimap<time_t, unsigned> ::iterator  startSearch ;
    std::multimap<time_t, unsigned> ::iterator  planningEnd = Planning().end();
    unsigned                                    task = 0 ;
    
    // if ref is given check if task is not already inserted (case of link where same data is transfered several times to several applications)
    if ( nbRef != -1 ) {
        std::map<int, unsigned> ::iterator  iterTask ;
        if ( (iterTask = pvTaskByRef.find(nbRef)) != pvTaskByRef.end() ) {
            return (*iterTask).second ;
        }
    }
    
    // insert this new task
    if ( Planning().empty() || Fpga() ) {
        task = InsertPlanning(startTime, transferTime, name, conditions, -1, nbRef);
    } else {
        time_t  foundStart = startTime ;
        
        // starting from the last task ending before start point reorder the task
        // by start time
        iterAfter = Planning().lower_bound(startTime);
        if ( iterAfter == Planning().end() ) {
            iterAfter = Planning().begin();
        }
        
        // extract tasks starting at iterAfter
        Extract(iterAfter, conditions);
        
        // insert current task
        {
            planningEnd = PlanningExtract().end();
            for ( startSearch = PlanningExtract().begin() ; startSearch != planningEnd ; startSearch++ ) {
                Task    *pTask = TaskContent((*startSearch).second);
                if ( pTask->Start() <= foundStart && pTask->End() > foundStart ) {
                    foundStart = pTask->End();
                } else {
                    if ( pTask->Start() - foundStart > transferTime ) {
                        task = InsertPlanningExtract(foundStart, transferTime, name, conditions, -1, nbRef);
                        break ;
                    } else if ( pTask->End() > foundStart ) {
                        foundStart = pTask->End();
                    }
                }
            }
            if ( startSearch == planningEnd ) {
                task = InsertPlanningExtract(foundStart, transferTime, name, conditions, -1, nbRef);
            }
        }
        
        // clear the extract of no use now
        PlanningExtract().clear();
        
        // reinsert task in array ordered by end point
        {
            Task    *pTask = TaskContent(task);
            InsertPlanning(pTask->Start(), pTask->Duration(), pTask->Name(), conditions, task, nbRef);
        }
    }
    
    // return task
    return task ;
}

// Reference : set reference 
OperatorMedia &OperatorMedia::Reference ( PTREE &reference )
{
    pvReference = reference ;
    
    PTREE   media = reference ;
    PTREE   list ;
    PTREE   time ;
    
    if ( media == <MEDIA,<>,<>,<OPERATOR_MEDIA_LIST,list>> || media == <OPERATOR,<>,<>,<OPERATOR_MEDIA_LIST,list>> ) {
        while ( time = nextl(list) ) {
            PTREE   val ;
            if ( time == <CODE_TIME,<>,val> ) {
                VString name = Value(time);
                if ( val == <TIME,<>,()> ) 
                    TimeOper(name, atof(Value(time [2])));
                else {
                    EString doubleVal = Value(val);
                    doubleVal << "." << Value(val [2]);
                    TimeOper(name, atof(doubleVal.c_str()));
                }
            }
        }
    }
    
    // creates the time reference table
    return *this ;
}

// Extract : extract task and sort with starting time
// parameters : 
//              extract : where to start extraction
void OperatorMedia::Extract ( std::multimap<time_t, unsigned> ::iterator extract, std::vector<ConditionType> &conditions )
{
    std::multimap<time_t, unsigned> ::iterator  iterAfter = extract ;
    std::multimap<time_t, unsigned> ::iterator  planningEnd = Planning().end();
    bool                                        okInsert = true ;
    std::vector<ConditionType>                  nullVector ;
    
    PlanningExtract().clear();
    for (; iterAfter != planningEnd ; iterAfter++ ) {
        Task    *pTask = TaskContent((*iterAfter).second);
        
        // look if conditions are ok for your insertion
        if ( !conditions.empty() ) {
            std::vector<ConditionType> ::iterator   iterNewCondition = conditions.begin();
            std::vector<ConditionType> ::iterator   iterTaskCondition = pTask->Conditions().begin();
            for ( okInsert = true ; okInsert ;) {
                
                // if one condition vector is empty task is inserted
                if ( iterNewCondition == conditions.end() || iterTaskCondition == pTask->Conditions().end() ) 
                    break ;
                
                // if same number of task decide
                int nbNew = NumberCondition(*iterNewCondition);
                int nbTask = NumberCondition(*iterTaskCondition);
                if ( nbNew == nbTask ) {
                    int valNew = ValCondition(*iterNewCondition);
                    int valTask = ValCondition(*iterTaskCondition);
                    
                    // not same branch so exit
                    if ( valNew != valTask ) {
                        okInsert = false ;
                    } else {
                        
                        // same branch, see otherConditions
                        iterNewCondition++ ;
                        iterTaskCondition++ ;
                    }
                    continue ;
                }
                
                // not same number advance the lower number
                if ( nbNew < nbTask ) {
                    iterNewCondition++ ;
                } else {
                    iterTaskCondition++ ;
                }
            }
        }
        
        // if ok insert task
        if ( okInsert ) 
            InsertPlanningExtract(pTask->Start(), pTask->Duration(), pTask->Name(), nullVector, (*iterAfter).second);
    }
}

// CreateTask : create a task on OperatorMedia
unsigned HardProcUnit::ComputeTime ( EString &label, PTREE ref, unsigned int nbRef )
{
    unsigned int    time ;
    
    if ( ref == <CONSTANT> ) 
        return 0 ;
    else {
        float   time = GetTimeOper(ref, nbRef);
        if ( time < 0. ) 
            time = 0.;
        return (unsigned int)time ;
    }
}

// CreateTask : create a task on OperatorMedia
unsigned LinkUnit::ComputeTime ( EString &label, PTREE refParam, unsigned int nbRef )
{
    PTREE   ref = refParam ;
    
    if ( ref == <IN,ref> || ref == <OUT,ref> || ref == <IN_OUT,ref> ) 
        ;
    
    double  time = GetTimeOper(ref, nbRef);
    
    if ( time < 0 ) {
        EString message = "\tError on : ";
        message << label << '\n';
        DisplayError(message);
        time = 0 ;
    }
    return (unsigned)(time * atoi(Value(ref [2])));
}


