/*************************************************************************/
/*                                                                       */
/*        scheduler.ch   : Eric Lavillonniere 2005                       */
/*        company        : Mitsubishi Electric ITE                       */
/*                                                                       */
/*************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public License
   along with this program; see the file COPYING. If not, write to 
   the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   */
language syndex;

#include <sys/types.h>
#include <fcntl.h>
#include "token.h"
#include "syndex.h"
#include "decsyndex.h"
#include "scheduler.h"
#include "individual.h"
#include "optimgenetic.h"
#include "semaphop.h"
#include "ethread.h"
#include "evaluator.h"

void        Optimize (Scheduler &scheduler, time_t flattening, bool retart = false, unsigned int pop = 0, unsigned int stop = 0) ;
void        TreatFile (EString name, EString message, bool restart = false, unsigned int pop = 0, unsigned int stop = 0, bool useDMA = true) ;
void        ChopTree (EString, bool restart = false, unsigned int pop = 0, unsigned int stop = 0) ;
void        decomp (PTREE) ;
bool        interactive = false ;
class Board ;
static int  echoPort = 2000 ;
static bool noDMA = false ;
LPVOID      TreatWaitingBoard (LPVOID) ;
LPVOID      TreatWaitingBoardConnection (LPVOID) ;
LPVOID      ReceiveMessages (LPVOID) ;
LPVOID      CheckEvaluator (LPVOID) ;

/******************************************************************
     copy : copyright ;
   *******************************************************************/
void copyright ()
{
    const char  *str ;
    
    str = "\n\r SynGenTools ";
    _write(2, str, strlen(str));
    str = ", CopyRight(C) 2006 Eric Lavillonniere / Mitsubishi Electric Ite \n\r";
    _write(2, str, strlen(str));
    str = " SynGenTools comes with ABSOLUTELY NO WARRANTY.\n\r";
    _write(2, str, strlen(str));
    str = " This is free software, and you are welcome to redistribute it \n\r";
    _write(2, str, strlen(str));
    str = " under certain conditions.\n\r";
    _write(2, str, strlen(str));
    str = " For details see Gnu Less General Public License version 2, described in file copying .\n\r\n\r";
    _write(2, str, strlen(str));
}

int main ( int argc, char **argv )
{
    PTREE           tree ;
    char            name [50];
    char            *ptName ;
    EString         fileName ;
    EString         destAddr("127.0.0.1");
    bool            restart = false ;
    unsigned int    pop = 0 ;
    unsigned int    stop = 0 ;
    
    // may get size of packets
    int             offset = 0 ;
    
    MetaInit("testsyndex");
    copyright();
    while ( argc >= 2 + offset ) {
        if ( VString("-thread") == *(argv + 1 + offset) ) {
            offset++ ;
            nbThread = atoi(*(argv + 1 + offset++));
            if ( nbThread > MAX_THREAD ) 
                nbThread = MAX_THREAD ;
        } // look if parameters
        else if ( VString("-distributed") == *(argv + 1 + offset) ) {
            offset++ ;
            distributed = true ;
        } // look if parameters
        else if ( VString("-ip") == *(argv + 1 + offset) ) {
            destAddr = *(argv + 2 + offset);
            offset += 2 ;
        } else if ( VString("-pop") == *(argv + 1 + offset) ) {
            pop = atoi(*(argv + 2 + offset));
            offset += 2 ;
        } else if ( VString("-stop") == *(argv + 1 + offset) ) {
            stop = atoi(*(argv + 2 + offset));
            offset += 2 ;
        } else if ( VString("-restart") == *(argv + 1 + offset) ) {
            restart = true ;
            offset++ ;
        } else if ( VString("-port") == *(argv + 1 + offset) ) {
            echoPort = atoi(*(argv + 2 + offset));
            offset += 2 ;
        } else if ( VString("-port") == *(argv + 1 + offset) ) {
            echoPort = atoi(*(argv + 2 + offset));
            offset += 2 ;
        } else if ( VString("-i") == *(argv + 1 + offset) ) {
            offset++ ;
            interactive = true ;
        } else if ( VString("-noDMA") == *(argv + 1 + offset) ) {
            offset++ ;
            noDMA = true ;
        } else if ( fileName == "" ) {
            fileName = *(argv + 1 + offset);
            offset++ ;
        } else {
            EString help ;
            
            // [-inet size]
            help += "testsyndex [-i] [-ip ip] [-port port] [-distributed] [-thread n] [-restart] [-pop population] [-stop numberstable] [-noDMA] [fileName] \n\n";
            _write(2, help.c_str(), help.length());
            return 3 ;
        }
    }
    pWaitingSemaphop = new Semaphop ;
    protectBoard.FreeRessource(1);
    
    // connection initialisation
#   ifdef WITH_CONNECTION
        
        // configure connection
        if ( distributed ) {
            eConnection.Open(genticName.c_str(), "127.0.0.1", (char *)(destAddr.c_str()) /* for distant */ , echoPort, -1, true);
            eConnection.OpenChannel(genticChannel);
            
            // set time for reading wait
            {
                struct timeval tval ;
                tval.tv_sec = 5 ;
                tval.tv_usec = 0 ;
                eConnection.TimeVal(tval);
            }
        }
#   endif
    
    int indexThread [MAX_THREAD];
    int i ;
    
    for ( i = 0 ; i < MAX_THREAD ; i++ ) {
        indexThread [i] = i ;
    }
    if ( nbThread ) {
        int created ;
        for ( created = 0 ; created < nbThread ; created++ ) {
            ERLTOOLS::CreateThread((LPTHREAD_START_ROUTINE)TreatWaitingBoard, (LPVOID)(&indexThread [created]));
        }
    }
    if ( distributed ) {
        ERLTOOLS::CreateThread((LPTHREAD_START_ROUTINE)TreatWaitingBoardConnection, 0);
        ERLTOOLS::CreateThread((LPTHREAD_START_ROUTINE)ReceiveMessages, 0);
        ERLTOOLS::CreateThread((LPTHREAD_START_ROUTINE)CheckEvaluator, 0);
    }
    syndex().AsLanguage();
    ChopTree(fileName, restart, pop, stop);
    output=2;
    MetaEnd();
    if ( !firstError ) 
        return 1 ;
    else 
        return 0 ;
}

class BoardNursery : public Nursery<Board> {
    
    public :
    
        BoardNursery ( SchedulerEvaluate *pScheduleEvaluate )
            : pvpScheduleEvaluate(pScheduleEvaluate),  pvNbCall(0)
        {
        }
        
        virtual ~BoardNursery ()
        {
        }
        
        virtual Board Create ()
        {
            Board           individual (pvpScheduleEvaluate, BoardEvaluator) ;
            unsigned int    size = pvpScheduleEvaluate->GetScheduler().LeafAlgorithm().size();
            unsigned int    nbProcessor = pvpScheduleEvaluate->GetScheduler().Operators().size();
            
            if ( size < 1 ) 
                size = 1 ;
            
            unsigned int    indexIndividual ;
            
            // first individual will be trivial one with processor first choice             
            if ( pvNbCall >= nbProcessor ) {
                
                // for each algo get valid processors and affect them as a limit
                for ( indexIndividual = 0 ; indexIndividual < size ; indexIndividual++ ) {
                    std::vector<int>    limits ;
                    pvpScheduleEvaluate->GetScheduler().GetProcessors(indexIndividual, limits);
                    individual.Limits(indexIndividual, DiscreteFeatureLimit<int> (limits));
                }
                
                // knowing the limits fill the algo with random processors
                individual.RandomFill();
            } else {
                
                // for each algo get valid processors and affect nth processor as a limit
                for ( indexIndividual = 0 ; indexIndividual < size ; indexIndividual++ ) {
                    std::vector<int>    limits ;
                    std::vector<int>    limitsSimple ;
                    pvpScheduleEvaluate->GetScheduler().GetProcessors(indexIndividual, limits);
                    if ( limits.size() > pvNbCall ) 
                        limitsSimple.push_back(limits [pvNbCall]);
                    else 
                        limitsSimple.push_back(limits [0]);
                    individual.Limits(indexIndividual, DiscreteFeatureLimit<int> (limitsSimple));
                }
                
                // knowing the limits fill the algo with random processors
                individual.RandomFill();
                
                // for each algo get valid processors and affect them as a limit
                for ( indexIndividual = 0 ; indexIndividual < size ; indexIndividual++ ) {
                    std::vector<int>    limits ;
                    pvpScheduleEvaluate->GetScheduler().GetProcessors(indexIndividual, limits);
                    
                    // set limit without changing value
                    individual.Limits(indexIndividual, DiscreteFeatureLimit<int> (limits), false);
                }
            }
            
            // increment call counter
            pvNbCall++ ;
            
            // return new individual
            return individual ;
        }
    
    private :
    
        unsigned int        pvNbCall ;
        SchedulerEvaluate   *pvpScheduleEvaluate ;
};
static std::list<Board *>   waitingBoards ;

void AddWaitingBoards ( Board *pBoard )
{
    (*pWaitingSemaphop).PutRessourceBegin(1);
    if ( !pBoard ) {
        EString message = "Null Stacked \n";
        _write(2, message.c_str(), message.length());
    }
    waitingBoards.push_back(pBoard);
    (*pWaitingSemaphop).PutRessourceEnd();
}

LPVOID TreatWaitingBoard ( LPVOID pParam )
{
    Board               *pBoard ;
    int                 indexThread = *(int *)pParam ;
    SchedulerEvaluate   sched(&pScheduler [indexThread]);
    
    while ( true ) {
        
        // get new board
        (*pWaitingSemaphop).GetRessourceBegin(1);
        
        // sleep(1);
        if ( waitingBoards.size() >= 1 ) {
            pBoard = waitingBoards.front();
            waitingBoards.pop_front();
        } else {
            EString message = "Nothing to destack \n";
            _write(2, message.c_str(), message.length());
            pBoard = 0 ;
        }
        (*pWaitingSemaphop).GetRessourceEnd();
        
        // treat it
        if ( pBoard ) 
            sched.Cost(pBoard);
    }
    return 0 ;
}

LPVOID TreatWaitingBoardConnection ( LPVOID pParam )
{
    Board               *pBoard ;
    SchedulerEvaluate   sched(&pSchedulerConnection);
    
#   ifndef WITH_CONNECTION
        return 0 ;
#   else 
        while ( true ) {
            availableCpu.GetRessource(1);
            
            // get new board
            (*pWaitingSemaphop).GetRessourceBegin(1);
            
            // sleep(1);
            if ( waitingBoards.size() >= 1 ) {
                pBoard = waitingBoards.front();
                waitingBoards.pop_front();
            } else {
                EString message = "Nothing to destack \n";
                _write(2, message.c_str(), message.length());
                pBoard = 0 ;
            }
            (*pWaitingSemaphop).GetRessourceEnd();
            
            // treat it
            if ( pBoard ) {
                protectBoard.GetRessource(1);
                sched.CostConnection(pBoard);
                
                // sched.CostConnection(pBoard, !waitingBoards.size() || !availableCpu.GetStockInfo());
                protectBoard.FreeRessource(1);
            }
        }
#   endif
    return 0 ;
}

static OptimGenetic<BoardNursery::TypeIndividual, BoardNursery::TypeIndividual::TypeParam>  *pGenetic = 0 ;

LPVOID CheckEvaluator ( LPVOID pParam )
{
    SchedulerEvaluate   sched(&pSchedulerConnection);
    
#   ifndef WITH_CONNECTION
        return 0 ;
#   else 
        while ( true ) {
            if ( pGenetic ) 
                newPopulationSize = pGenetic->NewPopulationSize();
            protectBoard.GetRessource(1);
            sched.CheckEvaluator();
            protectBoard.FreeRessource(1);
            SLEEP(TIME_INDIVIDUAL);
        }
#   endif
    return 0 ;
}

LPVOID ReceiveMessages ( LPVOID pParam )
{
#   ifndef WITH_CONNECTION
        return 0 ;
#   else 
        
        PTREE   message ;
        
        while ( true ) {
            message = eConnection.ReceiveContent(true);
            VString data = "";
            if ( message != PTREE(0) ) {
                
                // first case is valid only if there is one connection      
                {
                    data = GetStringFromTree(message);
                    if ( data.length() > 0 ) {
                        protectBoard.GetRessource(1);
                        
                        // decode data pduRoot_closeIndQ
                        VString vdata ;
                        IE      ie ;
                        DecodePacketGentic(ie, data.c_str(), data.length());
                        bool    isOk = true ;
                        int     type ;
                        WITH_JUMP(jumpEnv, GENTIC::pdu_read_rootQ(&ie, jumpEnv, type), (isOk = false));
                        if ( isOk ) {
                            switch ( type ) {
                                case newInd_chosen : 
                                    {
                                        VString channelName ;
                                        GENTIC::pdu_read_newIndQ(&ie, 0, channelName);
                                        
                                        // open this channel
                                        eConnection.OpenChannel(channelName);
                                        
                                        // ask to load file
                                        IE  ie ;
                                        IeInitMem(&ie, encodeBuffer, SIZE_BUFFER);
                                        VString currFileName = currentFileName ;
                                        
                                        // read file
                                        EString fileContent ;
                                        {
                                            int readData [512];
                                            int nbRead = 0 ;
                                            int inFile = _open(currentFileName.c_str(), O_RDONLY, 0666);
                                            while ( (nbRead = read(inFile, &readData, 512)) > 0 ) {
                                                fileContent << VString((char *)readData, nbRead);
                                            }
                                            _close(inFile);
                                        }
                                        
                                        // send data
                                        GENTIC::pdu_write_loadRqstQ(&ie, 0, currFileName, fileContent);
                                        unsigned int    sizePacket = EncodePacketGentic(ie, encodeBuffer2, SIZE_BUFFER);
                                        VString         data = VString(encodeBuffer2, sizePacket);
                                        if ( !sizePacket ) 
                                            MetaExit(3, "Invalid encoding \n");
                                        else 
                                            eConnection.SendString(channelName, data);
                                    }
                                    break ;
                                case loadRsps_chosen : 
                                    {
                                        VString channelName ;
                                        GENTIC::pdu_read_loadRspsQ(&ie, 0, channelName);
                                        
                                        // insert this channel in the available computation channel
                                        ExternEvaluator externEvaluator ;
                                        externEvaluator.on = true ;
                                        externEvaluator.channel = channelName ;
                                        
                                        // open this channel
                                        eConnection.OpenChannel(channelName);
                                        
                                        // protected include
                                        tabExternEvaluators.push_back(externEvaluator);
                                        availableCpu.PutRessource(LOAD_PER_CPU);
                                    }
                                    break ;
                                case computeRsps_chosen : 
                                    {
                                        unsigned int    id ;
                                        unsigned int    evaluatorId ;
                                        int             latency ;
                                        int             cadency ;
                                        GENTIC::pdu_read_computeRspsQ(&ie, 0, evaluatorId, id, latency, cadency);
                                        
                                        // suppress element in queues
                                        if ( tabExternEvaluators [evaluatorId].nbTreated ) {
                                            tabExternEvaluators [evaluatorId].nbTreated-- ;
                                            if ( !tabExternEvaluators [evaluatorId].nbTreated && tabExternEvaluators [evaluatorId].nbStore ) {
                                                time_t  diff ;
                                                if ( diff = time(0) - tabExternEvaluators [evaluatorId].startStore ) {
                                                    tabExternEvaluators [evaluatorId].throughPut = (float)diff / tabExternEvaluators [evaluatorId].nbStore ;
                                                    tabExternEvaluators [evaluatorId].nbStore = 0 ;
                                                }
                                            }
                                            INC_INDEX(tabExternEvaluators [evaluatorId].indexRead);
                                            tabExternEvaluators [evaluatorId].lastResult = time(0);
                                            if ( tabExternEvaluators [evaluatorId].on ) 
                                                availableCpu.FreeRessource(1);
                                        }
                                        
                                        // send result
                                        std::map<unsigned int, Board *> ::iterator  iter = tabEvaluatedBoards.find(id);
                                        if ( iter != tabEvaluatedBoards.end() ) {
                                            
                                            // set cost value
                                            double  ret = (double)cadency * CADENCY_FACTOR + (double)latency * LATENCY_FACTOR ;
                                            ret = -ret ;
                                            (*iter).second->Cost(ret);
                                            (*iter).second->Evaluated(true, (*iter).second->GetSemaphop());
                                            
                                            // suppress elem from array
                                            tabEvaluatedBoards.erase(id);
                                        }
                                    }
                                    break ;
                                default : 
                                    {
                                    }
                            }
                        }
                        protectBoard.FreeRessource(1);
                    }
                }
            }
        }
#   endif
    return 0 ;
}

double BoardEvaluator ( bool direct, SchedulerEvaluate *pSched, Board *pBoard )
{
    if ( direct || !nbThread && !distributed ) 
        return pSched->Cost(pBoard);
    else {
        AddWaitingBoards(pBoard);
    }
    return 0.0 ;
}

/*************************************************************************/
/*   ChopTree : chop the tree : here call decomp                         */
/*************************************************************************/
void ChopTree ( EString fileName, bool restart, unsigned int pop, unsigned int stop )
{
    {
        PTREE   tree ;
        EString param1 ;
        EString param2 ;
        memset(pScheduler, 0, sizeof(Scheduler *) * MAX_THREAD);
        if ( fileName == "" ) {
            tree = syndex().ReadFile("exp1.sdx");
            AddRef(tree);
#           if 0
                int i = 1 ;
                while ( i == 1 ) {
                    SLEEP(1);
                }
#           endif
#           if 0
                
                // compute all on same processor 
                EString message ;
                {
                    message = "";
                    message << "*********************************************************\n";
                    message << "All on same processor \n";
                    message << "*********************************************************\n\n";
                    std::cerr << message ;
                    PTREE   tree1 ;
                    tree1 = CopyTree(tree);
                    Scheduler   scheduler (tree1) ;
                    scheduler.Explore();
                    std::vector<unsigned int>               trail = scheduler.RandomTrail();
                    std::vector<unsigned int> ::iterator    iter ;
                    message = "Trail : ";
                    for ( iter = trail.begin() ; iter != trail.end() ; iter++ ) {
                        message << scheduler.GetAlgoByNumber(*iter)->Name() << " ";
                    }
                    message << "\n";
                    std::cerr << message ;
                    scheduler.ComputeAlgoConnectivity();
                    scheduler.DisplayConnectivity();
                    param1 = "top_sensor1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor2";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_mul1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_add1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_zactuator1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_transmitor1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor3";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    scheduler.Schedule();
                    scheduler.DisplaySchedule();
                    message = "";
                    message << "*********************************************************\n";
                    message << "Same after clean \n";
                    message << "*********************************************************\n\n";
                    std::cerr << message ;
                    scheduler.ClearSchedule();
                    scheduler.Schedule();
                    scheduler.DisplaySchedule();
                }
                
                // compute with two processors
                {
                    message = "";
                    message << "\n*********************************************************\n";
                    message << "Two  processors \n";
                    message << "*********************************************************\n\n";
                    std::cerr << message ;
                    PTREE   tree1 ;
                    tree1 = CopyTree(tree);
                    Scheduler   scheduler (tree1) ;
                    scheduler.Explore();
                    param1 = "top_sensor1";
                    param2 = "pentium2";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor2";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_mul1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_add1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_zactuator1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_transmitor1";
                    param2 = "pentium2";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor3";
                    param2 = "pentium2";
                    scheduler.AffectProcessor(param1, param2);
                    scheduler.Schedule();
                    scheduler.DisplaySchedule();
                }
                
                // compute with three processors
                {
                    message = "";
                    message << "\n*********************************************************\n";
                    message << "Three  processors \n";
                    message << "*********************************************************\n\n";
                    std::cerr << message ;
                    PTREE   tree1 ;
                    tree1 = CopyTree(tree);
                    Scheduler   scheduler (tree1) ;
                    scheduler.Explore();
                    param1 = "top_sensor1";
                    param2 = "pentium2";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor2";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_mul1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_add1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_zactuator1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_transmitor1";
                    param2 = "pentium3";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor3";
                    param2 = "pentium3";
                    scheduler.AffectProcessor(param1, param2);
                    scheduler.Schedule();
                    scheduler.DisplaySchedule();
                }
                
                // compute with three processors
                FreeRef(tree);
                tree = syndex().ReadFile("exp2.sdx");
                AddRef(tree);
                
                // compute with three processors
                {
                    message = "";
                    message << "\n*********************************************************\n";
                    message << "Three  processors not all connected\n";
                    message << "*********************************************************\n\n";
                    std::cerr << message ;
                    PTREE   tree1 ;
                    tree1 = CopyTree(tree);
                    Scheduler   scheduler (tree1) ;
                    scheduler.Explore();
                    param1 = "top_sensor1";
                    param2 = "pentium2";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor2";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_mul1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_add1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_zactuator1";
                    param2 = "pentium1";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_transmitor1";
                    param2 = "pentium3";
                    scheduler.AffectProcessor(param1, param2);
                    param1 = "top_sensor3";
                    param2 = "pentium3";
                    scheduler.AffectProcessor(param1, param2);
                    scheduler.Schedule();
                    scheduler.DisplaySchedule();
                }
                FreeRef(tree);
#           endif
            
            // treat files
            TreatFile("exp-32", "exp-32");
            TreatFile("exp3", "5 processors");
            TreatFile("malaxer", "malaxer");
            TreatFile("malaxer1", "malaxer1");
            TreatFile("malaxer2", "malaxer2");
            TreatFile("malaxer2_sc", "malaxer2 using software components");
            TreatFile("matrixmul", "matrixmul");
            TreatFile("simpcond", "simple conditions");
            TreatFile("exp-32c", "exp-32 with conditions");
            TreatFile("exp-32cd", "exp-32 with 2xconditions one at top");
            TreatFile("exp-512", "exp-512");
            TreatFile("RxTCP", "RxTCP");
            TreatFile("exp-2048", "exp-2048");
        } else {
            TreatFile(fileName.c_str(), fileName.c_str(), restart, pop, stop, !noDMA);
        }
    }
}

// TreatFile : treat a file
void TreatFile ( EString name, EString description, bool restart, unsigned int pop, unsigned int stop, bool useDMA )
{
    EString fileName ;
    EString message ;
    time_t  duration ;
    
    RandomInit(0);
    if ( name.substring(name.length() - 4, 4) == ".sdx" ) {
        fileName << name ;
    } else 
        fileName << name << ".sdx";
    
    // set scheduler for extern
    SetExternScheduler(fileName);
    
    // compute with three processors
    PTREE   tree = syndex().ReadFile(fileName.c_str());
    
    // verify that two entities have not the same name 
    {
        PTREE                           listEntities ;
        PTREE                           entity ;
        std::set<EString, LessString>   nameEntities ;
        if ( tree == <SYNDEX_TOP,<>,<>,listEntities> ) {
            while ( entity = nextl(listEntities) ) {
                if ( entity != <MAIN_ALGORITHM> && entity != <MAIN_ARCHITECTURE> && entity != <CONSTRAINTS> ) {
                    
                    // if already in set it is an error
                    VString name (Value(entity)) ;
                    if ( nameEntities.find(name) != nameEntities.end() ) 
                    {
                        EString message ;
                        message << "Duplicate name : " << name << "\n";
                        std::cerr << message ;
                    } else 
                        // add it in set
                        nameEntities.insert(name);
                }
            }
        }
    }
    
    // compute with three processors
    {
        message = "";
        message << "\n*********************************************************\n";
        message << "Optimize with " << description << "\n";
        message << "*********************************************************\n\n";
        std::cerr << message ;
        Scheduler   scheduler (tree) ;
        scheduler.UseDma(useDMA);
        duration = time(0);
        scheduler.Explore();
        duration = time(0) - duration ;
        fileName = "";
        fileName << name << ".out.sdx";
        scheduler.Dump(fileName.c_str());
        
        // display the heads
        std::set<ComputeUnit *> ::iterator  iter ;
        EString                             message ;
        message << "\nNumber of leaf Nodes : " << (int)(scheduler.LeafAlgorithm().size()) << "\n";
        message << "Number of Heads : " << (int)(scheduler.Heads().size()) << "\n\n";
        std::cerr << message ;
        message = "Heads : ";
        for ( iter = scheduler.Heads().begin() ; iter != scheduler.Heads().end() ; iter++ ) {
            message << (*iter)->Name() << " ";
        }
        message << "\n";
        std::cerr << message ;
        
        // set name for schedulere
        if ( name.substring(name.length() - 4, 4) == ".sdx" ) {
            name = name.substring(0, name.length() - 4);
        }
        scheduler.Name(name);
        
        // optimize
        Optimize(scheduler, duration, restart, pop, stop);
    }
}

// Optimize : optimize a scheduler
void Optimize ( Scheduler &scheduler, time_t flatteningTime, bool restart, unsigned int pop, unsigned int stop )
{
    if ( scheduler.Heads().size() <= 0 ) 
        return ;
    
    time_t                                                                                  start = time(0);
    
    // compute the number of parameters to be optimized 
    unsigned int                                                                            nbAlgo = scheduler.LeafAlgorithm().size();
    unsigned int                                                                            nbProc = scheduler.Operators().size();
    
    //     
    Scheduler                                                                               *pScheduler = &scheduler ;
    SchedulerEvaluate                                                                       schedulerEvaluate(&pScheduler);
    BoardNursery                                                                            localNursery(&schedulerEvaluate);
    OptimGenetic<BoardNursery::TypeIndividual, BoardNursery::TypeIndividual::TypeParam>     optimGenetic(localNursery /* the nursery */ 
        , pop ? pop : 300 /* 1200*/ /* 600 */ /* populationSize */ , 60 /* nbMutations */ , 3000000 /* maxgenerations */ 
        , stop ? stop : 100 /*3500*/ /* 5000 */ /* max stable generation*/ , 100000000 /* max simulated vectors */ , 10000000 /* max steady vectors */ 
        , 10 /* pcent of top */ );
    EString                                                                                 message ;
    
    pGenetic = &optimGenetic ;
    std::cerr << "\n" << optimGenetic.Parameters() << "\n";
    message = "";
    message << "Cadency factor : " << CADENCY_FACTOR << "\n";
    message << "Latency factor : " << LATENCY_FACTOR << "\n\n";
    std::cerr << message ;
    message = "";
    newPopulationSize = optimGenetic.NewPopulationSize();
    
    // create an optimisation object
    // suppress clone searching
    EString restartFile ;
    
    if ( restart ) 
        restartFile = RECORD_FILE_NAME ;
    optimGenetic.SuppressClone(false).Vibrato(false).Interactive(interactive).Run(restartFile);
    
    // display best
    BoardNursery::TypeIndividual & bestIndividual = optimGenetic.BestIndividual();
#   if 0
        message << "Best Cost before recompute : " << bestIndividual.Cost() << "\n";
        std::cerr << message ;
#   endif
    bestIndividual.Evaluated(false);
    bestIndividual.Cost();
#   if 0
        message << "Best Cost after recompute : " << bestIndividual.Cost() << "\n";
        std::cerr << message ;
#   endif
    scheduler.DisplaySchedule();
    scheduler.CheckSchedule();
    bestIndividual.DisplayTrail(scheduler);
    
    unsigned int    latency ;
    unsigned int    mean ;
    
    scheduler.Cost(latency, mean);
    message = "";
    message << "\n========================>  latency " << (int)latency << " cadency " << (int)mean << "\n";
    message << "    Best top : " << optimGenetic.OptimCost() << "\n";
    message << "    Nb Simulated : " << optimGenetic.SimulatedVectors() << "\n";
    message << "    Time : " << (int)(time(0) - start) << "\n";
    message << "    Flattening Time : " << (int)flatteningTime << "\n";
    pGenetic = 0 ;
    
    // generate code
    scheduler.GenerateCode();
    
    //    SLEEP(TIME_INDIVIDUAL);
    std::cerr << message ;
}


