/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "komAggregate.h"

KOMAggregate::KOMAggregate( KOM::Component_ptr _com )
{
  m_vParent = KOM::Component::_duplicate( _com );
}

KOMAggregate::~KOMAggregate()
{
  cleanUp();
}

void KOMAggregate::cleanUp()
{
  if ( m_bIsClean )
    return;

  m_vParent = 0L;

  KOMComponent::cleanUp();
}

KOM::ID KOMAggregate::addAggregate( KOM::AggregateFactory_ptr _factory,
				    const KOM::InterfaceSeq& _required,
				    const KOM::InterfaceSeq& _provided,
				    CORBA::Boolean _activate)
{
  return m_vParent->addAggregate( _factory, _required, _provided, _activate );
}

void KOMAggregate::removeAggregate( KOM::ID _id )
{
  m_vParent->removeAggregate( _id );
}

KOM::ID KOMAggregate::addPlugin( KOM::PluginFactory_ptr _factory,
				 const KOM::InterfaceSeq& _required,
				 const KOM::InterfaceSeq& _required_aggregates,
				 const KOM::InterfaceSeq& _provided,
				 CORBA::Boolean _activate)
{
  return m_vParent->addPlugin( _factory, _required, _required_aggregates,
			       _provided, _activate );
}

void KOMAggregate::removePlugin( KOM::ID _id )
{
  m_vParent->removePlugin( _id );
}

CORBA::Object_ptr KOMAggregate::getInterface( const char* name )
{
  return m_vParent->getInterface( name );
}

KOM::InterfaceSeq* KOMAggregate::interfaces()
{
  return m_vParent->interfaces();
}

CORBA::Boolean KOMAggregate::supportsInterface( const char* name )
{
  return m_vParent->supportsInterface( name );
}

CORBA::Object_ptr KOMAggregate::getPluginInterface( const char* name )
{
  return m_vParent->getPluginInterface( name );
}

KOM::InterfaceSeq* KOMAggregate::pluginInterfaces()
{
  return m_vParent->pluginInterfaces();
}

CORBA::Boolean KOMAggregate::supportsPluginInterface( const char* name )
{
  return m_vParent->supportsPluginInterface( name );
}

KOM::Component::PluginInfoSeq* KOMAggregate::describePlugins()
{
  return m_vParent->describePlugins();
}

KOM::Plugin_ptr KOMAggregate::getPlugin( KOM::ID id )
{
  return m_vParent->getPlugin( id );
}

KOM::Component_ptr KOMAggregate::parent()
{
  return KOM::Component::_duplicate( m_vParent );
}
