// -*- c++ -*-
/*
 *  Qt support for MICO
 *  Copyright (C) 1997 Lars Doelle
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 mico@informatik.uni-frankfurt.de
 */

#ifndef __kom_app_h__
#define __kom_app_h__

/*
 * XXX ugly hack to make QApplication::processNextEvent() and
 * QApplication::quit_now accessible to XApplication_impl
 */
#define private protected
#include <qapp.h>
#undef private

#include <qlist.h>
#include <qintdict.h>
#include <qsocknot.h>
#include <qtimer.h>

#include <kapp.h>

#undef None /* Damn X11! */
#include <kom.h>
#include <komComponent.h>

#define komapp_orb KOMApplication::komApplication()->orb()
#define komapp_boa KOMApplication::komApplication()->boa()

class QTDispatcher;
class KOMApplicationIf;

/*********************************************
 *
 * KOMApplication
 *
 *********************************************/

class KOMApplication : public KApplication
{
    friend QTDispatcher;
    
    Q_OBJECT
public:
    KOMApplication( int &argc, char **argv, const QString& rAppName = 0);
    ~KOMApplication();        

    virtual void exec();

    CORBA::BOA_ptr boa() { return pBoa; }
    CORBA::ORB_ptr orb() { return pOrb; }
    
    virtual bool isRestoring() { return pBoa->restoring(); }

    static KOMApplication* komApplication() { return m_pKOMApplication; }
    
protected:
    virtual void start() { }
    virtual void end() { }
    virtual void restore() { }
  
    virtual void impl_is_ready (CORBA::ImplementationDef_ptr);
    virtual void deactivate_impl (CORBA::ImplementationDef_ptr);
    virtual void obj_is_ready (CORBA::Object_ptr, CORBA::ImplementationDef_ptr);
    virtual void deactivate_obj (CORBA::Object_ptr);
    virtual void processNextEvent (bool b);
    virtual void doquit();
    virtual void shutdown( CORBA::Boolean wait );
  
    CORBA::BOA_var pBoa;
    CORBA::ORB_var pOrb;
  
    enum State { Initial, ObjReady, ImplReady };
    State state;
    QTDispatcher* pQtd;

    static KOMApplication *m_pKOMApplication;
};

class KFileNotifier : public QObject
{
    Q_OBJECT
public:
    KFileNotifier ();
    KFileNotifier ( QTDispatcher *_disp, CORBA::DispatcherCallback *_cb,
		    int fd,  QSocketNotifier::Type _evq, CORBA::Dispatcher::Event _evc );
    ~KFileNotifier ();

    QSocketNotifier* xid;
    CORBA::DispatcherCallback *cb;
    QTDispatcher* disp;
    CORBA::Dispatcher::Event ev;

private slots:
    void activated (int /*fd*/);
};

class KTimerNotifier : public QObject
{
    Q_OBJECT
public:
    KTimerNotifier ();
    KTimerNotifier (QTDispatcher* _disp, CORBA::DispatcherCallback *_cb, long tmout);
    ~KTimerNotifier ();

    QTimer* xid;
    CORBA::DispatcherCallback *cb;
    QTDispatcher* disp;

private slots:
    void timeout();
};

class QTDispatcher : public CORBA::Dispatcher
{
public:
    QTDispatcher( KOMApplication* );
    virtual ~QTDispatcher ();

    virtual void rd_event (CORBA::DispatcherCallback *, CORBA::Long fd);
    virtual void wr_event (CORBA::DispatcherCallback *, CORBA::Long fd);
    virtual void ex_event (CORBA::DispatcherCallback *, CORBA::Long fd);
    virtual void tm_event (CORBA::DispatcherCallback *, CORBA::ULong tmout);
    virtual void remove (CORBA::DispatcherCallback *, Event);
    virtual void run (CORBA::Boolean infinite = TRUE);
    virtual void move (CORBA::Dispatcher *);
    virtual CORBA::Boolean idle () const;

    void remove (KTimerNotifier *);

    KOMApplication* gfw;

    list<KFileNotifier*> fevents;
    list<KTimerNotifier*> tevents;
};

/*********************************************
 *
 * KOMApplicationIf
 *
 *********************************************/

class KOMApplicationIf : virtual public KOMComponent,
			 virtual public KOM::Application_skel
{
public:
  KOMApplicationIf();
  KOMApplicationIf( const CORBA::BOA::ReferenceData &refdata );
  KOMApplicationIf( CORBA::Object_ptr _obj );

  virtual ~KOMApplicationIf();
};

/********************************************
 *
 * KOMBoot
 *
 ********************************************/

template<class X>
class KOMBoot : public CORBA::BOAObjectRestorer
{
public:
    KOMBoot( const char *_repoid, const char *_tag )
    { m_strRepoId = _repoid; m_strTag = _tag; }
  
    CORBA::Boolean restore( CORBA::Object_ptr _obj )
    {
      if ( m_strRepoId == _obj->_repoid() )
      {
	cerr << "restoring ... " << endl;
	(void)new X( _obj );
	cerr << "restored ... " << endl;
	return TRUE;
      }
      cout << "cannot restore " << _obj->_repoid() << " objects" << endl;
      return FALSE;
    }

    CORBA::Boolean bind( const char *repoid, const CORBA::ORB::ObjectTag &tag )
    {
      if ( strcmp( repoid, m_strRepoId ) == 0 )
      {
	CORBA::String_var str;
	str = komapp_orb->tag_to_string( tag );
	if ( strcmp( str.in(), m_strTag ) != 0L )
	  return FALSE;
	
	cerr << "creating " << str.in() << " ... " << endl;
	(void)new X( tag );
	return TRUE;
      }
      return FALSE;
    }

protected:
  QString m_strRepoId;
  QString m_strTag;
};

#endif // __kom_app_h__
