#!/usr/local/bin/python

# Qt tutorial 5.

import sys
from kde import *


class MyWidget(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.setMinimumSize(200,200)

		self.quit = QPushButton("Quit",self,"quit")
		self.quit.setGeometry(10,10,75,30)
		self.quit.setFont(QFont("Times",18,QFontWeight.Bold))

		connect(self.quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

		self.lcd = QLCDNumber(2,self,"lcd")
		self.lcd.move(10,self.quit.y() + self.quit.height() + 10)

		self.sBar = QScrollBar(0,99,1,10,0,QScrollBarOrientation.Horizontal,self,"scrollbar")

		connect(self.sBar,SIGNAL("valueChanged(int)"),self.lcd,SLOT("display(int)"))

	def resizeEvent(self,resizeEvent):
		self.sBar.setGeometry(10,self.height() - 10 - 16,self.width() - 20,16)
		self.lcd.resize(self.sBar.width(),self.sBar.y() - self.lcd.y() - 5)


qApp = a = QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,200,200)
a.setMainWidget(w)
w.show()
a.exec_loop()
