#!/usr/local/bin/python

# Qt tutorial 8.

import sys
from kde import *


class LCDRange(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.lcd = QLCDNumber(2,self,"lcd")
		self.lcd.move(0,0)
		self.sBar = QScrollBar(0,99, \
				       1,10, \
				       0, \
				       QScrollBarOrientation.Horizontal, \
				       self,"scrollbar")
		connect(self.sBar,SIGNAL("valueChanged(int)"),self.lcd,SLOT("display(int)"))
		connect(self.sBar,SIGNAL("valueChanged(int)"),self,PYSIGNAL("valueChanged(int)"))

	def value(self):
		return self.sBar.value()

	def setValue(self,value):
		self.sBar.setValue(value)

	def setRange(self,minVal,maxVal):
		if minVal < 0 or maxVal > 99 or minVal > maxVal:
			raise ValueError, "LCDRange.setRange(): invalid range"
		self.sBar.setRange(minVal,maxVal)

	def resizeEvent(self,resizeEvent):
		self.lcd.resize(self.width(),self.height() - 16 - 5)
		self.sBar.setGeometry(0,self.lcd.height() + 5,self.width(),16)


class CannonField(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.ang = 45

	def angle(self):
		return self.ang

	def setAngle(self,degrees):
		if degrees < 5:
			degrees = 5
		if degrees > 70:
			degrees = 70
		if self.ang == degrees:
			return
		self.ang = degrees
		self.repaint()
		self.emit(PYSIGNAL("angleChanged"),(self.ang,))

	def paintEvent(self,QPaintEvent):
		s = 'Angle = ' + `self.ang`
		self.drawText(200,100,s)


class MyWidget(QWidget):
	def __init__(self,*args):
		apply(QWidget.__init__,(self,) + args)

		self.setMinimumSize(500,355)

		self.quit = QPushButton("Quit",self,"quit")
		self.quit.setGeometry(10,10,75,30)
		self.quit.setFont(QFont("Times",18,QFontWeight.Bold))
		connect(self.quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

		self.angle = LCDRange(self,"angle")
		self.angle.setRange(5,70)
		self.angle.setGeometry(10,self.quit.y() + self.quit.height() + 10,75,130)

		self.cannonField = CannonField(self,"cannonField")
		self.cannonField.move(self.angle.x() + self.angle.width() + 10,self.angle.y())
		self.cannonField.setBackgroundColor(QColor(250,250,200))

		connect(self.angle,PYSIGNAL("valueChanged(int)"),self.cannonField.setAngle)
		connect(self.cannonField,PYSIGNAL("angleChanged"),self.angle.setValue)

		self.angle.setValue(60)

	def resizeEvent(self,resizeEvent):
		self.cannonField.resize(self.width() - self.cannonField.x() - 10, \
					self.height() - self.cannonField.y() - 10)


qApp = a = QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,500,355)
a.setMainWidget(w)
w.show()
a.exec_loop()
