/*
 *  Qt support for MICO
 *
 *  Original version by
 *  Copyright (C) 1997 Lars Doelle
 *
 *  OPApplication done by Torben Weis, weis@kde.org
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 mico@informatik.uni-frankfurt.de
 */

#include <config.h>
#include "opApplication.h"
#include "opPart.h"

#include <CORBA.h>
#include <mico/template_impl.h>
#ifdef HAVE_MINI_STL
#include <ministl/algorithm>
#else
#include <algorithm>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>

// DEBUG
#include <iostream>

OPApplication* OPApplication::s_pOPApplication = 0L;

OPApplication::OPApplication( int &argc, char **argv, 
			      const QString& rAppName) : 
    KOMApplication( argc, argv, rAppName )
{
  s_pOPApplication = this;
}

OPApplication::~OPApplication()
{
}

bool OPApplication::x11EventFilter( XEvent *ev )
{
  if ( ev->type == ButtonPress )
  {
    QWidget *w = QWidget::find( ev->xany.window );
    if ( w == 0L )
      return false;

    // if ( isFrame( w ) )
    // return false;
    
    // Find the toplevel widget
    QWidget *top = w->topLevelWidget();
    if ( top == 0L )
      return false; 

    list<OPPartIf*>::iterator it = OPPartIf::begin();
    for( ; it != OPPartIf::end(); ++it )
    {
      if ( (*it)->widget() == top )
      {
	cerr << "PART clicked" << endl;
	if ( (*it)->hasFocus() )
	{    
	  cerr << "PART has focus" << endl;
	  return false;
	}
	if ( (*it)->focusPolicy() == OpenParts::Part::NoFocus )
	  return false;
	cerr << "PART does not have focus" << endl;
	OpenParts::MainWindow_var main = (*it)->mainWindow();
	if ( CORBA::is_nil( main ) )
	  return false;
	XButtonEvent* be = (XButtonEvent*)ev;
	CORBA::Long button;
	if ( be->button == Button1Mask )
	  button = LeftButton;
	if ( be->button == Button2Mask )
	  button = MidButton;
	if ( be->button == Button3Mask )
	  button = RightButton;
	return main->partClicked( (*it)->id(), button );
	// return true;
      }
    }
  }

  return false;
}

/********************************************
 *
 * OPApplicationIf
 *
 ********************************************/

OPApplicationIf::OPApplicationIf()
{
}

OPApplicationIf::OPApplicationIf( const CORBA::BOA::ReferenceData &refdata ) :
  OpenParts::Application_skel( refdata )
{
} 

OPApplicationIf::OPApplicationIf( CORBA::Object_ptr _obj ) :
  OpenParts::Application_skel( _obj )
{
}
  
OpenParts::Document_ptr OPApplicationIf::createDoc()
{
  return 0L;
}

OpenParts::Part_ptr OPApplicationIf::createPart()
{
  return 0L;
}

OpenParts::MainWindow_ptr OPApplicationIf::createWindow()
{
  return 0L;
}

#include "opApplication.moc"
